/*
 * Decompiled with CFR 0.152.
 */
package com;

import javax.servlet.MultipartConfigElement;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.netflix.zuul.EnableZuulProxy;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.annotation.EnableAsync;

@SpringBootApplication
@EnableZuulProxy
@EnableDiscoveryClient
@EnableFeignClients
@ComponentScan(value={"com.byh"})
@EnableAsync
public class ByhServiceZuulApplication {
    @Value(value="${maxFileSize}")
    private String maxFileSize;
    @Value(value="${maxRequestSize}")
    private String maxRequestSize;

    public static void main(String[] args) {
        SpringApplication.run(ByhServiceZuulApplication.class, (String[])args);
    }

    @Bean
    @ConfigurationProperties(value="zuul")
    @Primary
    @RefreshScope
    public ZuulProperties zuulProperties() {
        return new ZuulProperties();
    }

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize(this.maxFileSize);
        factory.setMaxRequestSize(this.maxRequestSize);
        factory.setFileSizeThreshold("1MB");
        factory.setLocation("/");
        return factory.createMultipartConfig();
    }
}

