/*
 * Decompiled with CFR 0.152.
 */
package com.byh.zuul.config;

import com.alibaba.fastjson.JSON;
import com.byh.zuul.dao.IgnoreMapper;
import com.byh.zuul.enums.Constants;
import com.byh.zuul.utils.RedisUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"redisUtil"})
@Configuration
public class AuthorityConfig {
    private static final Logger log = LoggerFactory.getLogger(AuthorityConfig.class);
    @Autowired
    private IgnoreMapper ignoreUrlMapper;
    private String appCode = "cloud";
    private List<String> ignoreUrlList = new ArrayList();
    private List<String> whiteIpList = new ArrayList();

    @PostConstruct
    public void init() {
        log.info("\u7cfb\u7edf\u542f\u52a8\u4e2d\u3002\u3002\u3002\u52a0\u8f7d\u767d\u540d\u5355");
        this.getAll(Constants.TYPE_ONE);
        this.getAll(Constants.TYPE_TWO);
    }

    private void getAll(Integer status) {
        List all = this.ignoreUrlMapper.getAll(status, this.appCode);
        if (status.equals(Constants.TYPE_ONE)) {
            this.putUrl(all);
        }
        if (status.equals(Constants.TYPE_TWO)) {
            this.putIp(all);
        }
    }

    public synchronized void putUrl(List<String> all) {
        if (all == null || all.isEmpty()) {
            return;
        }
        this.ignoreUrlList.addAll(all);
        log.info("\u7cfb\u7edf\u542f\u52a8\u4e2d\u3002\u3002\u3002\u52a0\u8f7dURl\u767d\u540d\u5355{}", (Object)JSON.toJSONString((Object)this.ignoreUrlList));
        RedisUtil.set((String)"cloud_whiteUrlList_key", (String)JSON.toJSONString((Object)this.ignoreUrlList));
    }

    public synchronized void putIp(List<String> all) {
        if (all == null || all.isEmpty()) {
            return;
        }
        this.whiteIpList.addAll(all);
        log.info("\u7cfb\u7edf\u542f\u52a8\u4e2d\u3002\u3002\u3002\u52a0\u8f7dIP\u767d\u540d\u5355{}", (Object)JSON.toJSONString((Object)this.whiteIpList));
        RedisUtil.set((String)"cloud_whiteIpList_key", (String)JSON.toJSONString((Object)this.whiteIpList));
    }

    public void set(String name, Integer status) {
        if (status.equals(Constants.TYPE_ONE)) {
            String urlString = RedisUtil.get((String)"cloud_whiteUrlList_key");
            List urlList = JSON.parseArray((String)urlString, String.class);
            urlList.add(name);
            RedisUtil.set((String)"cloud_whiteUrlList_key", (String)JSON.toJSONString((Object)urlList));
        }
        if (status.equals(Constants.TYPE_TWO)) {
            String ipString = RedisUtil.get((String)"cloud_whiteIpList_key");
            List ipList = JSON.parseArray((String)ipString, String.class);
            ipList.add(name);
            RedisUtil.set((String)"cloud_whiteIpList_key", (String)JSON.toJSONString((Object)ipList));
        }
    }

    public void del(String name, Integer status) {
        if (status.equals(Constants.TYPE_ONE)) {
            String urlString = RedisUtil.get((String)"cloud_whiteUrlList_key");
            List urlList = JSON.parseArray((String)urlString, String.class);
            urlList.remove(name);
            log.info("\u5220\u9664\u767d\u540d\u5355\u3002\u3002\u3002\u66f4\u65b0URl\u767d\u540d\u5355{}", (Object)JSON.toJSONString((Object)urlList));
            RedisUtil.set((String)"cloud_whiteUrlList_key", (String)JSON.toJSONString((Object)urlList));
        }
        if (status.equals(Constants.TYPE_TWO)) {
            String ipString = RedisUtil.get((String)"cloud_whiteIpList_key");
            List ipList = JSON.parseArray((String)ipString, String.class);
            ipList.remove(name);
            log.info("\u5220\u9664\u767d\u540d\u5355\u3002\u3002\u3002\u66f4\u65b0IP\u767d\u540d\u5355{}", (Object)JSON.toJSONString((Object)ipList));
            RedisUtil.set((String)"cloud_whiteIpList_key", (String)JSON.toJSONString((Object)ipList));
        }
    }

    public void update(String deleteName, String addName, Integer status) {
        if (status.equals(Constants.TYPE_ONE)) {
            String urlString = RedisUtil.get((String)"cloud_whiteUrlList_key");
            List urlList = JSON.parseArray((String)urlString, String.class);
            urlList.remove(deleteName);
            urlList.add(addName);
            log.info("\u66f4\u65b0\u767d\u540d\u5355\u3002\u3002\u3002\u66f4\u65b0URl\u767d\u540d\u5355{}", (Object)JSON.toJSONString((Object)urlList));
            RedisUtil.set((String)"cloud_whiteUrlList_key", (String)JSON.toJSONString((Object)urlList));
        }
        if (status.equals(Constants.TYPE_TWO)) {
            String ipString = RedisUtil.get((String)"cloud_whiteIpList_key");
            List ipList = JSON.parseArray((String)ipString, String.class);
            ipList.remove(deleteName);
            ipList.add(addName);
            log.info("\u6dfb\u52a0\u767d\u540d\u5355\u3002\u3002\u3002\u66f4\u65b0IP\u767d\u540d\u5355{}", (Object)JSON.toJSONString((Object)ipList));
            RedisUtil.set((String)"cloud_whiteIpList_key", (String)JSON.toJSONString((Object)ipList));
        }
    }

    public IgnoreMapper getIgnoreUrlMapper() {
        return this.ignoreUrlMapper;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public List<String> getIgnoreUrlList() {
        return this.ignoreUrlList;
    }

    public List<String> getWhiteIpList() {
        return this.whiteIpList;
    }

    public void setIgnoreUrlMapper(IgnoreMapper ignoreUrlMapper) {
        this.ignoreUrlMapper = ignoreUrlMapper;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public void setIgnoreUrlList(List<String> ignoreUrlList) {
        this.ignoreUrlList = ignoreUrlList;
    }

    public void setWhiteIpList(List<String> whiteIpList) {
        this.whiteIpList = whiteIpList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthorityConfig)) {
            return false;
        }
        AuthorityConfig other = (AuthorityConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        IgnoreMapper this$ignoreUrlMapper = this.getIgnoreUrlMapper();
        IgnoreMapper other$ignoreUrlMapper = other.getIgnoreUrlMapper();
        if (this$ignoreUrlMapper == null ? other$ignoreUrlMapper != null : !this$ignoreUrlMapper.equals(other$ignoreUrlMapper)) {
            return false;
        }
        String this$appCode = this.getAppCode();
        String other$appCode = other.getAppCode();
        if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
            return false;
        }
        List this$ignoreUrlList = this.getIgnoreUrlList();
        List other$ignoreUrlList = other.getIgnoreUrlList();
        if (this$ignoreUrlList == null ? other$ignoreUrlList != null : !((Object)this$ignoreUrlList).equals(other$ignoreUrlList)) {
            return false;
        }
        List this$whiteIpList = this.getWhiteIpList();
        List other$whiteIpList = other.getWhiteIpList();
        return !(this$whiteIpList == null ? other$whiteIpList != null : !((Object)this$whiteIpList).equals(other$whiteIpList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthorityConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IgnoreMapper $ignoreUrlMapper = this.getIgnoreUrlMapper();
        result = result * 59 + ($ignoreUrlMapper == null ? 43 : $ignoreUrlMapper.hashCode());
        String $appCode = this.getAppCode();
        result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
        List $ignoreUrlList = this.getIgnoreUrlList();
        result = result * 59 + ($ignoreUrlList == null ? 43 : ((Object)$ignoreUrlList).hashCode());
        List $whiteIpList = this.getWhiteIpList();
        result = result * 59 + ($whiteIpList == null ? 43 : ((Object)$whiteIpList).hashCode());
        return result;
    }

    public String toString() {
        return "AuthorityConfig(ignoreUrlMapper=" + this.getIgnoreUrlMapper() + ", appCode=" + this.getAppCode() + ", ignoreUrlList=" + this.getIgnoreUrlList() + ", whiteIpList=" + this.getWhiteIpList() + ")";
    }
}

