/*
 * Decompiled with CFR 0.152.
 */
package com.byh.zuul.filter;

import com.netflix.client.ClientException;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorFilter
extends ZuulFilter {
    private static final String ERROR_STATUS_CODE_KEY = "error.status_code";
    private static Logger log = LoggerFactory.getLogger(ErrorFilter.class);
    public static final String DEFAULT_ERR_MSG = "\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5";

    public String filterType() {
        return "error";
    }

    public int filterOrder() {
        return 0;
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        log.info(ctx.getRequest().getRequestURL() + "");
        return true;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        log.info("\u8fdb\u5165\u5f02\u5e38\u8fc7\u6ee4\u5668");
        try {
            HttpServletRequest request = ctx.getRequest();
            int statusCode = (Integer)ctx.get((Object)ERROR_STATUS_CODE_KEY);
            String message = (String)ctx.get((Object)"error.message");
            if (ctx.containsKey((Object)"error.exception")) {
                Exception e = (Exception)ctx.get((Object)"error.exception");
                Throwable re = this.getOriginException((Throwable)e);
                if (re instanceof ConnectException) {
                    message = "Real Service Connection refused";
                    log.warn("uri:{},error:{}", (Object)request.getRequestURI(), (Object)re.getMessage());
                } else if (re instanceof SocketTimeoutException) {
                    message = "Real Service Timeout";
                    log.warn("uri:{},error:{}", (Object)request.getRequestURI(), (Object)re.getMessage());
                } else if (re instanceof ClientException) {
                    message = re.getMessage();
                    log.warn("uri:{},error:{}", (Object)request.getRequestURI(), (Object)re.getMessage());
                } else {
                    log.warn("ErrorEnum during filtering", (Throwable)e);
                }
            }
            if (StringUtils.isBlank((CharSequence)message)) {
                message = DEFAULT_ERR_MSG;
            }
            request.setAttribute("javax.servlet.error.status_code", (Object)statusCode);
            request.setAttribute("javax.servlet.error.message", (Object)message);
        }
        catch (Exception e) {
            String error = "ErrorEnum during filtering[ErrorFilter]";
            log.error(error, (Throwable)e);
        }
        return null;
    }

    private Throwable getOriginException(Throwable e) {
        e = e.getCause();
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }
}

