/*
 * Decompiled with CFR 0.152.
 */
package com.byh.zuul.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.zuul.config.RequestWrapper;
import com.byh.zuul.dao.TokenJson;
import com.byh.zuul.enums.Constants;
import com.byh.zuul.enums.ErrorEnum;
import com.byh.zuul.feign.CloudValidFeignClient;
import com.byh.zuul.service.IgnoreService;
import com.byh.zuul.utils.RedisUtil;
import com.doctoruser.api.pojo.vo.TokenCheckReqVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.sysinfocloudclient.SuperAdminClient;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@RefreshScope
public class MyFilter
extends ZuulFilter {
    private static final Logger log = LoggerFactory.getLogger(MyFilter.class);
    public static final String CLOUD_AUTH = "cloudAuth";
    public static final String INTEGRATED_MANAGEMENT = "integratedManagement";
    public static final String LARGE_TERMINAL = "largeTerminal";
    public static final String DOCTOR_WEB = "doctor_web";
    public static final String CHANNEL_SOURCE = "channelSource";
    public static final String APP_CHANNEL = "appChannel";
    public static final String LR_NODE = "LR";
    public static final String YCRMYY_NODE = "YCRMYY";
    public static final String NCEFY_NODE = "NCEFY";
    public static final String APP_CODE = "appCode";
    @Autowired
    private SuperAdminClient superAdminClient;
    @Autowired
    private CloudValidFeignClient cloudValidFeignClient;
    @Autowired
    private IgnoreService ignoreService;

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return 0;
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        List whiteIpList = null;
        List whiteUrlList = null;
        String whiteIpString = RedisUtil.get((String)"cloud_whiteIpList_key");
        if (StringUtils.isEmpty((CharSequence)whiteIpString)) {
            whiteIpList = this.ignoreService.getAllName(Constants.TYPE_TWO);
            RedisUtil.set((String)"cloud_whiteIpList_key", (String)JSON.toJSONString((Object)whiteIpList));
        } else {
            whiteIpList = JSON.parseArray((String)whiteIpString, String.class);
        }
        String whiteUrlSltring = RedisUtil.get((String)"cloud_whiteUrlList_key");
        if (StringUtils.isEmpty((CharSequence)whiteUrlSltring)) {
            whiteUrlList = this.ignoreService.getAllName(Constants.TYPE_ONE);
            RedisUtil.set((String)"cloud_whiteUrlList_key", (String)JSON.toJSONString((Object)whiteUrlList));
        } else {
            whiteUrlList = JSON.parseArray((String)whiteUrlSltring, String.class);
        }
        String requestIP = MyFilter.getIpAddress((HttpServletRequest)request);
        String urlAddress = this.getUrlAddress(request);
        log.info("\u8bf7\u6c42\u6765\u6e90\u7684ip\u5730\u5740:{},\u8bf7\u6c42\u6765\u6e90\u7684URL:{}", (Object)requestIP, (Object)urlAddress);
        boolean containIP = whiteIpList.contains(requestIP);
        boolean containsUrl = whiteUrlList.contains(urlAddress);
        if (!containIP && !containsUrl) {
            return true;
        }
        log.info("\u767d\u540d\u5355IP\u5185\u7684URL\u8c03\u7528: [{}]", (Object)(request.getMethod() + ", " + request.getRequestURL().toString()));
        return false;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        log.info(String.format("%s >>> %s", request.getMethod(), request.getRequestURL().toString()));
        if ("true".equals(request.getAttribute("auth"))) {
            log.info("\u4e0d\u9700\u8981\u9a8c\u8bc1--------------------------------------------------");
            ctx.addZuulResponseHeader("X-Logged-In", "false");
            return null;
        }
        this.validateToken(ctx, request);
        this.validateDataSign(ctx, request);
        return null;
    }

    private void validateDataSign(RequestContext ctx, HttpServletRequest request) {
        RequestContext currentContext = RequestContext.getCurrentContext();
        boolean resourceAccesFiltersFlag = currentContext.getBoolean("resource_access_filter_flag", Boolean.FALSE.booleanValue());
        if (resourceAccesFiltersFlag) {
            return;
        }
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            log.info(name + ":" + request.getHeader(name));
        }
        String channelSource = request.getHeader("channelSource");
        String doctorWeb = request.getHeader("appChannel");
        String cloudAuth = request.getHeader("cloudAuth");
        String appCode = request.getHeader("appCode");
        String sign = request.getHeader("signMsg");
        if (StringUtils.isBlank((CharSequence)sign)) {
            HttpServletResponse response = ctx.getResponse();
            response.setContentType("text/html;charset=utf-8");
            ctx.setSendZuulResponse(false);
            ctx.setResponseStatusCode(200);
            ctx.setResponseBody("{\"data\":\"unauthorized\",\"code\":1110004, \"msg\":\"\u6570\u636e\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\"}");
            return;
        }
        RequestWrapper requestWrapper = new RequestWrapper(request);
        String param = "";
        String body = requestWrapper.getBody();
        String getParam = MyFilter.getParamOfMethodGet((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)getParam)) {
            param = getParam;
            try {
                param = URLDecoder.decode(param, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u89e3\u7801\u53c2\u6570\u5f02\u5e38\uff1a " + e.getMessage());
            }
            log.info("get\u8bf7\u6c42\uff1a" + param + "--------------------");
        } else {
            param = body;
            if (param.contains("=") && !param.contains(":")) {
                param = MyFilter.convertParam((String)param);
                try {
                    param = URLDecoder.decode(param, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.error("\u89e3\u7801\u53c2\u6570\u5f02\u5e38\uff1a " + e.getMessage());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)request.getContentType()) && request.getContentType().contains("multipart")) {
                param = "";
            }
            log.info("post\u8bf7\u6c42\uff1a" + param + "--------------------");
        }
        if (StringUtils.isNotBlank((CharSequence)param)) {
            String _signMsg = null;
            try {
                log.info("md5\u53c2\u6570\u52a0\u5bc6\u524d\u539f\u6587 => {}", (Object)param);
                _signMsg = this.md5(param);
            }
            catch (Exception e) {
                log.error("md5\u53c2\u6570\u52a0\u5bc6\u5931\u8d25 => {}", (Object)e.getMessage());
            }
            if (!_signMsg.equals(sign)) {
                log.info("\u53c2\u6570\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff1a \u4f20\u53c2\u4e3a->{},  \u8ba1\u7b97\u5f97\u5230\u7684\u7ed3\u679csign->{},  \u524d\u7aef\u4f20\u9012sign->{}", new Object[]{param, _signMsg, sign});
                HttpServletResponse response = ctx.getResponse();
                response.setContentType("text/html;charset=utf-8");
                ctx.setSendZuulResponse(false);
                ctx.setResponseStatusCode(200);
                ctx.setResponseBody("{\"data\":\"unauthorized\",\"code\":1110004, \"msg\":\"\u6570\u636e\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\"}");
            } else {
                log.info("\u53c2\u6570\u7b7e\u540d\u6821\u9a8c\u6210\u529f\uff1a sign->{}", (Object)sign);
            }
        }
    }

    private void validateToken(RequestContext ctx, HttpServletRequest request) {
        try {
            BaseResponse baseResponse = new BaseResponse();
            String token = request.getHeader("token");
            String uri = request.getRequestURI();
            String cloudAuth = request.getHeader("cloudAuth");
            String channelSource = request.getHeader("channelSource");
            if (null == token) {
                log.info("token\u83b7\u53d6\u5931\u8d25--------------------------------------------------");
                ctx.setSendZuulResponse(false);
                ctx.setResponseStatusCode(200);
                ctx.setResponseBody("{\"code\":1110001,\"msg\":\"unauthorized\"}");
                return;
            }
            ctx.addZuulResponseHeader("X-Logged-In", "true");
            if (StringUtils.isNotBlank((CharSequence)cloudAuth) && "cloudAuth".equals(cloudAuth)) {
                log.info("super user admin auth token validate: ");
                baseResponse = this.superAdminClient.BaseResponsevalidateToken(token);
                log.info(baseResponse.toString());
                ctx.set("byhApplication", (Object)"super_application");
                this.saveLoggingStored(baseResponse, ctx);
            } else if (StringUtils.isNotBlank((CharSequence)channelSource) && "largeTerminal".equals(channelSource)) {
                log.info("large terminal auth token validate: ");
                ctx.set("byhApplication", (Object)"patient_application");
                baseResponse = this.customerTerminalTokenValidate(token);
            } else if (StringUtils.isNotBlank((CharSequence)channelSource) && "integratedManagement".equals(channelSource)) {
                log.info("\u8fdb\u5165V2\u7248\u672c\u7ba1\u7406\u7aeftoken\u6821\u9a8c===token:{}===uri:{}", (Object)token, (Object)uri);
                log.info("integrated management auth token validate: ");
                ctx.set("byhApplication", (Object)"admin_application");
                baseResponse = this.customerTerminalTokenValidateV2(token, uri, ctx);
            } else {
                ctx.set("byhApplication", (Object)"doctor_application");
                log.info("doctor auth token validate: ");
                baseResponse = this.doctorTokenValidate(token);
                this.saveLoggingStored(baseResponse, ctx);
            }
            String errorCode = baseResponse.getErrCode();
            if (ErrorEnum.NO_PERMISSION.getErrCode().equals(errorCode)) {
                HttpServletResponse response = ctx.getResponse();
                response.setContentType("text/html;charset=utf-8");
                ctx.setSendZuulResponse(false);
                ctx.setResponseStatusCode(200);
                ctx.setResponseBody("{\"data\":\"unauthorized\",\"code\":1110001, \"msg\":\"" + baseResponse.getMsg() + "\"}");
            } else if ("0".equalsIgnoreCase(baseResponse.getCode())) {
                HttpServletResponse response = ctx.getResponse();
                response.setContentType("text/html;charset=utf-8");
                ctx.setSendZuulResponse(false);
                ctx.setResponseStatusCode(200);
                ctx.setResponseBody("{\"data\":\"unauthorized\",\"code\":1110001, \"msg\":\"" + baseResponse.getMsg() + "\"}");
            }
            log.info("\u7f51\u5173\u6743\u9650\u6821\u9a8c\u6d41\u7a0b\u5b8c\u6210,baseResponse: [{}]", (Object)baseResponse.toString());
        }
        catch (Exception e) {
            ctx.setSendZuulResponse(false);
            ctx.setResponseStatusCode(200);
            ctx.setResponseBody("{\"code\":1110001,\"msg\":\"unauthorized\"}");
            log.error("\u6743\u9650\u670d\u52a1\u53c2\u6570\u89e3\u6790\u5f02\u5e38:" + e);
        }
    }

    private BaseResponse customerTerminalTokenValidate(String token) {
        TokenCheckReqVO tokenCheckReqVO = new TokenCheckReqVO();
        tokenCheckReqVO.setCustomerFlag(Boolean.valueOf(true));
        tokenCheckReqVO.setToken(token);
        tokenCheckReqVO.setChannelCode("byh_customer");
        BaseResponse baseResponse = this.cloudValidFeignClient.tokenCheck(tokenCheckReqVO);
        return baseResponse;
    }

    private BaseResponse customerTerminalTokenValidateV2(String token, String url, RequestContext currentContext) {
        log.info("\u8fdb\u5165\u4e91\u4e0a\u7f51\u5173=====\u53c2\u6570:token:[" + token + "],url:[" + url + "]");
        TokenCheckReqVO tokenCheckReqVO = new TokenCheckReqVO();
        tokenCheckReqVO.setCustomerFlag(Boolean.valueOf(true));
        tokenCheckReqVO.setToken(token);
        tokenCheckReqVO.setUri(url);
        tokenCheckReqVO.setChannelCode("byh_customer");
        BaseResponse baseResponse = this.cloudValidFeignClient.tokenCheckV2(tokenCheckReqVO);
        log.info("\u4e91\u4e0a\u7f51\u5173\u6d41\u7a0b\u7ed3\u675f====\u8c03\u7528\u8fd4\u56de\u503c\u4e3aBaseResponse-->{}", (Object)JSON.toJSONString((Object)baseResponse));
        this.saveLoggingStored(baseResponse, currentContext);
        return baseResponse;
    }

    private void saveLoggingStored(BaseResponse baseResponse, RequestContext currentContext) {
        if (baseResponse.isSuccess() && baseResponse.getData() != null && !"true".equals(baseResponse.getData().toString())) {
            HttpServletRequest request = currentContext.getRequest();
            Object data = baseResponse.getData();
            String json = ((Map)JSON.parseObject((String)JSON.toJSONString((Object)data), Map.class)).get("tokenJson").toString();
            Map map = (Map)JSON.parseObject((String)json, Map.class);
            TokenJson tokenJson = new TokenJson();
            String byhApplication = (String)currentContext.get((Object)"byhApplication");
            if (Objects.equals(byhApplication, "doctor_application")) {
                tokenJson.setName("\u533b\u751f\u7aef");
                tokenJson.setAccountNo(map.get("accountId").toString());
            } else {
                tokenJson.setName(map.get("name").toString());
                tokenJson.setAccountNo(map.get("accountNo").toString());
            }
            this.ignoreService.loggingStored(tokenJson, currentContext, request.getRequestURL().toString());
        }
    }

    private BaseResponse doctorTokenValidate(String token) {
        TokenCheckReqVO tokenCheckReqVO = new TokenCheckReqVO();
        tokenCheckReqVO.setCustomerFlag(Boolean.valueOf(false));
        tokenCheckReqVO.setToken(token);
        tokenCheckReqVO.setChannelCode("byh_doctor");
        BaseResponse baseResponse = this.cloudValidFeignClient.tokenCheck(tokenCheckReqVO);
        return baseResponse;
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        log.info("ip list->{}", (Object)ip);
        if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip) && ip.indexOf(",") != -1) {
            ip = ip.split(",")[0];
        }
        return ip;
    }

    private String getUrlAddress(HttpServletRequest request) {
        String contextPath = request.getRequestURI();
        return contextPath;
    }

    private String md5(String data) {
        String stringToMD5 = DigestUtils.md5Hex((String)data);
        String md5codeBefore = stringToMD5.substring(0, 12);
        String md5codeRemaining = stringToMD5.substring(12, stringToMD5.length());
        String md5codeAfter = stringToMD5.substring(stringToMD5.length() - 10);
        String md5codeResults = md5codeRemaining.substring(0, md5codeRemaining.length() - 10);
        String stringToMD5New = DigestUtils.md5Hex((String)(md5codeAfter + md5codeResults + md5codeBefore));
        return stringToMD5New;
    }

    public static String getParamOfMethodGet(HttpServletRequest request) {
        if (null == request.getQueryString()) {
            return "";
        }
        String param = URLDecoder.decode(request.getQueryString());
        param = MyFilter.convertParam((String)param);
        return param;
    }

    public static String convertParam(String param) {
        Object[] params = param.split("&");
        Arrays.sort(params);
        JSONObject json = new JSONObject(true);
        for (int i = 0; i < params.length; ++i) {
            String key = "";
            String value = "";
            key = ((String)params[i]).split("=")[0];
            if (((String)params[i]).split("=").length > 1) {
                value = ((String)params[i]).split("=")[1];
                json.put(key, (Object)value);
                continue;
            }
            json.put(key, (Object)"");
        }
        return StringEscapeUtils.unescapeJavaScript((String)json.toString());
    }
}

