/*
 * Decompiled with CFR 0.152.
 */
package com.byh.zuul.service.impl;

import com.alibaba.fastjson.JSON;
import com.byh.zuul.config.AuthorityConfig;
import com.byh.zuul.config.RequestWrapper;
import com.byh.zuul.dao.IgnoreMapper;
import com.byh.zuul.dao.IgnoreVo;
import com.byh.zuul.dao.LoginResVo;
import com.byh.zuul.dao.TokenJson;
import com.byh.zuul.filter.MyFilter;
import com.byh.zuul.service.IgnoreService;
import com.byh.zuul.utils.RedisUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.netflix.zuul.context.RequestContext;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class IgnoreServiceImpl
implements IgnoreService {
    private static final Logger log = LoggerFactory.getLogger(IgnoreServiceImpl.class);
    @Autowired
    private IgnoreMapper ignoreUrlMapper;
    @Autowired
    private AuthorityConfig authorityConfig;

    public List<IgnoreVo> getListByStatus(Integer status) {
        String appCode = this.authorityConfig.getAppCode();
        log.info("appCode==>{}", (Object)appCode);
        return this.ignoreUrlMapper.getListByStatus(status, appCode);
    }

    public List<String> getAllName(Integer status) {
        String appCode = this.authorityConfig.getAppCode();
        log.info("appCode==>{}", (Object)appCode);
        return this.ignoreUrlMapper.getAll(status, appCode);
    }

    public BaseResponse delete(Long id) {
        IgnoreVo ignoreVo = this.ignoreUrlMapper.getById(id);
        log.info("ignoreVo==>{}", (Object)JSON.toJSONString((Object)ignoreVo));
        this.ignoreUrlMapper.delete(id);
        this.authorityConfig.del(ignoreVo.getName(), ignoreVo.getStatus());
        return BaseResponse.success();
    }

    public BaseResponse update(Long id, String name) {
        IgnoreVo ignoreVo = this.ignoreUrlMapper.getById(id);
        log.info("ignoreVo==>{}", (Object)JSON.toJSONString((Object)ignoreVo));
        this.ignoreUrlMapper.update(id, name);
        this.authorityConfig.update(ignoreVo.getName(), name, ignoreVo.getStatus());
        return BaseResponse.success();
    }

    public BaseResponse add(String name, Integer status) {
        String appCode = this.authorityConfig.getAppCode();
        IgnoreVo byName = this.ignoreUrlMapper.getByName(name, appCode);
        if (byName == null) {
            IgnoreVo ignoreVo = new IgnoreVo();
            ignoreVo.setName(name);
            ignoreVo.setStatus(status);
            ignoreVo.setAppCode(appCode);
            this.ignoreUrlMapper.insert(ignoreVo);
            this.authorityConfig.set(name, ignoreVo.getStatus());
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"\u5df2\u6709\u6570\u636e,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0!");
    }

    public BaseResponse<LoginResVo> login(String userName, String password) {
        if (!Objects.equals("byh", userName) || !Objects.equals("byh@gateway", password)) {
            return BaseResponse.error((String)"\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef");
        }
        String token = String.valueOf(System.currentTimeMillis());
        LoginResVo loginResVo = new LoginResVo();
        loginResVo.setToken(token);
        loginResVo.setUserName("byh");
        RedisUtil.set((String)"byh", (String)token, (long)4L);
        return BaseResponse.success((Object)loginResVo);
    }

    @Async
    public void loggingStored(TokenJson tokenJson, RequestContext currentContext, String cloudDoctorAuthUrl) {
        HttpServletRequest request = currentContext.getRequest();
        RestTemplate restTemplate = new RestTemplate();
        String cloudUrl = StringUtils.substringBefore((String)cloudDoctorAuthUrl, (String)"cloud");
        String loggingStoredUrl = cloudUrl + "cloud/sysinfocloud/operationlog/insertOperationLog";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, String> map = new HashMap<String, String>();
        String appCode = request.getHeader("appCode");
        String channelSource = request.getHeader("channelSource");
        String cloudAuth = request.getHeader("cloudAuth");
        String ipAddress = MyFilter.getIpAddress((HttpServletRequest)request);
        String urlAddress = request.getRequestURI();
        RequestWrapper requestWrapper = new RequestWrapper(request);
        String param = "";
        String body = requestWrapper.getBody();
        log.info("body--->{}", (Object)JSON.toJSONString((Object)body));
        String getParam = MyFilter.getParamOfMethodGet((HttpServletRequest)request);
        log.info("getParam--->{}", (Object)JSON.toJSONString((Object)getParam));
        if (StringUtils.isNotBlank((CharSequence)getParam)) {
            param = getParam;
            log.info("get\u8bf7\u6c42\u7b2c\u4e00\u6b21\uff1a" + param + "--------------------");
            try {
                param = URLDecoder.decode(param, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u89e3\u7801\u53c2\u6570\u5f02\u5e38\uff1a " + e.getMessage());
            }
            log.info("get\u8bf7\u6c42\u7b2c\u4e8c\u6b21\uff1a" + param + "--------------------");
        } else {
            param = body;
            log.info("post\u8bf7\u6c42\u7b2c\u4e00\u6b21\uff1a" + param + "--------------------");
            if (param.contains("=") && !param.contains(":")) {
                param = MyFilter.convertParam((String)param);
                try {
                    param = URLDecoder.decode(param, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.error("\u89e3\u7801\u53c2\u6570\u5f02\u5e38\uff1a " + e.getMessage());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)request.getContentType()) && request.getContentType().contains("multipart")) {
                param = "";
            }
            log.info("post\u8bf7\u6c42\u7b2c\u4e8c\u6b21\uff1a" + param + "--------------------");
        }
        map.put("appCode", appCode);
        if (StringUtils.isNotEmpty((CharSequence)channelSource)) {
            map.put("channelSource", channelSource);
        } else if (StringUtils.isNotEmpty((CharSequence)cloudAuth)) {
            map.put("channelSource", cloudAuth);
        } else {
            map.put("channelSource", "appChannel");
        }
        map.put("ip", ipAddress);
        map.put("name", tokenJson.getName());
        map.put("phone", tokenJson.getAccountNo());
        map.put("reqUrl", urlAddress);
        map.put("reqParams", param);
        log.info("loggingStoredUrl-->{}", (Object)loggingStoredUrl);
        log.info("httpEntity--->{}", (Object)JSON.toJSONString(map));
        restTemplate.postForObject(loggingStoredUrl, map, String.class, new Object[0]);
    }
}

