/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.smspush.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.smspush.utils.HttpUtils;
import com.ebaiyihui.smspush.vo.VariableSmsApiVO;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SmsPushReceiver {
    private static final Logger log = LoggerFactory.getLogger(SmsPushReceiver.class);
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @RabbitListener(queues={"sms.queue.dev"})
    @RabbitHandler
    public void scheduledTaskScanningTaskReceiver(VariableSmsApiVO vo) {
        log.info("\u63a5\u6536\u5230\u53d1\u9001\u77ed\u4fe1\u5ef6\u8fdf\u961f\u5217\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)vo));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("appkey", vo.getAppKey());
        paramMap.put("appsecret", vo.getAppSecret());
        paramMap.put("smsid", vo.getSmsid());
        paramMap.put("mobile", vo.getMobile());
        paramMap.put("content", vo.getContent());
        paramMap.put("subport", vo.getSubport());
        paramMap.put("sendtime", vo.getSendtime());
        String response = HttpUtils.post((String)"http://api.guoyangyun.com", (String)"/api/sms/variableSmsApi.htm", paramMap);
        log.info("\u53d1\u9001\u77ed\u4fe1\u54cd\u5e94: {}", (Object)response);
        JSONObject jsonObject = JSONObject.parseObject((String)response);
        if (!Objects.equals("0", jsonObject.getString("code"))) {
            log.info("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c\u5c1d\u8bd5\u91cd\u65b0\u53d1\u9001\uff01");
            this.rabbitTemplate.convertAndSend("sms.delayed_exchange.dev", "sms.routing.key.dev", (Object)vo, message -> {
                message.getMessageProperties().setHeader("x-delay", (Object)300);
                log.info("\u53d1\u9001\u77ed\u4fe1\u961f\u5217 rabbitmq: " + JSONObject.toJSONString((Object)message));
                return message;
            });
        } else if (StringUtils.isNotBlank((CharSequence)vo.getCallBackUrl())) {
            JSONObject map = jsonObject;
            map.put("uuid", vo.getUuid());
            log.info("\u77ed\u4fe1\u53d1\u9001\u56de\u8c03\u63a5\u53e3\u53c2\u6570\u6267\u884c\uff1a{}", (Object)JSON.toJSONString((Object)map));
            HttpUtils.post((String)vo.getCallBackUrl(), null, (Map)map);
        }
    }

    public static void main(String[] args) {
        JSONObject jsonObject;
        String response = "{\n    \"code\":\"0\",\n    \"msg\":\"\u6210\u529f\",\n    \"data\":[\n        {\"smsid\":\"333\",\"mobile\":\"13606000000\",\"code\":\"0\",\"msg\":\"\u6210\u529f\"},\n        {\"smsid\":\"111\",\"mobile\":\"123\",\"code\":\"1403\",\"msg\":\"\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\"},\n        {\"smsid\":\"222\",\"mobile\":\"17300000000\",\"code\":\"1302\",\"msg\":\"\u77ed\u4fe1\u5185\u5bb9\u5305\u542b\u654f\u611f\u8bcd\u7b49\"}\n    ]\n}";
        JSONObject map = jsonObject = JSONObject.parseObject((String)response);
        map.put("uuid", "1111222233334444");
        System.out.println(map);
    }
}

