/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.smspush.service;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.smspush.common.execption.BusinessException;
import com.ebaiyihui.smspush.service.SmsPushRetryService;
import com.ebaiyihui.smspush.utils.HttpUtils;
import com.ebaiyihui.smspush.vo.VariableSmsApiVO;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service
public class SmsPushRetryServiceImpl
implements SmsPushRetryService {
    private static final Logger log = LoggerFactory.getLogger(SmsPushRetryServiceImpl.class);

    @Retryable(value={BusinessException.class}, maxAttempts=10, backoff=@Backoff(delay=120000L, multiplier=2.0))
    public void call(VariableSmsApiVO vo) {
        log.info("\u77ed\u4fe1\u91cd\u8bd5\u65b9\u6cd5\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)vo));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("appkey", vo.getAppKey());
        paramMap.put("appsecret", vo.getAppSecret());
        paramMap.put("smsid", vo.getSmsid());
        paramMap.put("mobile", vo.getMobile());
        paramMap.put("content", vo.getContent());
        paramMap.put("subport", vo.getSubport());
        paramMap.put("sendtime", vo.getSendtime());
        log.info("\u77ed\u4fe1\u53d1\u9001\u53c2\u6570\uff1a{}", paramMap);
        String response = HttpUtils.post((String)"http://api.guoyangyun.com", (String)"/api/sms/variableSmsApi.htm", paramMap);
        log.info("\u53d1\u9001\u77ed\u4fe1\u54cd\u5e94: {}", (Object)response);
        JSONObject jsonObject = JSONObject.parseObject((String)response);
        if (!Objects.equals("0", jsonObject.getString("code"))) {
            log.info("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c\u5c1d\u8bd5\u91cd\u65b0\u53d1\u9001\uff01");
            throw new BusinessException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u8fdb\u5165\u5931\u8d25\u91cd\u8bd5\u8fc7\u7a0b\uff0c\u91cd\u8bd510\u6b21");
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getCallBackUrl())) {
            JSONObject map = jsonObject;
            map.put("uuid", vo.getUuid());
            log.info("\u77ed\u4fe1\u53d1\u9001\u56de\u8c03\u63a5\u53e3\u53c2\u6570\u6267\u884c\uff1a{}", (Object)JSON.toJSONString((Object)map));
            String post = HttpUtil.post((String)vo.getCallBackUrl(), (String)JSON.toJSONString((Object)map));
            log.info("\u77ed\u4fe1\u53d1\u9001\u7ed3\u679c\u56de\u8c03\uff1a{}", (Object)post);
        }
    }
}

