/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.smspush.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.smspush.service.SmsPushService;
import com.ebaiyihui.smspush.utils.GlobalUtils;
import com.ebaiyihui.smspush.utils.HttpUtils;
import com.ebaiyihui.smspush.vo.CreateAccountVO;
import com.ebaiyihui.smspush.vo.LogoutAccountVO;
import com.ebaiyihui.smspush.vo.SearchAccountVO;
import com.ebaiyihui.smspush.vo.UpdateAccountVO;
import com.ebaiyihui.smspush.vo.VariableSmsApiVO;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsPushServiceImpl
implements SmsPushService {
    private static final Logger log = LoggerFactory.getLogger(SmsPushServiceImpl.class);
    @Autowired
    private RabbitTemplate rabbitTemplate;

    public void variableSmsApi(VariableSmsApiVO vo) {
        log.info("\u77ed\u4fe1\u53d8\u91cf\u53d1\u9001\u63a5\u53e3\uff1a{}", (Object)JSON.toJSONString((Object)vo));
        this.rabbitTemplate.convertAndSend("sms.delayed_exchange.dev", "sms.routing.key.dev", (Object)vo, message -> {
            message.getMessageProperties().setHeader("x-delay", (Object)300);
            log.info("\u53d1\u9001\u77ed\u4fe1\u961f\u5217 rabbitmq: " + JSONObject.toJSONString((Object)message));
            return message;
        });
    }

    public JSONObject smsReport(Map map) {
        Map paramMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)map), Map.class);
        String response = HttpUtils.get((String)"http://api.guoyangyun.com", (String)"/api/sms/smsReport.htm", (Map)paramMap);
        log.info("\u77ed\u4fe1\u56de\u6267\u62a5\u544a\uff08\u72b6\u6001\u62a5\u544a\uff09\uff1a{}", (Object)response);
        return JSONObject.parseObject((String)response);
    }

    public JSONObject createAccount(CreateAccountVO vo) {
        Map paramMap = GlobalUtils.buildBaseParamMap();
        paramMap.put("username", vo.getUsername());
        paramMap.put("corp", vo.getCorp());
        paramMap.put("password", vo.getPassword());
        String response = HttpUtils.get((String)"http://api.guoyangyun.com", (String)"/api/user/createAccount.htm", (Map)paramMap);
        return JSONObject.parseObject((String)response);
    }

    public JSONObject updateAccount(UpdateAccountVO vo) {
        Map paramMap = GlobalUtils.buildBaseParamMap();
        paramMap.put("username", vo.getUsername());
        paramMap.put("corp", vo.getCorp());
        paramMap.put("password", vo.getPassword());
        paramMap.put("status", vo.getStatus());
        String response = HttpUtils.get((String)"http://api.guoyangyun.com", (String)"/api/user/updateAccount.htm", (Map)paramMap);
        return JSONObject.parseObject((String)response);
    }

    public JSONObject searchAccount(SearchAccountVO vo) {
        Map paramMap = GlobalUtils.buildBaseParamMap();
        paramMap.put("username", vo.getUsername());
        String response = HttpUtils.get((String)"http://api.guoyangyun.com", (String)"/api/user/searchAccount.htm", (Map)paramMap);
        return JSONObject.parseObject((String)response);
    }

    public JSONObject logoutAccount(LogoutAccountVO vo) {
        Map paramMap = GlobalUtils.buildBaseParamMap();
        paramMap.put("username", vo.getUsername());
        String response = HttpUtils.get((String)"http://api.guoyangyun.com", (String)"/api/user/logoutAccount.htm", (Map)paramMap);
        return JSONObject.parseObject((String)response);
    }

    public JSONObject smsBalance(Map map) {
        Map paramMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)map), Map.class);
        String response = HttpUtils.get((String)"http://api.guoyangyun.com", (String)"/api/sms/smsBalance.htm", (Map)paramMap);
        return JSONObject.parseObject((String)response);
    }
}

