/*
 * Decompiled with CFR 0.152.
 */
package com.byh.hs.api.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.byh.hs.api.exception.BusinessException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(EasyExcelUtil.class);

    public static void exportExcelSheet(HttpServletResponse response, String excelName, String sheetName, Object data, List<?> companyList, List<?> contactList) {
        try (ServletOutputStream out = response.getOutputStream();){
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
            String format = LocalDateTime.now(ZoneOffset.ofHours(8)).format(dateTimeFormatter);
            String fileName = URLEncoder.encode(excelName + format, "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            EasyExcelUtil.handleExcelSheet((OutputStream)out, sheetName, data, companyList, contactList);
            out.flush();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private static void handleExcelSheet(OutputStream out, String sheetName, Object data, List<?> companyList, List<?> contactList) {
        try (ExcelWriter excelWriter = EasyExcelFactory.write((OutputStream)out).build();){
            WriteSheet medicineSheet = ((ExcelWriterSheetBuilder)EasyExcelFactory.writerSheet((Integer)0, (String)sheetName).head(data.getClass())).build();
            excelWriter.write(companyList, medicineSheet);
        }
    }

    public static void normalExport(HttpServletResponse response, String excelName, String sheetName, List<?> list, Class<?> pojoClass) {
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
            String format = LocalDateTime.now(ZoneOffset.ofHours(8)).format(dateTimeFormatter);
            String fileName = null;
            fileName = URLEncoder.encode(excelName + format, "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream()).head(pojoClass)).excelType(ExcelTypeEnum.XLSX).sheet(sheetName).doWrite(list);
        }
        catch (Exception e) {
            log.info("\u5bfc\u51faexcel\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    public static <T> void exportMultipleSheets(HttpServletResponse response, String fileName, List<SheetData<?>> sheetDataList) {
        ExcelWriter excelWriter = null;
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            fileName = URLEncoder.encode(fileName, "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            excelWriter = EasyExcel.write((OutputStream)response.getOutputStream()).build();
            for (int i = 0; i < sheetDataList.size(); ++i) {
                SheetData<?> sheetData = sheetDataList.get(i);
                WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)i, (String)sheetData.getSheetName()).head(sheetData.getClazz())).build();
                excelWriter.write(sheetData.getData(), writeSheet);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u9519\u8bef\u4e86");
        }
        finally {
            if (excelWriter != null) {
                excelWriter.finish();
            }
        }
    }

    public static class SheetData<T> {
        private String sheetName;
        private Class<T> clazz;
        private List<T> data;

        public SheetData(String sheetName, Class<T> clazz, List<T> data) {
            this.sheetName = sheetName;
            this.clazz = clazz;
            this.data = data;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public Class<T> getClazz() {
            return this.clazz;
        }

        public List<T> getData() {
            return this.data;
        }
    }
}

