/*
 * Decompiled with CFR 0.152.
 */
package com.byh.hs.api.util;

import com.byh.hs.api.util.DateUtils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SigNayureUtil {
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String createSignature(String partnerSecret, String partnerId, String timestamp) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(partnerSecret.getBytes("UTF-8"), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        return SigNayureUtil.bytesToHex(sha256_HMAC.doFinal((partnerId + timestamp).getBytes("UTF-8")));
    }

    public static byte[] getHmacSHA1(String encryptText, String encryptKey) {
        Mac mac = null;
        byte[] encryptKeyData = encryptKey.getBytes();
        byte[] encryptTextData = encryptText.getBytes();
        try {
            SecretKeySpec secretKey = new SecretKeySpec(encryptKeyData, "HmacSHA1");
            mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mac.doFinal(encryptTextData);
    }

    public static String builderSignStr(Map<String, Object> params, String appSecret) {
        Set<String> keySet = params.keySet();
        ArrayList<String> keyList = new ArrayList<String>(keySet);
        Collections.sort(keyList);
        StringBuilder sb = new StringBuilder();
        for (String key : keyList) {
            sb.append(key);
            sb.append("=");
            sb.append(params.get(key));
            sb.append("&");
        }
        sb.append("key=");
        sb.append(appSecret.toUpperCase(Locale.ROOT));
        return sb.toString();
    }

    public static String builderSignStr(Map<String, Object> params) {
        Set<String> keySet = params.keySet();
        ArrayList<String> keyList = new ArrayList<String>(keySet);
        Collections.sort(keyList);
        StringBuilder sb = new StringBuilder();
        for (String key : keyList) {
            sb.append(key);
            sb.append("=");
            sb.append(params.get(key));
            sb.append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String getMsgId() {
        return "NCZK_HIS" + DateUtils.dateTimeNow();
    }
}

