/*
 * Decompiled with CFR 0.152.
 */
package com.byh.hs.web.mvc.controller;

import com.byh.hs.api.annotation.Log;
import com.byh.hs.api.model.dto.DeptContrastDto;
import com.byh.hs.api.model.dto.DocContrastDto;
import com.byh.hs.api.model.dto.DrugContrastDto;
import com.byh.hs.api.model.dto.QueryDeptContrastByIdsDto;
import com.byh.hs.api.model.dto.QueryHsDrugDto;
import com.byh.hs.api.model.entity.DeptContrastEntity;
import com.byh.hs.api.model.entity.DocContrastEntity;
import com.byh.hs.api.model.entity.DrugContrastEntity;
import com.byh.hs.api.model.entity.HsConfigEntity;
import com.byh.hs.api.model.entity.HsDrugInfoEntity;
import com.byh.hs.api.util.ResponseData;
import com.byh.hs.web.service.HsContrastService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hsContrast"})
@Api(tags={"\u533b\u4fdd\u5bf9\u7167\u76f8\u5173api"})
public class HsContrastController {
    @Autowired
    private HsContrastService hsContrastService;

    @GetMapping(value={"/getHsConfig"})
    @ApiOperation(value="\u533b\u4fdd\u914d\u7f6e\u67e5\u8be2")
    @Log(name="\u533b\u4fdd\u914d\u7f6e\u67e5\u8be2")
    public ResponseData<HsConfigEntity> getHsConfig(@PathVariable String organId) {
        return this.hsContrastService.getHsConfig(organId);
    }

    @PostMapping(value={"/updateHsConfig"})
    @ApiOperation(value="\u4fee\u6539\u533b\u4fdd\u914d\u7f6e")
    @Log(name="\u4fee\u6539\u533b\u4fdd\u914d\u7f6e")
    public ResponseData updateHsConfig(@RequestBody HsConfigEntity hsConfigEntity) {
        return this.hsContrastService.updateHsConfig(hsConfigEntity);
    }

    @PostMapping(value={"/queryDocContrast"})
    @ApiOperation(value="\u67e5\u8be2\u533b\u751f\u5bf9\u7167\u4fe1\u606f")
    @Log(name="\u67e5\u8be2\u533b\u751f\u5bf9\u7167\u4fe1\u606f")
    public ResponseData queryDocContrast(@RequestBody DocContrastDto docContrastDto) {
        return this.hsContrastService.queryDocContrast(docContrastDto);
    }

    @PostMapping(value={"/insertDocContrast"})
    @ApiOperation(value="\u65b0\u589e\u533b\u751f\u5bf9\u7167\u4fe1\u606f")
    @Log(name="\u65b0\u589e\u533b\u751f\u5bf9\u7167\u4fe1\u606f")
    public ResponseData insertDocContrast(@RequestBody DocContrastEntity docContrastEntity) {
        return this.hsContrastService.insertDocContrast(docContrastEntity);
    }

    @PostMapping(value={"/queryDocContrastById"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u533b\u751f\u5bf9\u7167\u4fe1\u606f")
    @Log(name="\u6839\u636eid\u67e5\u8be2\u533b\u751f\u5bf9\u7167\u4fe1\u606f")
    public ResponseData queryDocContrastById(@RequestBody String docId) {
        return this.hsContrastService.queryDocContrastById(docId);
    }

    @PostMapping(value={"/updateDocContrast"})
    @ApiOperation(value="\u4fee\u6539\u533b\u751f\u5bf9\u7167\u4fe1\u606f")
    @Log(name="\u4fee\u6539\u533b\u751f\u5bf9\u7167\u4fe1\u606f")
    public ResponseData updateDocContrast(@RequestBody DocContrastEntity docContrastEntity) {
        return this.hsContrastService.updateDocContrast(docContrastEntity);
    }

    @PostMapping(value={"/delDocContrast"})
    @ApiOperation(value="\u5220\u9664\u533b\u751f\u5bf9\u7167\u4fe1\u606f")
    @Log(name="\u5220\u9664\u533b\u751f\u5bf9\u7167\u4fe1\u606f")
    public ResponseData delDocContrast(@RequestBody List<Integer> docContrastList) {
        return this.hsContrastService.delDocContrast(docContrastList);
    }

    @PostMapping(value={"/queryDrugContrast"})
    @ApiOperation(value="\u67e5\u8be2\u836f\u54c1\u5bf9\u7167\u4fe1\u606f")
    @Log(name="\u67e5\u8be2\u836f\u54c1\u5bf9\u7167\u4fe1\u606f")
    public ResponseData queryDrugContrast(@RequestBody DrugContrastDto drugContrastDto) {
        return this.hsContrastService.queryDrugContrast(drugContrastDto);
    }

    @PostMapping(value={"/insertDrugContrast"})
    @ApiOperation(value="\u65b0\u589e\u836f\u54c1\u5bf9\u7167\u4fe1\u606f")
    @Log(name="\u65b0\u589e\u836f\u54c1\u5bf9\u7167\u4fe1\u606f")
    public ResponseData insertDrugContrast(@RequestBody DrugContrastEntity drugContrastEntity) {
        return this.hsContrastService.insertDrugContrast(drugContrastEntity);
    }

    @PostMapping(value={"/queryDrugContrastById"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u836f\u54c1\u5bf9\u7167\u4fe1\u606f")
    @Log(name="\u6839\u636eid\u67e5\u8be2\u836f\u54c1\u5bf9\u7167\u4fe1\u606f")
    public ResponseData queryDrugContrastById(@RequestBody String drugContrastId) {
        return this.hsContrastService.queryDrugContrastById(drugContrastId);
    }

    @PostMapping(value={"/updateDrugContrast"})
    @ApiOperation(value="\u4fee\u6539\u836f\u54c1\u5bf9\u7167\u4fe1\u606f")
    @Log(name="\u4fee\u6539\u836f\u54c1\u5bf9\u7167\u4fe1\u606f")
    public ResponseData updateDrugContrast(@RequestBody DrugContrastEntity drugContrastEntity) {
        return this.hsContrastService.updateDrugContrast(drugContrastEntity);
    }

    @PostMapping(value={"/delDrugContrast"})
    @ApiOperation(value="\u5220\u9664\u836f\u54c1\u5bf9\u7167\u4fe1\u606f")
    @Log(name="\u5220\u9664\u836f\u54c1\u5bf9\u7167\u4fe1\u606f")
    public ResponseData delDrugContrast(@RequestBody List<Integer> drugContrastList) {
        return this.hsContrastService.delDrugContrast(drugContrastList);
    }

    @PostMapping(value={"/uploadDrugContrast"})
    @ApiOperation(value="\u836f\u54c1\u5bf9\u7167\u4fe1\u606f\u4e0a\u4f20\u30103301\u3011")
    @Log(name="\u836f\u54c1\u5bf9\u7167\u4fe1\u606f\u4e0a\u4f20\u30103301\u3011")
    public ResponseData uploadDrugContrast(@RequestBody List<Integer> durgIds, String organId) {
        return this.hsContrastService.uploadDrugContrast(durgIds, organId);
    }

    @PostMapping(value={"/revokeDrugContrast"})
    @ApiOperation(value="\u836f\u54c1\u5bf9\u7167\u4fe1\u606f\u64a4\u9500\u30103302\u3011")
    @Log(name="\u836f\u54c1\u5bf9\u7167\u4fe1\u606f\u64a4\u9500\u30103302\u3011")
    public ResponseData revokeDrugContrast(@RequestBody List<Integer> durgIds, String organId) {
        return this.hsContrastService.revokeDrugContrast(durgIds, organId);
    }

    @PostMapping(value={"/queryDeptContrast"})
    @ApiOperation(value="\u67e5\u8be2\u79d1\u5ba4\u5bf9\u7167\u4fe1\u606f")
    @Log(name="\u67e5\u8be2\u79d1\u5ba4\u5bf9\u7167\u4fe1\u606f")
    public ResponseData queryDeptContrast(@RequestBody DeptContrastDto deptContrastDto) {
        return this.hsContrastService.queryDeptContrast(deptContrastDto);
    }

    @PostMapping(value={"/insertDeptContrast"})
    @ApiOperation(value="\u65b0\u589e\u79d1\u5ba4\u5bf9\u7167\u4fe1\u606f")
    @Log(name="\u65b0\u589e\u79d1\u5ba4\u5bf9\u7167\u4fe1\u606f")
    public ResponseData insertDeptContrast(@RequestBody DeptContrastEntity deptContrastEntity) {
        return this.hsContrastService.insertDeptContrast(deptContrastEntity);
    }

    @PostMapping(value={"/queryDeptContrastById"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u79d1\u5ba4\u5bf9\u7167\u4fe1\u606f")
    @Log(name="\u6839\u636eid\u67e5\u8be2\u79d1\u5ba4\u5bf9\u7167\u4fe1\u606f")
    public ResponseData queryDeptContrastById(@RequestBody String deptId) {
        return this.hsContrastService.queryDeptContrastById(deptId);
    }

    @PostMapping(value={"/updateDeptContrast"})
    @ApiOperation(value="\u4fee\u6539\u79d1\u5ba4\u5bf9\u7167\u4fe1\u606f")
    @Log(name="\u4fee\u6539\u79d1\u5ba4\u5bf9\u7167\u4fe1\u606f")
    public ResponseData updateDeptContrast(@RequestBody DeptContrastEntity deptContrastEntity) {
        return this.hsContrastService.updateDeptContrast(deptContrastEntity);
    }

    @PostMapping(value={"/delDeptContrast"})
    @ApiOperation(value="\u5220\u9664\u79d1\u5ba4\u5bf9\u7167\u4fe1\u606f")
    @Log(name="\u5220\u9664\u79d1\u5ba4\u5bf9\u7167\u4fe1\u606f")
    public ResponseData delDeptContrast(@RequestBody List<Integer> deptContrastList) {
        return this.hsContrastService.delDeptContrast(deptContrastList);
    }

    @PostMapping(value={"/uploadDeptContrast"})
    @ApiOperation(value="\u79d1\u5ba4\u5bf9\u7167\u4fe1\u606f\u4e0a\u4f20\u30103401A\u3011")
    @Log(name="\u79d1\u5ba4\u5bf9\u7167\u4fe1\u606f\u4e0a\u4f20\u30103401A\u3011")
    public ResponseData uploadDeptContrast(@RequestBody QueryDeptContrastByIdsDto queryDeptContrastByIdsDto) {
        return this.hsContrastService.uploadDeptContrast(queryDeptContrastByIdsDto.getDeptIds(), queryDeptContrastByIdsDto.getOrganId());
    }

    @PostMapping(value={"/revokeDeptContrast"})
    @ApiOperation(value="\u79d1\u5ba4\u5bf9\u7167\u4fe1\u606f\u64a4\u9500\u30103403\u3011")
    @Log(name="\u79d1\u5ba4\u5bf9\u7167\u4fe1\u606f\u64a4\u9500\u30103403\u3011")
    public ResponseData revokeDeptContrast(@RequestBody QueryDeptContrastByIdsDto queryDeptContrastByIdsDto) {
        return this.hsContrastService.revokeDeptContrast(queryDeptContrastByIdsDto.getDeptIds(), queryDeptContrastByIdsDto.getOrganId());
    }

    @PostMapping(value={"/hsDrugInfo"})
    @ApiOperation(value="\u533b\u4fdd\u836f\u54c1\u76ee\u5f55\u67e5\u8be2")
    @Log(name="\u533b\u4fdd\u836f\u54c1\u76ee\u5f55\u67e5\u8be2")
    public ResponseData hsDrugInfo(@RequestBody QueryHsDrugDto queryHsDrugDto) {
        return this.hsContrastService.hsDrugInfo(queryHsDrugDto);
    }

    @PostMapping(value={"/updateDrugInfo"})
    @ApiOperation(value="\u533b\u4fdd\u4fe1\u606f\u4fee\u6539")
    @Log(name="\u533b\u4fdd\u4fe1\u606f\u4fee\u6539")
    public ResponseData updateDrugInfo(@RequestBody HsDrugInfoEntity hsDrugInfo) {
        return this.hsContrastService.updateDrugInfo(hsDrugInfo);
    }
}

