/*
 * Decompiled with CFR 0.152.
 */
package com.byh.hs.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.hs.api.enums.UploadStatusEnum;
import com.byh.hs.api.model.dto.DeptContrastDto;
import com.byh.hs.api.model.dto.DocContrastDto;
import com.byh.hs.api.model.dto.DrugContrastDto;
import com.byh.hs.api.model.dto.QueryHsDrugDto;
import com.byh.hs.api.model.entity.DeptContrastEntity;
import com.byh.hs.api.model.entity.DocContrastEntity;
import com.byh.hs.api.model.entity.DrugContrastEntity;
import com.byh.hs.api.model.entity.HsConfigEntity;
import com.byh.hs.api.model.entity.HsDrugInfoEntity;
import com.byh.hs.api.model.request.HsBaseRequest;
import com.byh.hs.api.model.request.UploadCatalogRequest;
import com.byh.hs.api.util.PageResult;
import com.byh.hs.api.util.ResponseData;
import com.byh.hs.data.repository.DeptContrastMapper;
import com.byh.hs.data.repository.DocContrastMapper;
import com.byh.hs.data.repository.DrugContrastMapper;
import com.byh.hs.data.repository.HsConfigMapper;
import com.byh.hs.data.repository.HsDrugInfoMapper;
import com.byh.hs.web.service.HsBusinessService;
import com.byh.hs.web.service.HsContrastService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HsContrastServiceImpl
implements HsContrastService {
    @Autowired
    private HsConfigMapper hsConfigMapper;
    @Autowired
    private DocContrastMapper docContrastMapper;
    @Autowired
    private DrugContrastMapper drugContrastMapper;
    @Autowired
    private DeptContrastMapper deptContrastMapper;
    @Autowired
    private HsBusinessService hsBusinessService;
    @Autowired
    private HsDrugInfoMapper hsDrugInfoMapper;

    public ResponseData<HsConfigEntity> getHsConfig(String organId) {
        HsConfigEntity ybConfigEntity = (HsConfigEntity)this.hsConfigMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"organ_id", (Object)organId));
        if (Objects.isNull(ybConfigEntity)) {
            return ResponseData.error((String)"\u83b7\u53d6\u533b\u4fdd\u914d\u7f6e\u4fe1\u606f\u5931\u8d25!");
        }
        return ResponseData.success((Object)ybConfigEntity);
    }

    public ResponseData updateHsConfig(HsConfigEntity hsConfigEntity) {
        if (0 > this.hsConfigMapper.updateById((Object)hsConfigEntity)) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u66f4\u65b0\u533b\u4fdd\u914d\u7f6e\u5931\u8d25!");
    }

    public ResponseData queryDocContrast(DocContrastDto docContrastDto) {
        PageHelper.startPage((int)docContrastDto.getPageIndex(), (int)docContrastDto.getPageSize());
        List docContrastList = this.docContrastMapper.queryDocContrastByNameOrCode(docContrastDto.getDocNameOrHsCode());
        PageInfo pageInfo = new PageInfo(docContrastList);
        PageResult pageResult = new PageResult(docContrastDto.getPageIndex().intValue(), docContrastDto.getPageSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setTotalPages(pageInfo.getPages());
        pageResult.setContent(docContrastList);
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData insertDocContrast(DocContrastEntity docContrastEntity) {
        return ResponseData.success((Object)this.docContrastMapper.insert((Object)docContrastEntity));
    }

    public ResponseData queryDocContrastById(String docId) {
        return ResponseData.success((Object)this.drugContrastMapper.selectById((Serializable)((Object)docId)));
    }

    public ResponseData updateDocContrast(DocContrastEntity docContrastEntity) {
        if (0 > this.docContrastMapper.updateById((Object)docContrastEntity)) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u4fee\u6539\u533b\u4fdd\u5bf9\u7167\u4fe1\u606f\u5931\u8d25!");
    }

    public ResponseData delDocContrast(List<Integer> docContrastList) {
        if (0 > this.docContrastMapper.deleteBatchIds(docContrastList)) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u5220\u9664\u533b\u4fdd\u5bf9\u7167\u4fe1\u606f\u5931\u8d25!");
    }

    public ResponseData queryDrugContrast(DrugContrastDto drugContrastDto) {
        PageHelper.startPage((int)drugContrastDto.getPageIndex(), (int)drugContrastDto.getPageSize());
        List drugContrastList = this.drugContrastMapper.queryDrugContrastByNameOrCode(drugContrastDto.getDrugNameOrCode(), drugContrastDto.getOrganId());
        PageInfo pageInfo = new PageInfo(drugContrastList);
        PageResult pageResult = new PageResult(drugContrastDto.getPageIndex().intValue(), drugContrastDto.getPageSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setTotalPages(pageInfo.getPages());
        pageResult.setContent(drugContrastList);
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData insertDrugContrast(DrugContrastEntity drugContrastEntity) {
        return ResponseData.success((Object)this.drugContrastMapper.insert((Object)drugContrastEntity));
    }

    public ResponseData queryDrugContrastById(String drugContrastId) {
        return ResponseData.success((Object)this.drugContrastMapper.selectById((Serializable)((Object)drugContrastId)));
    }

    public ResponseData updateDrugContrast(DrugContrastEntity drugContrastEntity) {
        if (0 > this.drugContrastMapper.updateById((Object)drugContrastEntity)) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u4fee\u6539\u836f\u54c1\u4fdd\u5bf9\u7167\u4fe1\u606f\u5931\u8d25!");
    }

    public ResponseData delDrugContrast(List<Integer> drugContrastIds) {
        if (0 > this.drugContrastMapper.deleteBatchIds(drugContrastIds)) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u5220\u9664\u836f\u54c1\u4fdd\u5bf9\u7167\u4fe1\u606f\u5931\u8d25!");
    }

    public ResponseData uploadDrugContrast(List<Integer> drugIds, String organId) {
        HsBaseRequest hsBaseRequest = new HsBaseRequest();
        hsBaseRequest.setOrganId(organId);
        List drugContrastList = this.drugContrastMapper.queryUploadDrugContrast(organId, drugIds);
        List splistList = this.averageAssign(drugContrastList, 99);
        Boolean flag = true;
        for (List uploadCatalogRequestList : splistList) {
            ResponseData responseData = this.hsBusinessService.uploadCatalogList(uploadCatalogRequestList, hsBaseRequest);
            if (responseData.isSuccess()) continue;
            flag = false;
        }
        if (flag.booleanValue()) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u4e0a\u4f20\u5931\u8d25\uff01");
    }

    public ResponseData revokeDrugContrast(List<Integer> drugIds, String organId) {
        HsBaseRequest hsBaseRequest = new HsBaseRequest();
        hsBaseRequest.setOrganId(organId);
        List drugContrastList = this.drugContrastMapper.queryRevokeDrugContrast(organId, drugIds);
        ResponseData ResponseData2 = this.hsBusinessService.revokeCatalogList(drugContrastList, hsBaseRequest);
        if (!ResponseData2.isSuccess()) {
            return ResponseData.error((String)"\u4e0a\u4f20\u5931\u8d25\uff01");
        }
        return ResponseData2.success();
    }

    public ResponseData queryDeptContrast(DeptContrastDto deptContrastDto) {
        PageHelper.startPage((int)deptContrastDto.getPageIndex(), (int)deptContrastDto.getPageSize());
        List deptContrastList = this.deptContrastMapper.queryDeptContrastByNameOrCode(deptContrastDto.getDeptNameOrHsCode(), deptContrastDto.getOrganId());
        PageInfo pageInfo = new PageInfo(deptContrastList);
        PageResult pageResult = new PageResult(deptContrastDto.getPageIndex().intValue(), deptContrastDto.getPageSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setTotalPages(pageInfo.getPages());
        pageResult.setContent(deptContrastList);
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData insertDeptContrast(DeptContrastEntity deptContrastEntity) {
        return ResponseData.success((Object)this.deptContrastMapper.insert((Object)deptContrastEntity));
    }

    public ResponseData queryDeptContrastById(String deptId) {
        return ResponseData.success((Object)this.drugContrastMapper.selectById((Serializable)((Object)deptId)));
    }

    public ResponseData updateDeptContrast(DeptContrastEntity deptContrastEntity) {
        if (0 > this.deptContrastMapper.updateById((Object)deptContrastEntity)) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u4fee\u6539\u533b\u4fdd\u5bf9\u7167\u4fe1\u606f\u5931\u8d25!");
    }

    public ResponseData delDeptContrast(List<Integer> deptContrastList) {
        if (0 > this.deptContrastMapper.deleteBatchIds(deptContrastList)) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u5220\u9664\u533b\u4fdd\u5bf9\u7167\u4fe1\u606f\u5931\u8d25!");
    }

    public ResponseData uploadDeptContrast(List<Integer> deptIds, String organId) {
        HsBaseRequest hsBaseRequest = new HsBaseRequest();
        hsBaseRequest.setOrganId(organId);
        List deptContrastList = this.deptContrastMapper.queryUploadDeptContrast(organId, deptIds);
        ResponseData ResponseData2 = this.hsBusinessService.uploadDeptList(deptContrastList, hsBaseRequest);
        if (!ResponseData2.isSuccess()) {
            this.deptContrastMapper.updateUploadStatus(deptIds, UploadStatusEnum.FAIL.getValue());
            return ResponseData.error((String)"\u4e0a\u4f20\u5931\u8d25\uff01");
        }
        this.deptContrastMapper.updateUploadStatus(deptIds, UploadStatusEnum.SUCC.getValue());
        return ResponseData2.success();
    }

    public ResponseData revokeDeptContrast(List<Integer> deptIds, String organId) {
        HsBaseRequest hsBaseRequest = new HsBaseRequest();
        hsBaseRequest.setOrganId(organId);
        List deptContrastList = this.deptContrastMapper.queryRevokeDeptContrast(organId, deptIds);
        ResponseData ResponseData2 = this.hsBusinessService.revokeDeptList(deptContrastList, hsBaseRequest);
        if (!ResponseData2.isSuccess()) {
            return ResponseData.error((String)"\u64a4\u9500\u5931\u8d25\uff01");
        }
        this.deptContrastMapper.updateUploadStatus(deptIds, UploadStatusEnum.REVOKE.getValue());
        return ResponseData2.success();
    }

    public ResponseData hsDrugInfo(QueryHsDrugDto queryHsDrugDto) {
        PageHelper.startPage((int)queryHsDrugDto.getPageIndex(), (int)queryHsDrugDto.getPageSize());
        List hsDrugInfoList = this.hsDrugInfoMapper.queryDrugInfo(queryHsDrugDto);
        PageInfo pageInfo = new PageInfo(hsDrugInfoList);
        PageResult pageResult = new PageResult(queryHsDrugDto.getPageIndex().intValue(), queryHsDrugDto.getPageSize().intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setTotalPages(pageInfo.getPages());
        pageResult.setContent(hsDrugInfoList);
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData updateDrugInfo(HsDrugInfoEntity hsDrugInfo) {
        if (0 > this.hsDrugInfoMapper.updateById((Object)hsDrugInfo)) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u4fee\u6539\u533b\u4fdd\u4fe1\u606f\u5931\u8d25!");
    }

    private List<List<UploadCatalogRequest>> averageAssign(List<UploadCatalogRequest> source, int splitItemNum) {
        ArrayList<List<UploadCatalogRequest>> result = new ArrayList<List<UploadCatalogRequest>>();
        if (source != null && source.size() > 0 && splitItemNum > 0) {
            if (source.size() <= splitItemNum) {
                result.add(source);
            } else {
                int splitNum = source.size() % splitItemNum == 0 ? source.size() / splitItemNum : source.size() / splitItemNum + 1;
                List<UploadCatalogRequest> value = null;
                for (int i = 0; i < splitNum; ++i) {
                    value = i < splitNum - 1 ? source.subList(i * splitItemNum, (i + 1) * splitItemNum) : source.subList(i * splitItemNum, source.size());
                    result.add(value);
                }
            }
        }
        return result;
    }
}

