/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.api.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.write.handler.RowWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.byh.inpatient.api.excel.ExcelMerge;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelMergeStrategy
implements RowWriteHandler {
    private Integer primaryKeyIndex;
    private final List<Integer> mergeColumnIndexList = new ArrayList<Integer>();
    private final Class<?> elementType;

    public ExcelMergeStrategy(Class<?> elementType) {
        this.elementType = elementType;
    }

    public void afterRowDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Integer relativeRowIndex, Boolean isHead) {
        if (isHead.booleanValue()) {
            return;
        }
        Sheet sheet = writeSheetHolder.getSheet();
        if (this.primaryKeyIndex == null) {
            this.initPrimaryIndexAndMergeIndex(writeSheetHolder);
        }
        if (row.getRowNum() <= 1) {
            return;
        }
        Row lastRow = sheet.getRow(row.getRowNum() - 1);
        if (lastRow.getCell(this.primaryKeyIndex.intValue()).getStringCellValue().equalsIgnoreCase(row.getCell(this.primaryKeyIndex.intValue()).getStringCellValue())) {
            for (Integer mergeIndex : this.mergeColumnIndexList) {
                CellRangeAddress cellRangeAddress = new CellRangeAddress(row.getRowNum() - 1, row.getRowNum(), mergeIndex.intValue(), mergeIndex.intValue());
                sheet.addMergedRegionUnsafe(cellRangeAddress);
            }
        }
    }

    private void initPrimaryIndexAndMergeIndex(WriteSheetHolder writeSheetHolder) {
        Field[] fields;
        Sheet sheet = writeSheetHolder.getSheet();
        Row titleRow = sheet.getRow(0);
        for (Field field : fields = this.elementType.getDeclaredFields()) {
            ExcelMerge excelMerge;
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            if (null == excelProperty || null == (excelMerge = field.getAnnotation(ExcelMerge.class))) continue;
            for (int i = 0; i < fields.length; ++i) {
                Cell cell = titleRow.getCell(i);
                if (null == cell || !excelProperty.value()[0].equalsIgnoreCase(cell.getStringCellValue())) continue;
                if (excelMerge.isPrimaryKey()) {
                    this.primaryKeyIndex = i;
                }
                if (!excelMerge.merge()) continue;
                this.mergeColumnIndexList.add(i);
            }
        }
        if (null == this.primaryKeyIndex) {
            throw new IllegalStateException("\u4f7f\u7528@ExcelMerge\u6ce8\u89e3\u5fc5\u987b\u6307\u5b9a\u4e3b\u952e");
        }
    }
}

