/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.inpatient.api.model.dto.HistoricalDiagDTO;
import com.byh.inpatient.api.model.dto.InpatMedicalRecordDTO;
import com.byh.inpatient.api.model.vo.AdmissionDiagListVO;
import com.byh.inpatient.api.model.vo.AdmissionDiagVO;
import com.byh.inpatient.api.model.vo.HistoryDiagVO;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.web.mvc.utils.CommonRequest;
import com.byh.inpatient.web.service.IInpatMedicalRecordService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inpatMedicalRecord"})
public class InpatMedicalRecordController {
    @Autowired
    private IInpatMedicalRecordService inpatMedicalRecordService;
    @Autowired
    private CommonRequest commonRequest;

    @ApiOperation(value="\u67e5\u8be2\u5165\u9662\u8bca\u65ad\u60a3\u8005\u5217\u8868")
    @GetMapping(value={"/admissionDiag/list"})
    public ResponseData<List<AdmissionDiagListVO>> getAdmissionDiagList(Integer doctorId, String search, String inHospFlag) {
        return ResponseData.success((Object)this.inpatMedicalRecordService.getAdmissionDiagList(doctorId, search, inHospFlag));
    }

    @ApiOperation(value="\u4fdd\u5b58\u6216\u4fee\u6539\u5165\u9662\u8bca\u65ad")
    @PostMapping(value={"/admissionDiag/saveOrUpdate"})
    public ResponseData saveOrUpdateAdmissionDiag(@RequestBody @Valid InpatMedicalRecordDTO admissionDiagVO) {
        admissionDiagVO.setTenantId(this.commonRequest.getTenant());
        admissionDiagVO.setCreateId(this.commonRequest.getUserId());
        admissionDiagVO.setCreateName(this.commonRequest.getUserName());
        this.inpatMedicalRecordService.saveOrUpdateAdmissionDiag(admissionDiagVO);
        return ResponseData.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005\u8bca\u65ad\u4fe1\u606f", notes="\u6839\u636e\u4f4f\u9662\u53f7\u67e5\u8be2")
    @GetMapping(value={"/admissionDiag/select"})
    public ResponseData<AdmissionDiagVO> selectAdmissionDiagList(String inpatNo) {
        return ResponseData.success((Object)this.inpatMedicalRecordService.getAdmissionDiagByInpatNo(inpatNo));
    }

    @ApiOperation(value="\u67e5\u8be2\u60a3\u8005\u5386\u53f2\u8bca\u65ad\u5217\u8868")
    @PostMapping(value={"/selectHistoryDiagPageList"})
    public ResponseData<Page<HistoryDiagVO>> selectHistoryDiagPageList(HistoricalDiagDTO param) {
        return ResponseData.success((Object)this.inpatMedicalRecordService.getHistoryDiagList(param));
    }
}

