/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.controller;

import com.byh.inpatient.api.dto.medicalRecord.OutpatientInfomationDto;
import com.byh.inpatient.api.dto.prescription.InpatPrescriptionDto;
import com.byh.inpatient.api.dto.prescription.SavePrescriptionDto;
import com.byh.inpatient.api.model.vo.prescription.QueryPrescriptionsVo;
import com.byh.inpatient.api.model.vo.prescription.QueryWesternMedicinePrescriptionsVo;
import com.byh.inpatient.api.model.vo.thirdUseDrugVerify.RationDrugUseVo;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.web.mvc.utils.CommonRequest;
import com.byh.inpatient.web.service.InpatPrescriptionService;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outPrescription"})
public class InpatPrescriptionController {
    @Resource
    private InpatPrescriptionService inpatPrescriptionService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/v1/queryPrescriptions"})
    @Operation(description="\u6839\u636e\u4f4f\u9662\u53f7\uff0c\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    @ApiOperation(value="\u5904\u65b9-\u67e5\u8be2\u5904\u65b9\u5217\u8868", httpMethod="POST", notes="\u5904\u65b9-\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    public ResponseData<QueryWesternMedicinePrescriptionsVo> queryPrescriptions(@RequestBody @Valid OutpatientInfomationDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.inpatPrescriptionService.queryPrescriptions(parameter);
    }

    @PostMapping(value={"/v1/savePrescription"})
    @Operation(description="\u4fdd\u5b58\u5904\u65b9")
    @ApiOperation(value="\u5904\u65b9-\u4fdd\u5b58\u5904\u65b9", httpMethod="POST", notes="\u5904\u65b9-\u4fdd\u5b58\u5904\u65b9")
    public ResponseData<RationDrugUseVo> savePrescription(@RequestBody @Valid SavePrescriptionDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.inpatPrescriptionService.savePrescription(parameter);
    }

    @PostMapping(value={"/v1/deletePrescriptionsByNo"})
    @Operation(description="\u6839\u636e\u5904\u65b9\u53f7\u5220\u9664\u5904\u65b9")
    @ApiOperation(value="\u5904\u65b9-\u6839\u636e\u5904\u65b9\u53f7\u5220\u9664\u5904\u65b9", httpMethod="POST", notes="\u5904\u65b9-\u6839\u636e\u5904\u65b9\u53f7\u5220\u9664\u5904\u65b9")
    public ResponseData<String> deletePrescriptionsByNo(@RequestBody @Valid InpatPrescriptionDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.inpatPrescriptionService.deletePrescriptionsByNo(parameter);
    }

    @PostMapping(value={"/v1/queryPrescriptionsByNo"})
    @Operation(description="\u6839\u636e\u5904\u65b9\u53f7\u67e5\u8be2\u5904\u65b9")
    @ApiOperation(value="\u5904\u65b9-\u6839\u636e\u5904\u65b9\u53f7\u67e5\u8be2\u5904\u65b9", httpMethod="POST", notes="\u5904\u65b9-\u6839\u636e\u5904\u65b9\u53f7\u67e5\u8be2\u5904\u65b9")
    public ResponseData<QueryPrescriptionsVo> queryPrescriptionsByNo(@RequestBody @Valid InpatPrescriptionDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.inpatPrescriptionService.queryPrescriptionsByNo(parameter);
    }
}

