/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.api.vo.nurse.ExecutionOfMedicalOrdersReqVo;
import com.byh.inpatient.api.vo.nurse.ExecutionOfMedicalOrdersResVo;
import com.byh.inpatient.api.vo.nurse.SelectPatientByNurseReqVo;
import com.byh.inpatient.api.vo.nurse.UpdateMedicalOrdersReqVo;
import com.byh.inpatient.api.vo.nurse.UpdateTeskinTestResultReqVo;
import com.byh.inpatient.web.mvc.utils.CommonRequest;
import com.byh.inpatient.web.service.NurseService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inpatNurse"})
public class NurseController {
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private NurseService nurseService;

    @PostMapping(value={"/selectPatientByNurse"})
    @ApiOperation(value="\u67e5\u8be2\u62a4\u58eb\u4e0b\u60a3\u8005")
    public ResponseData<List<InpatRegist>> selectPatientByNurse(@RequestBody SelectPatientByNurseReqVo param) {
        try {
            ResponseData responseData = this.nurseService.selectPatientByNurse(param);
            return responseData;
        }
        catch (Exception ex) {
            return ResponseData.error((String)ex.getMessage());
        }
    }

    @PostMapping(value={"/executionOfMedicalOrders"})
    @ApiOperation(value="\u6267\u884c\u533b\u5631\u5217\u8868")
    public ResponseData<Page<ExecutionOfMedicalOrdersResVo>> executionOfMedicalOrders(@RequestBody ExecutionOfMedicalOrdersReqVo param) {
        try {
            ResponseData responseData = this.nurseService.executionOfMedicalOrders(param);
            return responseData;
        }
        catch (Exception ex) {
            return ResponseData.error((String)ex.getMessage());
        }
    }

    @PostMapping(value={"/updateMedicalOrders"})
    @ApiOperation(value="\u6267\u884c\u533b\u5631\u66f4\u65b0\u72b6\u6001")
    public ResponseData<String> updateMedicalOrders(@RequestBody UpdateMedicalOrdersReqVo param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorId(this.commonRequest.getUserId());
        param.setOperatorName(this.commonRequest.getUserName());
        try {
            ResponseData responseData = this.nurseService.updateMedicalOrders(param);
            return responseData;
        }
        catch (Exception ex) {
            return ResponseData.error((String)ex.getMessage());
        }
    }

    @PostMapping(value={"/updaTeskinTestResult"})
    @ApiOperation(value="\u66f4\u65b0\u76ae\u8bd5\u7ed3\u679c")
    public ResponseData<String> updaTeskinTestResult(@RequestBody UpdateTeskinTestResultReqVo param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorId(this.commonRequest.getUserId());
        param.setOperatorName(this.commonRequest.getUserName());
        try {
            ResponseData responseData = this.nurseService.updaTeskinTestResult(param);
            return responseData;
        }
        catch (Exception ex) {
            return ResponseData.error((String)ex.getMessage());
        }
    }
}

