/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.exception;

import com.byh.inpatient.api.exception.BusinessException;
import com.byh.inpatient.api.util.ResponseData;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ExceptionAdvice {
    public static Logger logger = LoggerFactory.getLogger(ExceptionAdvice.class);

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public ResponseData<Object> handleException(Exception e) {
        StringWriter stack = new StringWriter();
        e.printStackTrace(new PrintWriter(stack));
        logger.error("\u7cfb\u7edf\u5f02\u5e38\u4fe1\u606f:" + stack);
        if (e instanceof BusinessException || e instanceof IllegalArgumentException) {
            return ResponseData.error((String)e.getMessage());
        }
        if (e instanceof MyBatisSystemException) {
            return ResponseData.error((String)stack.toString());
        }
        if (e instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException me = (MethodArgumentNotValidException)e;
            FieldError field = me.getFieldError();
            String msg = "\u8bf7\u6c42\u5165\u53c2\u3010" + field.getField() + "\u3011\u9519\u8bef\uff1a" + field.getDefaultMessage();
            return ResponseData.error((String)ResponseData.ResponseEnum.BAD_REQUEST.getCode(), (String)msg);
        }
        if (e instanceof NullPointerException) {
            return ResponseData.error((String)("\u53d1\u751f\u4e86\u7a7a\u6307\u9488\u5f02\u5e38: " + stack.toString()));
        }
        if (e.getCause() != null && e.getCause().getMessage() != null) {
            return ResponseData.error((String)e.getCause().getMessage());
        }
        return ResponseData.error((String)e.getMessage());
    }
}

