/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.interceptor;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.byh.inpatient.web.mvc.utils.CommonRequest;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
@Component
public class MybatisPlusIntercetor
implements InnerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusIntercetor.class);
    private CommonRequest commonRequest;

    public void beforeUpdate(Executor executor, MappedStatement ms, Object parameter) {
        if (parameter != null) {
            SqlCommandType sqlCommandType = ms.getSqlCommandType();
            Object entity = this.getEntityFromParameter(parameter);
            TableInfo tableInfo = TableInfoHelper.getTableInfo(entity.getClass());
            if (SqlCommandType.INSERT.equals((Object)sqlCommandType)) {
                this.setFieldIfPresent(entity, tableInfo, "createId", (Object)this.commonRequest.getUserId());
                this.setFieldIfPresent(entity, tableInfo, "createName", (Object)this.commonRequest.getUserName());
                this.setFieldIfPresent(entity, tableInfo, "createTime", (Object)new Date());
                this.setFieldIfPresent(entity, tableInfo, "tenantId", (Object)this.commonRequest.getTenant());
            } else if (SqlCommandType.UPDATE.equals((Object)sqlCommandType)) {
                this.setFieldIfPresent(entity, tableInfo, "updateId", (Object)this.commonRequest.getUserId());
                this.setFieldIfPresent(entity, tableInfo, "updateName", (Object)this.commonRequest.getUserName());
                this.setFieldIfPresent(entity, tableInfo, "updateTime", (Object)new Date());
            }
        }
    }

    private Object getEntityFromParameter(Object parameter) {
        if (parameter instanceof Map) {
            Map paramMap = (Map)parameter;
            for (Object value : paramMap.values()) {
                if (value == null || !value.getClass().isAnnotationPresent(TableName.class)) continue;
                return value;
            }
        }
        return parameter;
    }

    private void setFieldIfPresent(Object parameter, TableInfo tableInfo, String fieldName, Object value) {
        Optional<TableFieldInfo> fieldInfo;
        if (tableInfo != null && value != null && (fieldInfo = tableInfo.getFieldList().stream().filter(f -> f.getProperty().equals(fieldName)).findFirst()).isPresent()) {
            try {
                Field field = parameter.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(parameter, value);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    public void setCommonRequest(CommonRequest commonRequest) {
        this.commonRequest = commonRequest;
    }
}

