/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.scheduled;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.inpatient.api.enums.InpatFeeNodeCodeEnum;
import com.byh.inpatient.api.enums.ItemTypeFlagEnum;
import com.byh.inpatient.api.exception.BusinessException;
import com.byh.inpatient.api.model.InpatFee;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.InpatWardBed;
import com.byh.inpatient.api.sysModel.request.SysDictValueDTO;
import com.byh.inpatient.api.sysModel.respones.SysDictValueVo;
import com.byh.inpatient.api.sysModel.respones.SysTreatmentChargeVo;
import com.byh.inpatient.api.sysModel.respones.SysTreatmentItemVo;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.web.feign.SysServiceFeign;
import com.byh.inpatient.web.mvc.enums.InDeptStatus;
import com.byh.inpatient.web.mvc.enums.InHospEnum;
import com.byh.inpatient.web.mvc.enums.InpatFeeStatusEnum;
import com.byh.inpatient.web.mvc.enums.SignStatusEnum;
import com.byh.inpatient.web.service.IInpatFeeService;
import com.byh.inpatient.web.service.IInpatRegistService;
import com.byh.inpatient.web.service.IInpatWardBedService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class InpatBedFeeAutoChargeTask {
    private static final Logger log = LoggerFactory.getLogger(InpatBedFeeAutoChargeTask.class);
    private final SysServiceFeign sysServiceFeign;
    private final IInpatRegistService iInpatRegistService;
    private final IInpatWardBedService iInpatWardBedService;
    private final IInpatFeeService inpatFeeService;
    @Autowired
    private RedissonClient redissonClient;

    @Scheduled(cron="0 0 0 * * ?")
    public void executeBillingTask() {
        log.info("\u4f4f\u9662\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c...");
        RLock inpatBedFeeAutoChargeLock = this.redissonClient.getLock("inpatBedFeeAutoChargeLock");
        boolean isLock = false;
        try {
            isLock = inpatBedFeeAutoChargeLock.tryLock(30L, 60L, TimeUnit.SECONDS);
            if (!isLock) {
                log.warn("\u672a\u80fd\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\uff0c\u8df3\u8fc7\u672c\u6b21\u4efb\u52a1");
                return;
            }
            List inpatRegistList = this.iInpatRegistService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(InpatRegist::getSignStatus, (Object)SignStatusEnum.HAVE_REGIST.signStatusCode)).eq(InpatRegist::getInDeptStatusCode, (Object)InDeptStatus.IN_DEPT.inDeptStatusCode)).eq(InpatRegist::getInHospCode, (Object)InHospEnum.IN_HOSPITAL.iohospCode));
            if (inpatRegistList == null || inpatRegistList.isEmpty()) {
                return;
            }
            InpatRegist inpatRegist1 = (InpatRegist)inpatRegistList.get(0);
            SysDictValueDTO sysDictValueDTO = new SysDictValueDTO();
            sysDictValueDTO.setType("charge_unit");
            sysDictValueDTO.setSize(-1);
            ResponseData chargeUnitDictRes = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, inpatRegist1.getTenantId() + "");
            Map<String, String> chargeUnitDictMap = ((Page)chargeUnitDictRes.getData()).getRecords().stream().collect(Collectors.toMap(SysDictValueVo::getValue, SysDictValueVo::getLabel));
            sysDictValueDTO.setType("fee_category");
            ResponseData feeDictRes = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, inpatRegist1.getTenantId() + "");
            Map<String, String> feeDictMap = ((Page)feeDictRes.getData()).getRecords().stream().collect(Collectors.toMap(SysDictValueVo::getValue, SysDictValueVo::getLabel));
            for (InpatRegist inpatRegist : inpatRegistList) {
                ArrayList<InpatFee> inpatFeeList = new ArrayList<InpatFee>();
                BigDecimal totalAmount = BigDecimal.ONE;
                try {
                    InpatWardBed inpatWardBed = (InpatWardBed)this.iInpatWardBedService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(InpatWardBed::getBedNo, (Object)inpatRegist.getBedNo())).eq(InpatWardBed::getWardId, (Object)inpatRegist.getWardId())).eq(InpatWardBed::getIsEnabled, (Object)1));
                    Assert.notNull((Object)inpatWardBed, (String)("\u4f4f\u9662\u53f7\u4e3a\uff1a" + inpatRegist.getInpatNo() + " \u672a\u627e\u5230\u5e8a\u4f4d\u4fe1\u606f\uff01"), (Object[])new Object[0]);
                    String bedTypeCode = inpatWardBed.getBedTypeCode();
                    Integer[] itemIdArray = new Integer[2];
                    itemIdArray[0] = Integer.parseInt(bedTypeCode);
                    ResponseData listResponseData = this.sysServiceFeign.selectListWithChargeItems(itemIdArray);
                    if (!listResponseData.isSuccess() || listResponseData.getData() == null) {
                        throw new BusinessException("\u4f4f\u9662\u53f7\u4e3a\uff1a" + inpatRegist.getInpatNo() + "\u5e8a\u4f4d\u8bca\u7597\u9879\u76ee\u8be6\u60c5\u67e5\u8be2\u5931\u8d25");
                    }
                    SysTreatmentItemVo sysTreatmentItemVo = (SysTreatmentItemVo)((List)listResponseData.getData()).get(0);
                    for (SysTreatmentChargeVo sysTreatmentChargeVo : sysTreatmentItemVo.getSysTreatmentChargeVoList()) {
                        InpatFee inpatFee = new InpatFee();
                        inpatFee.setOperatorName("\u8d85\u7ea7\u7ba1\u7406\u5458");
                        inpatFee.setOperatorId(Integer.valueOf(1));
                        inpatFee.setOrderDoctorName(inpatRegist.getInpatDoctorName());
                        inpatFee.setOrderDoctorId(inpatRegist.getInpatDoctorId());
                        inpatFee.setOrderDeptId(inpatRegist.getDeptId());
                        inpatFee.setOrderDeptName(inpatRegist.getDeptName());
                        inpatFee.setOrderWardId(inpatRegist.getWardId());
                        inpatFee.setOrderWardName(inpatRegist.getWardName());
                        inpatFee.setOrderTypeCode(sysTreatmentItemVo.getTreatmentTypeCode());
                        inpatFee.setOrderTypeName(sysTreatmentItemVo.getTreatmentTypeName());
                        inpatFee.setChargeTypeCode(sysTreatmentChargeVo.getChargeItemId());
                        inpatFee.setChargeTypeName(feeDictMap.get(sysTreatmentChargeVo.getChargeItemId()));
                        inpatFee.setChargeItemCode(sysTreatmentChargeVo.getChargeItemCode());
                        inpatFee.setChargeItemName(sysTreatmentChargeVo.getChargeItemName());
                        inpatFee.setOrderItemName(sysTreatmentItemVo.getItemName());
                        inpatFee.setOrderItemCode(sysTreatmentItemVo.getItemCode());
                        inpatFee.setChargeItemNum(BigDecimal.valueOf(sysTreatmentChargeVo.getQuantity().intValue()));
                        inpatFee.setOrderItemNum(BigDecimal.ONE);
                        if (StrUtil.isNotBlank((CharSequence)sysTreatmentChargeVo.getUnit())) {
                            inpatFee.setChargeItemUnit(chargeUnitDictMap.get(sysTreatmentChargeVo.getUnit()));
                        }
                        if (StrUtil.isNotBlank((CharSequence)sysTreatmentChargeVo.getUnit())) {
                            inpatFee.setOrderItemSpec(chargeUnitDictMap.get(sysTreatmentItemVo.getUnit()));
                        }
                        inpatFee.setChargeItemAmount(sysTreatmentChargeVo.getItemPrice().multiply(BigDecimal.valueOf(sysTreatmentChargeVo.getQuantity().intValue())));
                        inpatFee.setChargeItemPrice(sysTreatmentChargeVo.getItemPrice());
                        inpatFee.setOrderItemPrice(sysTreatmentItemVo.getTotalPrice());
                        inpatFee.setInpatRegId(inpatRegist.getId());
                        inpatFee.setInpatDeptId(inpatRegist.getDeptId());
                        inpatFee.setInpatDeptName(inpatRegist.getDeptName());
                        inpatFee.setResidentDoctorName(inpatRegist.getInpatDoctorName());
                        inpatFee.setResidentDoctorId(inpatRegist.getInpatDoctorId());
                        inpatFee.setStatusName(InpatFeeStatusEnum.CHARGED.getStatusName());
                        inpatFee.setStatusCode(InpatFeeStatusEnum.CHARGED.getStatusCode());
                        inpatFee.setFeeNodeCode(InpatFeeNodeCodeEnum.AUTO_CHARGE.getCode());
                        inpatFee.setFeeNodeName(InpatFeeNodeCodeEnum.AUTO_CHARGE.getName());
                        inpatFee.setItemTypeFlag(ItemTypeFlagEnum.Treatment.getCode());
                        inpatFee.setTallyTime(new Date());
                        inpatFee.setOrderBackNum(new BigDecimal(0));
                        inpatFee.setHospApprFlag(Integer.valueOf(1));
                        inpatFeeList.add(inpatFee);
                        totalAmount = totalAmount.add(inpatFee.getChargeItemAmount());
                    }
                }
                catch (Exception e) {
                    log.error("\u5e8a\u4f4d\u8d39\u65b0\u589e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
                log.info("\u533b\u5631\u6267\u884c\u8ba1\u8d39\u8282\u70b9\uff1a\u8bca\u7597\u9879\u76ee\u7684\u533b\u5631\u8d39\u7528\u660e\u7ec6\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(inpatFeeList));
                this.inpatFeeService.saveBatch(inpatFeeList);
                this.iInpatRegistService.doDeduction(inpatRegist.getId(), totalAmount);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4f4f\u9662\u5e8a\u4f4d\u81ea\u52a8\u6536\u8d39\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (isLock) {
                inpatBedFeeAutoChargeLock.unlock();
            }
        }
    }

    public InpatBedFeeAutoChargeTask(SysServiceFeign sysServiceFeign, IInpatRegistService iInpatRegistService, IInpatWardBedService iInpatWardBedService, IInpatFeeService inpatFeeService, RedissonClient redissonClient) {
        this.sysServiceFeign = sysServiceFeign;
        this.iInpatRegistService = iInpatRegistService;
        this.iInpatWardBedService = iInpatWardBedService;
        this.inpatFeeService = inpatFeeService;
        this.redissonClient = redissonClient;
    }
}

