/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.utils;

import cn.hutool.core.util.StrUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonRequest {
    private static final Logger log = LoggerFactory.getLogger(CommonRequest.class);
    @Autowired
    private HttpServletRequest request;

    public Integer getTenant() {
        try {
            String tenantId = this.request.getHeader("tenantId");
            if (StrUtil.isNotEmpty((CharSequence)tenantId)) {
                return Integer.parseInt(tenantId);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return 1;
    }

    public Integer getUserId() {
        try {
            String userId = this.request.getHeader("userId");
            if (StrUtil.isNotEmpty((CharSequence)userId)) {
                return Integer.parseInt(userId);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return 1;
    }

    public String getUserName() {
        try {
            return URLDecoder.decode(this.request.getHeader("userName"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            String userName = this.request.getHeader("userName");
            if (StrUtil.isNotBlank((CharSequence)userName)) {
                return userName;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return "\u8d85\u7ea7\u7ba1\u7406\u5458";
    }

    public String getSignNo() {
        try {
            return Objects.isNull(this.request.getHeader("signNo")) ? "99999" : this.request.getHeader("signNo");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return "99999";
        }
    }
}

