/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.utils;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjuster;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils
extends org.apache.commons.lang.time.DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final String FULL_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String FULL_NORMAL_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String YMD_NORMAL_FORMAT = "yyyy-MM-dd";
    public static final String YM_NORMAL_FORMAT = "yyyy-MM";
    public static final String FULL_CHINESE_NORMAL_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss";
    public static final String YMD_SIMPLE_NORMAL_FORMAT = "yyyyMMdd";
    public static final String FULL_SIMPLE_NORMAL_FORMAT = "yyyyMMddHHmmss";
    private static String[] parsePatterns = new String[]{"yyyyMMddHHmmss", "yyyyMMdd", "yyyyMMddHHmm", "yyyyMM", "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};
    public static final String MY_NORMAL_FORMAT = "M/d";

    private DateUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static String getDate() {
        return DateUtils.getDate((String)"yyyy-MM-dd");
    }

    public static Date getDateBefore(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) - day);
        return now.getTime();
    }

    public static String getDateAfter(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) + day);
        return DateUtils.dateToSimpleString((Date)now.getTime());
    }

    public static Date getDateAfterNew(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) + day);
        Date time = now.getTime();
        return now.getTime();
    }

    public static long secondsBetween1(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 1000L;
        return betweenDays;
    }

    public static Date stringToFullDate(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String dateToSimpleString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(date);
    }

    public static String getCurrentDateToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(calendar.getTime());
    }

    public static String getDate(String pattern) {
        return DateFormatUtils.format((Date)new Date(), (String)pattern);
    }

    public static String formatDate(Date date, Object ... pattern) {
        if (date == null) {
            return null;
        }
        String formatDate = null;
        formatDate = pattern != null && pattern.length > 0 ? DateFormatUtils.format((Date)date, (String)pattern[0].toString()) : DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
        return formatDate;
    }

    public static String formatDateTime(Date date) {
        return DateUtils.formatDate((Date)date, (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"});
    }

    public static String formatNewDateTime(Date date) {
        return DateUtils.formatDate((Date)date, (Object[])new Object[]{"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss"});
    }

    public static String getTime() {
        return DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"HH:mm:ss"});
    }

    public static String getDateTimeV1(Date date) {
        return DateUtils.formatDate((Date)date, (Object[])new Object[]{"HH:mm:ss"});
    }

    public static String getDateTime() {
        return DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"});
    }

    public static String getYear() {
        return DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyy"});
    }

    public static String getMonth() {
        return DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"MM"});
    }

    public static String getDay() {
        return DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"dd"});
    }

    public static String getWeek() {
        return DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"E"});
    }

    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date generateRandomTimestamp() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 8);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long randomOffsetMillis = (long)(Math.random() * 10.0 * 60.0 * 60.0 * 1000.0);
        calendar.setTimeInMillis(calendar.getTimeInMillis() + randomOffsetMillis);
        return calendar.getTime();
    }

    public static Date parseY_M_DDate(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseYMDFullDateTime(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseYMDDate(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str, (String)"yyyyMMdd");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseHMSDate(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str, (String)"HH:mm:ss");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static long pastDays(Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 86400000L;
    }

    public static long pastHour(Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 3600000L;
    }

    public static long pastMinutes(Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 60000L;
    }

    public static Integer getWeekOfYearByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        calendar.setTimeInMillis(date.getTime());
        int weekOfYear = calendar.get(3);
        return weekOfYear;
    }

    public static Date getDayByDateInBoundary(Date date, TemporalAdjuster temporalAdjuster) {
        if (date == null || temporalAdjuster == null) {
            return null;
        }
        String dateStr = DateUtils.formatDate((Date)date, (Object[])new Object[0]);
        LocalDate inputDate = LocalDate.parse(dateStr);
        LocalDate day = inputDate.with(temporalAdjuster);
        ZonedDateTime zonedDateTime = day.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static String formatDateTime(long timeMillis) {
        long day = timeMillis / 86400000L;
        long hour = timeMillis / 3600000L - day * 24L;
        long min = timeMillis / 60000L - day * 24L * 60L - hour * 60L;
        long s = timeMillis / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long sss = timeMillis - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        return (day > 0L ? day + "," : "") + hour + ":" + min + ":" + s + "." + sss;
    }

    public static long getDistanceOfTwoDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 86400000L;
    }

    public static Long getSecondOfTwoDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 1000L;
    }

    public static String getTimeStamp() {
        return String.valueOf(new BigDecimal(System.currentTimeMillis()).divide(new BigDecimal("1000")).intValue());
    }

    public static Date genDayBreakDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date date = calendar.getTime();
        if (date.before(new Date())) {
            date = DateUtils.addDay((Date)date, (int)1);
        }
        return date;
    }

    public static Date addDay(Date date, int num) {
        Calendar startDT = Calendar.getInstance();
        startDT.setTime(date);
        startDT.add(5, num);
        return startDT.getTime();
    }

    public static String formatYMDDateTime(String datestr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = format.parse(datestr);
        }
        catch (ParseException e) {
            return null;
        }
        SimpleDateFormat formatTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatTime.format(date);
    }

    public static String formatFullDateTime(String datestr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = null;
        try {
            date = format.parse(datestr);
        }
        catch (ParseException e) {
            return null;
        }
        SimpleDateFormat formatTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatTime.format(date);
    }

    public static String formatABCDateTime(String datestr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = null;
        try {
            date = format.parse(datestr);
        }
        catch (ParseException e) {
            return null;
        }
        SimpleDateFormat formatTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatTime.format(date);
    }

    public static Date parseFullFormatDate(String strDate) {
        try {
            return DateUtils.parseDate((String)strDate, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Integer getDateTimeStamp(Date date) {
        if (Objects.isNull(date)) {
            date = new Date();
        }
        return (int)(date.getTime() / 1000L);
    }

    public static Date parseABCFormatDate(String strDate) {
        try {
            return DateUtils.parseDate((String)strDate, (String)"yyyy/MM/dd HH:mm:ss");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseDate(String str, String parsePatterns) throws ParseException {
        if (str == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        SimpleDateFormat parser = null;
        ParsePosition pos = new ParsePosition(0);
        parser = new SimpleDateFormat(parsePatterns);
        pos.setIndex(0);
        Date date = parser.parse(str, pos);
        if (date != null && pos.getIndex() == str.length()) {
            return date;
        }
        throw new ParseException("Unable to parse the date: " + str, -1);
    }

    public static Date getFormatDBDate(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = sDateFormat.format(timestamp);
        if (StringUtils.isNotBlank((String)dateStr)) {
            try {
                return sDateFormat.parse(dateStr);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public static Date getDateBy13Timestamp(long timestamp) {
        if (timestamp == 0L) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        String format = sdf.format(new Date(timestamp));
        if (StringUtils.isNotBlank((String)format)) {
            try {
                return sdf.parse(format);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public static String getCurrentDateSimpleToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(DateUtils.getDate());
        return df.format(calendar.getTime());
    }

    public static Date getThisDateTime(Date date) {
        String dateTimeStr = DateUtils.formatDate((Date)date, (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"});
        try {
            return DateUtils.parseDate((String)dateTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            log.info("\u683c\u5f0f\u5316\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static int getWeekDay(Date date) {
        if (date == null) {
            return -1;
        }
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int weekday = cal.get(7) - 1;
        return weekday;
    }

    public static int getWeekDay() {
        Date date = new Date();
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int weekday = cal.get(7) - 1;
        return weekday;
    }

    public static Long getTimeStamp(String time) {
        Long timestamp = null;
        try {
            timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time).getTime();
        }
        catch (ParseException e) {
            log.info("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return timestamp;
    }

    public static String getDateString(Long time) {
        String format = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            format = simpleDateFormat.format(time * 1000L);
        }
        catch (Exception e) {
            log.info("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return format;
    }

    public static String getMonthEndString(String month) {
        try {
            Date d = DateUtils.parseDate((String)month, (String)"yyyy-MM");
            d = DateUtils.parseY_Mate((Date)d);
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            cal.add(2, 1);
            cal.add(13, -1);
            return DateUtils.formatDateTime((Date)cal.getTime());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.getMonthEndString((String)"2024-02"));
    }

    public static String getYMD(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        String format = sdf.format(date);
        return format;
    }

    public static List<String> sortAsc(List<String> dataStr) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dataStr.sort((a1, a2) -> {
            try {
                return df.parse((String)a1).compareTo(df.parse((String)a2));
            }
            catch (ParseException e) {
                log.info("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                return 1;
            }
        });
        return dataStr;
    }

    public static int getAgeByBirthDay(Date birthDay) {
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthDay)) {
            return 0;
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthDay);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayOfMonthBirth = cal.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static Date getBirthDayFromIdCard(String idCard) throws ParseException {
        Date birth = null;
        if (idCard.length() == 18) {
            String year = idCard.substring(6).substring(0, 4);
            String month = idCard.substring(10).substring(0, 2);
            String day = idCard.substring(12).substring(0, 2);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            birth = format.parse(year + "-" + month + "-" + day);
        } else if (idCard.length() == 15) {
            String year = "19" + idCard.substring(6, 8);
            String month = idCard.substring(8, 10);
            String day = idCard.substring(10, 12);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            birth = format.parse(year + "-" + month + "-" + day);
        }
        return birth;
    }

    public static Date getDateToString(Long time) {
        if (time == null) {
            return null;
        }
        String format = null;
        Date date = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            format = simpleDateFormat.format(time * 1000L);
            date = DateUtils.parseDate((String)format, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (Exception e) {
            log.info("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return date;
    }

    public static Date getDateToDate(Date today) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String date = format.format(today);
        return DateUtils.parseY_M_DDate((String)date);
    }

    public static String convertDate2String(String format, Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(date);
    }

    public static Date convertString2Date(String format, String dateStr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        try {
            Date date = simpleDateFormat.parse(dateStr);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getDaysBetween(String dateStr1, String dateStr2) throws Exception {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate date1 = LocalDate.parse(dateStr1, formatter);
        LocalDate date2 = LocalDate.parse(dateStr2, formatter);
        long daysBetween = ChronoUnit.DAYS.between(date1, date2);
        return (int)daysBetween;
    }

    public static List<String> getIntervalDateTimeList(Date startDate, Date endDate, int interval) {
        ArrayList<String> list = new ArrayList<String>();
        while (startDate.getTime() <= endDate.getTime()) {
            list.add(DateUtils.convertDate2String((String)"yyyy-MM-dd HH:mm:ss", (Date)startDate));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            calendar.add(12, interval);
            if (calendar.getTime().getTime() > endDate.getTime()) {
                if (!startDate.equals(endDate)) {
                    list.add(DateUtils.convertDate2String((String)"yyyy-MM-dd HH:mm:ss", (Date)endDate));
                }
                startDate = calendar.getTime();
                continue;
            }
            startDate = calendar.getTime();
        }
        return list;
    }

    public static Date getSubtractMonth(Date date, int month) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(2, month);
        return now.getTime();
    }

    public static Date parseY_Mate(Date date) {
        String str = DateUtils.formatDate((Date)date, (Object[])new Object[]{"yyyy-MM"});
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str, (String)"yyyy-MM");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static boolean contrastRemoveHourMinuteSecond(Date dateOne, Date dateTwo) {
        String strOne = DateUtils.formatDate((Date)dateOne, (Object[])new Object[]{"yyyy-MM-dd"});
        String strTwo = DateUtils.formatDate((Date)dateTwo, (Object[])new Object[]{"yyyy-MM-dd"});
        if (StringUtils.isBlank((String)strOne) || StringUtils.isBlank((String)strTwo)) {
            return false;
        }
        try {
            Date timeOne = DateUtils.parseDate((String)strOne, (String)"yyyy-MM-dd");
            Date timeTwo = DateUtils.parseDate((String)strTwo, (String)"yyyy-MM-dd");
            return timeOne.equals(timeTwo);
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static String getDateTimeByDate(Date date) {
        return DateUtils.formatDate((Date)date, (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"});
    }

    public static String getDateTimeY_M_D(Date date) {
        return DateUtils.formatDate((Date)date, (Object[])new Object[]{"yyyy-MM-dd"});
    }

    public static String getSubtractSFM(String begin, String end) {
        StringBuilder time;
        block7: {
            time = new StringBuilder();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date beginTime = sdf.parse(begin);
                Date endTime = sdf.parse(end);
                long diffInMillis = endTime.getTime() - beginTime.getTime();
                long hours = diffInMillis / 3600000L;
                long minutes = diffInMillis / 60000L % 60L;
                long seconds = diffInMillis / 1000L % 60L;
                if (diffInMillis > 0L) {
                    if (hours > 0L) {
                        time.append(hours + "\u5c0f\u65f6");
                    }
                    if (minutes > 0L) {
                        time.append(minutes + "\u5206");
                    }
                    if (seconds > 0L) {
                        time.append(seconds + "\u79d2");
                    } else {
                        time.append("0\u79d2");
                    }
                    break block7;
                }
                return "0";
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return time.toString();
    }
}

