/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.inpatient.api.dto.order.SaveOrderDto;
import com.byh.inpatient.api.dto.prescription.SaveEntrustItemsDto;
import com.byh.inpatient.api.enums.InpatpatientDataStatusEnum;
import com.byh.inpatient.api.enums.OrderTypeEnum;
import com.byh.inpatient.api.enums.ProjectDetailsStatusEnum;
import com.byh.inpatient.api.model.Entrustment;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.order.InpatOrder;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.data.repository.EntrustmentMapper;
import com.byh.inpatient.data.repository.InpatOrderMapper;
import com.byh.inpatient.web.mvc.utils.UUIDUtils;
import com.byh.inpatient.web.service.EntrustmentService;
import com.byh.inpatient.web.service.IInpatRegistService;
import com.byh.inpatient.web.service.InpatOrderService;
import com.byh.inpatient.web.service.impl.TreatmentItemsServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class EntrustmentServiceImpl
extends ServiceImpl<EntrustmentMapper, Entrustment>
implements EntrustmentService {
    private static Logger log = LoggerFactory.getLogger(TreatmentItemsServiceImpl.class);
    @Autowired
    private InpatOrderService inpatOrderService;
    @Autowired
    private EntrustmentMapper entrustmentMapper;
    @Autowired
    private InpatOrderMapper inpatOrderMapper;
    @Autowired
    IInpatRegistService iInpatRegistService;

    public ResponseData<String> saveEntrustItems(SaveEntrustItemsDto parameter) {
        log.info("SaveTreatmentItemsDto{}", (Object)JSON.toJSONString((Object)parameter));
        InpatRegist inpatRegist = this.iInpatRegistService.selectByInpatNo(parameter.getInpatNo());
        Assert.notNull((Object)inpatRegist, (String)"\u672a\u627e\u5230\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f!");
        for (SaveEntrustItemsDto.Project project : parameter.getProjectList()) {
            Entrustment entrustment = new Entrustment();
            BeanUtils.copyProperties((Object)project, (Object)entrustment);
            entrustment.setUpdateId(parameter.getOperatorId());
            entrustment.setUpdateTime(new Date());
            entrustment.setCreateId(parameter.getOperatorId());
            entrustment.setCreateTime(new Date());
            entrustment.setInpatNo(parameter.getInpatNo());
            entrustment.setStatus(ProjectDetailsStatusEnum.ISSUED.getValue());
            if (StringUtils.isNotEmpty((CharSequence)project.getId())) {
                entrustment.setId(project.getId());
                this.entrustmentMapper.updateById((Object)entrustment);
            } else {
                entrustment.setId(UUIDUtils.getTransactionNo());
                this.entrustmentMapper.insert((Object)entrustment);
            }
            SaveOrderDto saveOrderDto = new SaveOrderDto();
            saveOrderDto.setTenantId(parameter.getTenantId());
            saveOrderDto.setPrescriptionNo(String.valueOf(entrustment.getId()));
            saveOrderDto.setInpatNo(parameter.getInpatNo());
            saveOrderDto.setPatientName(inpatRegist.getPatientName());
            saveOrderDto.setMedicalRecordNo(inpatRegist.getMedicalRecordNo());
            saveOrderDto.setOrderAmount(new BigDecimal(0));
            saveOrderDto.setActualOtherPayment(new BigDecimal(0));
            saveOrderDto.setRegTime(DateUtil.formatDateTime((Date)new Date()));
            saveOrderDto.setPatientCardNo(inpatRegist.getCardNo());
            saveOrderDto.setCreateName(parameter.getOperatorName());
            this.inpatOrderService.saveOrder(OrderTypeEnum.getEnumByProjectType((String)"16"), saveOrderDto);
        }
        return ResponseData.success((String)"\u64cd\u4f5c\u5b8c\u6210\uff01", (Object)"\u64cd\u4f5c\u5b8c\u6210\uff01");
    }

    public ResponseData<List<Entrustment>> selectEntrustItems(String inpatNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"inpat_no", (Object)inpatNo);
        List outTreatmentDetails = this.entrustmentMapper.selectList((Wrapper)queryWrapper);
        return ResponseData.success((Object)outTreatmentDetails);
    }

    public ResponseData<Entrustment> selectEntrustItemsDetail(String id) {
        Entrustment entrustment = (Entrustment)this.entrustmentMapper.selectById((Serializable)((Object)id));
        return ResponseData.success((Object)entrustment);
    }

    public ResponseData<String> delEntrustItems(String id) {
        Entrustment entrustment = (Entrustment)this.entrustmentMapper.selectById((Serializable)((Object)id));
        if (null == entrustment) {
            return ResponseData.error((String)"\u672a\u67e5\u8be2\u5230");
        }
        if (entrustment.getStatus() >= ProjectDetailsStatusEnum.PENDING_EXECUTION.getValue()) {
            return ResponseData.error((String)"\u8be5\u5904\u65b9\u4e2d\u6709\u836f\u54c1\u5728\u4e0d\u53ef\u64a4\u9500\u72b6\u6001!");
        }
        QueryWrapper queryrOrder = new QueryWrapper();
        ((QueryWrapper)queryrOrder.in((Object)"prescription_no", new Object[]{id})).eq((Object)"status", (Object)InpatpatientDataStatusEnum.NORMAL.getValue());
        InpatOrder outOrder = (InpatOrder)this.inpatOrderMapper.selectOne((Wrapper)queryrOrder);
        if (outOrder == null) {
            return ResponseData.error((String)"\u6ca1\u6709\u627e\u5230\u8ba2\u5355");
        }
        outOrder.setStatus(InpatpatientDataStatusEnum.STATUS_VOID.getValue());
        this.inpatOrderMapper.updateById((Object)outOrder);
        entrustment.setStatus(ProjectDetailsStatusEnum.INVALID.getValue());
        this.entrustmentMapper.updateById((Object)entrustment);
        return ResponseData.success((String)"\u64cd\u4f5c\u6210\u529f", (Object)"\u64cd\u4f5c\u6210\u529f");
    }
}

