/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.inpatient.api.enums.InpatOrderStatusEnum;
import com.byh.inpatient.api.enums.OrderCategoryEnum;
import com.byh.inpatient.api.exception.BusinessException;
import com.byh.inpatient.api.model.InpatOrder;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.dto.InpatOrderDTO;
import com.byh.inpatient.api.util.BeanUtil;
import com.byh.inpatient.data.repository.IInpatOrderMapper;
import com.byh.inpatient.web.service.IInpatOrderService;
import com.byh.inpatient.web.service.IInpatRegistService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class IInpatOrderServiceImpl
extends ServiceImpl<IInpatOrderMapper, InpatOrder>
implements IInpatOrderService {
    @Autowired
    IInpatRegistService iInpatRegistService;
    @Autowired
    IInpatOrderMapper inpatOrderMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Transactional(rollbackFor={Exception.class})
    public List<InpatOrder> saveInpatOrder(InpatOrderDTO inpatOrderDTO) {
        Assert.notNull((Object)inpatOrderDTO, (String)"\u4f4f\u9662\u533b\u5631\u4e0d\u80fd\u4e3a\u7a7a!");
        if (StrUtil.isBlank((CharSequence)inpatOrderDTO.getOrderCategoryCode())) {
            throw new BusinessException("\u4f4f\u9662\u533b\u5631\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (inpatOrderDTO.getInpatOrderList() != null && !inpatOrderDTO.getInpatOrderList().isEmpty()) {
            throw new BusinessException("\u4f4f\u9662\u533b\u5631\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ArrayList<InpatOrder> inpatOrders = new ArrayList();
        if (OrderCategoryEnum.WESTERN_OR_CHINESE_PATENT_MEDICINE.getCategoryCode().equals(inpatOrderDTO.getOrderCategoryCode())) {
            inpatOrders = this.insertOrUpdateByXc(inpatOrderDTO);
        } else if (OrderCategoryEnum.HERBAL_MEDICINE.getCategoryCode().equals(inpatOrderDTO.getOrderCategoryCode())) {
            this.insertOrUpdateByZy(inpatOrderDTO);
        }
        return inpatOrders;
    }

    public List<InpatOrder> insertOrUpdateByXc(InpatOrderDTO inpatOrderDTO) {
        InpatRegist inpatRegist = this.iInpatRegistService.selectByInpatNo(inpatOrderDTO.getInpatNo());
        Assert.notNull((Object)inpatRegist, (String)"\u672a\u627e\u5230\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f!");
        ArrayList<InpatOrder> resInpatOrderList = new ArrayList<InpatOrder>();
        inpatOrderDTO.getInpatOrderList().forEach(item -> {
            InpatOrder inpatOrder = new InpatOrder();
            BeanUtil.copy((Object)item, (Object)inpatOrder);
            inpatOrder.setDeptId(inpatOrderDTO.getOpenDeptId());
            inpatOrder.setDeptName(inpatOrderDTO.getOpenDeptName());
            inpatOrder.setWardId(inpatOrderDTO.getOpenWardId());
            inpatOrder.setWardName(inpatOrderDTO.getOpenWardName());
            inpatOrder.setOrderDoctorId(inpatOrderDTO.getOpenDoctorId());
            inpatOrder.setOrderDoctorName(inpatOrderDTO.getOpenDoctorName());
            inpatOrder.setOrderCategoryCode(inpatOrderDTO.getOrderCategoryCode());
            inpatOrder.setOrderCategoryName(inpatOrderDTO.getOrderCategoryName());
            inpatOrder.setInpatRegId(inpatRegist.getId());
            inpatOrder.setOrderTime(new Date());
            inpatOrder.setStatusCode(InpatOrderStatusEnum.NOT_AUDIT.getStatusCode());
            inpatOrder.setStatusName(InpatOrderStatusEnum.NOT_AUDIT.getStatusName());
            resInpatOrderList.add(inpatOrder);
            boolean isSuccess = this.inpatOrderMapper.insertOrUpdate((Object)inpatOrder);
            Assert.isTrue((boolean)isSuccess, (String)"\u4fdd\u5b58\u533b\u5631\u5931\u8d25");
        });
        return resInpatOrderList;
    }

    public InpatOrder insertOrUpdateByZy(InpatOrderDTO inpatOrderDTO) {
        return null;
    }
}

