/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.NursePlanRecord;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.api.vo.inpatVitalSigns.SaveNursePlanRecordReqVo;
import com.byh.inpatient.api.vo.inpatVitalSigns.SelectVitalSignsRecordReqVo;
import com.byh.inpatient.data.repository.InpatNursePlanMapper;
import com.byh.inpatient.web.service.IInpatRegistService;
import com.byh.inpatient.web.service.InpatNursePlanService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InpatNursePlanServiceImpl
extends ServiceImpl<InpatNursePlanMapper, NursePlanRecord>
implements InpatNursePlanService {
    @Autowired
    private IInpatRegistService iInpatRegistService;

    public ResponseData<String> saveInpatNursePlan(SaveNursePlanRecordReqVo parameter) {
        try {
            InpatRegist inpatRegist = this.iInpatRegistService.selectByInpatNo(parameter.getInpatNo());
            if (null == inpatRegist) {
                return ResponseData.error((String)"\u672a\u67e5\u8be2\u5230\u4f4f\u9662\u60a3\u8005");
            }
            NursePlanRecord nursePlanRecord = new NursePlanRecord();
            BeanUtils.copyProperties((Object)parameter, (Object)nursePlanRecord);
            if (null != parameter.getId()) {
                nursePlanRecord.setUpdateTime(new Date());
                nursePlanRecord.setUpdateId(parameter.getOperatorId());
            } else {
                nursePlanRecord.setCreateTime(new Date());
                nursePlanRecord.setCreateId(parameter.getOperatorId());
                nursePlanRecord.setCreateName(parameter.getOperatorName());
            }
            ((InpatNursePlanMapper)this.baseMapper).insertOrUpdate((Object)nursePlanRecord);
            return ResponseData.success((String)"\u64cd\u4f5c\u6210\u529f", (Object)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            return ResponseData.error((String)("\u64cd\u4f5c\u5931\u8d25" + e.getMessage()));
        }
    }

    public ResponseData<List<NursePlanRecord>> selectInpatNursePlan(SelectVitalSignsRecordReqVo parameter) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"inpat_no", (Object)parameter.getInpatNo());
            queryWrapper.eq((Object)"status", (Object)1);
            if (null != parameter.getId()) {
                queryWrapper.eq((Object)"id", (Object)parameter.getId());
            }
            queryWrapper.orderByDesc((Object)"create_time");
            List nursePlanRecords = ((InpatNursePlanMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
            return ResponseData.success((Object)nursePlanRecords);
        }
        catch (Exception e) {
            return ResponseData.error((String)("\u64cd\u4f5c\u5931\u8d25" + e.getMessage()));
        }
    }
}

