/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.inpatient.api.enums.FeeStatusEnum;
import com.byh.inpatient.api.enums.PaymentMethodEnum;
import com.byh.inpatient.api.exception.BusinessException;
import com.byh.inpatient.api.model.InpatFee;
import com.byh.inpatient.api.model.InpatPrepay;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.dto.ICBCPayDto;
import com.byh.inpatient.api.model.dto.prepay.PrepayDto;
import com.byh.inpatient.api.model.dto.prepay.QueryDetailDto;
import com.byh.inpatient.api.model.dto.prepay.QueryPrepayDto;
import com.byh.inpatient.api.model.dto.prepay.QueryPrintDataDto;
import com.byh.inpatient.api.model.vo.prepay.PrepaySuccessVo;
import com.byh.inpatient.api.model.vo.prepay.QueryDetailVo;
import com.byh.inpatient.api.model.vo.prepay.QueryPrepayVo;
import com.byh.inpatient.api.model.vo.prepay.QueryPrintDataVo;
import com.byh.inpatient.api.util.ExceptionUtils;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.api.util.UUIDUtils;
import com.byh.inpatient.data.repository.InpatFeeMapper;
import com.byh.inpatient.data.repository.InpatPrepayMapper;
import com.byh.inpatient.data.repository.InpatRegistMapper;
import com.byh.inpatient.web.feign.SdkServiceFeign;
import com.byh.inpatient.web.mvc.utils.NumberToChinese;
import com.byh.inpatient.web.service.IInpatPrepayService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InpatPrepayServiceImpl
extends ServiceImpl<InpatPrepayMapper, InpatPrepay>
implements IInpatPrepayService {
    private Logger logger = LoggerFactory.getLogger(InpatPrepayServiceImpl.class);
    @Resource
    private SdkServiceFeign sdkServiceFeign;
    @Resource
    private InpatPrepayMapper inpatPrepayMapper;
    @Resource
    private InpatFeeMapper inpatFeeMapper;
    @Resource
    private InpatRegistMapper inpatRegistMapper;

    public List<QueryPrintDataVo> selectPrintDate(QueryPrintDataDto dto) {
        if ("1".equals(dto.getPrintType())) {
            dto.setInpatRegId(Integer.valueOf(dto.getSearchNo()));
        } else {
            dto.setSettleNo(dto.getSearchNo());
        }
        List list = this.inpatPrepayMapper.selectPrintDate(dto);
        list.forEach(vo -> {
            if (vo.getPrepayAmount() != null) {
                vo.setPrepayChinese(NumberToChinese.toChinese((BigDecimal)vo.getPrepayAmount()));
            }
        });
        return list;
    }

    public QueryDetailVo selectDetailList(QueryDetailDto dto) {
        QueryDetailVo queryDetailVo = this.inpatRegistMapper.selectByInpatRegId(dto);
        if (queryDetailVo == null) {
            return queryDetailVo;
        }
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.inpatPrepayMapper.selectDetailPageList(page, dto);
        page.setRecords(list);
        queryDetailVo.setPage(page);
        return queryDetailVo;
    }

    public Page<QueryPrepayVo> selectPageList(QueryPrepayDto dto) {
        Integer tenantId = dto.getTenantId();
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.inpatPrepayMapper.selectPageList(page, dto);
        if (!list.isEmpty()) {
            List inpatRegIds = list.stream().map(QueryPrepayVo::getInpatRegId).collect(Collectors.toList());
            List inpatFeeList = this.inpatFeeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InpatFee.class).eq(tenantId != null, InpatFee::getTenantId, (Object)tenantId)).eq(InpatFee::getStatusCode, (Object)FeeStatusEnum.CHARGED.getValue())).in(InpatFee::getInpatRegId, inpatRegIds));
            if (!inpatFeeList.isEmpty()) {
                List feeIds = inpatFeeList.stream().map(InpatFee::getId).collect(Collectors.toList());
                List refundFeeList = this.inpatFeeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InpatFee.class).eq(tenantId != null, InpatFee::getTenantId, (Object)tenantId)).eq(InpatFee::getStatusCode, (Object)FeeStatusEnum.REFUNDED.getValue())).in(InpatFee::getBackInpatFeeId, feeIds));
                Map<Integer, BigDecimal> inpatFeeMap = inpatFeeList.stream().collect(Collectors.groupingBy(InpatFee::getInpatRegId, Collectors.reducing(BigDecimal.ZERO, fee -> fee.getChargeItemPrice().multiply(fee.getChargeItemNum()), BigDecimal::add)));
                if (!refundFeeList.isEmpty()) {
                    Map<Integer, BigDecimal> refundFeeMap = refundFeeList.stream().collect(Collectors.groupingBy(InpatFee::getInpatRegId, Collectors.reducing(BigDecimal.ZERO, fee -> fee.getChargeItemPrice().negate().multiply(fee.getOrderBackNum()), BigDecimal::add)));
                    refundFeeMap.forEach((inpatRegId, refundAmount) -> inpatFeeMap.merge((Integer)inpatRegId, (BigDecimal)refundAmount, BigDecimal::add));
                    list.forEach(vo -> {
                        BigDecimal totalAmount = (BigDecimal)inpatFeeMap.get(vo.getInpatRegId());
                        if (totalAmount != null) {
                            vo.setTotalInpatFee(totalAmount);
                        }
                    });
                }
            }
        }
        page.setRecords(list);
        return page;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public PrepaySuccessVo prepay(PrepayDto dto) {
        String payWayName;
        this.logger.info("\u7f34\u7eb3\u9884\u4ea4\u91d1-->\u4f20\u5165\u53c2\u6570{}", (Object)JSON.toJSONString((Object)dto));
        Integer tenantId = dto.getTenantId();
        Integer inpatRegId = dto.getInpatRegId();
        BigDecimal prepayAmount = dto.getPrepayAmount();
        if (prepayAmount.compareTo(BigDecimal.ZERO) == 0) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u4f4f\u9662\u9884\u4ea4\u91d1\u4e0d\u53ef\u4e3a0\uff01");
        }
        if (StrUtil.isEmpty((CharSequence)(payWayName = (String)Optional.ofNullable(PaymentMethodEnum.getLabel((String)dto.getPayWayCode())).map(PaymentMethodEnum::getLabel).orElse(null)))) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5b58\u5728\uff01");
        }
        dto.setPayWayName(payWayName);
        BigDecimal prepayBalance = this.getBalanceAmount(tenantId, inpatRegId);
        prepayBalance = prepayBalance.add(prepayAmount);
        dto.setPrepayBalance(prepayBalance);
        InpatPrepay inpatPrepay = new InpatPrepay();
        BeanUtils.copyProperties((Object)dto, (Object)inpatPrepay);
        inpatPrepay.setCreateId(dto.getChargeEmpId());
        inpatPrepay.setCreateName(dto.getChargeEmpName());
        String settleNo = UUIDUtils.getPayOrderNo();
        inpatPrepay.setSettleNo(settleNo);
        this.logger.info("\u9884\u4ea4\u91d1\u8ba2\u5355\u652f\u4ed8-->>\u751f\u6210\u7684\u7ed3\u7b97\u5355\u53f7:{}" + settleNo);
        if (PaymentMethodEnum.PAY_ICBC.getValue().equals(dto.getPayWayCode())) {
            if (StrUtil.isEmpty((CharSequence)dto.getAuthCode())) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u5de5\u884c\u626b\u7801\u652f\u4ed8\u65f6\uff0c\u6388\u6743\u7801\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            ICBCPayDto payDto = new ICBCPayDto();
            payDto.setOrderNo(settleNo);
            payDto.setOutUserId(dto.getMedicalRecordNo());
            payDto.setAuthCode(dto.getAuthCode());
            payDto.setSubject("\u4f4f\u9662\u9884\u4ea4\u91d1");
            payDto.setDescribe("\u4f4f\u9662\u9884\u4ea4\u91d1\u7f34\u7eb3");
            Integer amount = prepayAmount.multiply(new BigDecimal(100)).intValue();
            payDto.setAmount(amount);
            ResponseData responseData = this.sdkServiceFeign.microPay(payDto);
            if (!"1".equals(responseData.getCode())) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)responseData.getMsg());
            }
        }
        this.inpatPrepayMapper.insert((Object)inpatPrepay);
        InpatRegist inpatRegist = (InpatRegist)this.inpatRegistMapper.selectById((Serializable)inpatRegId);
        InpatRegist updateRegist = new InpatRegist();
        updateRegist.setId(inpatRegId);
        updateRegist.setTotPrepaymentAmount(inpatRegist.getTotPrepaymentAmount().add(dto.getPrepayAmount()));
        updateRegist.setTotBalanceAmount(inpatRegist.getTotBalanceAmount().add(dto.getPrepayAmount()));
        this.inpatRegistMapper.updateById((Object)updateRegist);
        PrepaySuccessVo successVo = new PrepaySuccessVo();
        successVo.setSetlNo(settleNo);
        return successVo;
    }

    private BigDecimal getBalanceAmount(Integer tenantId, Integer inpatRegId) {
        List feeList = this.inpatFeeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InpatFee.class).eq(tenantId != null, InpatFee::getTenantId, (Object)tenantId)).eq(InpatFee::getStatusCode, (Object)FeeStatusEnum.CHARGED.getValue())).eq(InpatFee::getInpatRegId, (Object)inpatRegId));
        BigDecimal inpatTotalAmount = new BigDecimal(0);
        if (!feeList.isEmpty()) {
            List feeIds = feeList.stream().map(InpatFee::getId).collect(Collectors.toList());
            inpatTotalAmount = feeList.stream().filter(inpatFee -> inpatFee.getChargeItemPrice() != null && inpatFee.getChargeItemNum() != null).map(inpatFee -> inpatFee.getChargeItemPrice().multiply(inpatFee.getChargeItemNum())).reduce(BigDecimal.ZERO, BigDecimal::add);
            List refundFeeList = this.inpatFeeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InpatFee.class).eq(tenantId != null, InpatFee::getTenantId, (Object)tenantId)).eq(InpatFee::getStatusCode, (Object)FeeStatusEnum.REFUNDED.getValue())).in(InpatFee::getBackInpatFeeId, feeIds));
            if (!refundFeeList.isEmpty()) {
                BigDecimal refundTotalAmount = refundFeeList.stream().filter(inpatFee -> inpatFee.getChargeItemPrice() != null && inpatFee.getOrderBackNum() != null).map(inpatFee -> inpatFee.getChargeItemPrice().multiply(inpatFee.getOrderBackNum())).reduce(BigDecimal.ZERO, BigDecimal::add);
                inpatTotalAmount = inpatTotalAmount.subtract(refundTotalAmount);
            }
        }
        List prepayList = this.inpatPrepayMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InpatPrepay.class).eq(tenantId != null, InpatPrepay::getTenantId, (Object)tenantId)).eq(InpatPrepay::getInpatRegId, (Object)inpatRegId));
        BigDecimal prepayTotalAmount = new BigDecimal(0);
        if (!prepayList.isEmpty()) {
            prepayTotalAmount = prepayList.stream().filter(prepay -> prepay.getPrepayAmount() != null).map(InpatPrepay::getPrepayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal prepayBalance = prepayTotalAmount.subtract(inpatTotalAmount);
        return prepayBalance;
    }
}

