/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.inpatient.api.exception.BusinessException;
import com.byh.inpatient.api.hsModel.BaseinfoEntity;
import com.byh.inpatient.api.hsModel.ChronicDiseaseRequest;
import com.byh.inpatient.api.hsModel.HsBaseResponse;
import com.byh.inpatient.api.hsModel.HsPatientInfoDto;
import com.byh.inpatient.api.hsModel.HsPatientInfoResponse;
import com.byh.inpatient.api.hsModel.HsPatientInfoVo;
import com.byh.inpatient.api.hsModel.PatientInfoRequest;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.PatientEntity;
import com.byh.inpatient.api.model.dto.InpatRegistDTO;
import com.byh.inpatient.api.model.dto.PatientInfoDTO;
import com.byh.inpatient.api.model.vo.PatientInfoVO;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.api.util.StringPinYinUtil;
import com.byh.inpatient.api.vo.patient.GetInpatPatientListReqVo;
import com.byh.inpatient.api.vo.patient.GetInpatPatientListResVo;
import com.byh.inpatient.data.repository.InpatRegistMapper;
import com.byh.inpatient.data.repository.PatientMapper;
import com.byh.inpatient.web.feign.HsServiceFeign;
import com.byh.inpatient.web.mvc.utils.CommonRequest;
import com.byh.inpatient.web.mvc.utils.HyposensitizationUtil;
import com.byh.inpatient.web.service.IPatientService;
import com.ebaiyihui.framework.utils.DateUtils;
import com.ebaiyihui.framework.utils.IdCardUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PatientServiceImpl
implements IPatientService {
    private static final Logger log = LoggerFactory.getLogger(PatientServiceImpl.class);
    @Autowired
    PatientMapper patientMapper;
    @Autowired
    CommonRequest commonRequest;
    @Autowired
    HsServiceFeign hsServiceFeign;
    @Autowired
    InpatRegistMapper inpatRegistMapper;

    public PatientEntity checkPatient(InpatRegistDTO param) {
        PatientEntity patientEntity = this.patientMapper.queryPatientByCardNoAndTenantId(param.getCardNo(), this.commonRequest.getTenant());
        if (ObjectUtil.isNotNull((Object)patientEntity)) {
            Assert.isTrue((boolean)patientEntity.getName().equals(param.getPatientName()), (String)StrUtil.format((CharSequence)"\u60a3\u8005\u6863\u6848\u540d\u79f0: {}\uff0c\u4e0e\u767b\u8bb0\u540d\u79f0: {}\u4e0d\u4e00\u81f4", (Object[])new Object[]{patientEntity.getName(), param.getPatientName()}));
            return patientEntity;
        }
        PatientEntity entity = new PatientEntity();
        entity.setName(param.getPatientName());
        entity.setPhone(param.getContactTelNo());
        entity.setSex(param.getSex());
        entity.setCardType(String.valueOf(param.getCardTypeCode()));
        entity.setCardNo(param.getCardNo());
        entity.setAge(Integer.valueOf(IdCardUtil.getAgeByIdCard((String)param.getCardNo())));
        entity.setRemark(param.getRemark());
        entity.setBirthday(param.getBirthDate());
        entity.setCardSn("");
        entity.setSocialCardNo("");
        entity.setSocialCardInfo("");
        entity.setChronicDiseaseCode("");
        entity.setChronicDisease("");
        entity.setSource("");
        entity.setMedicalRecordNo(this.generateMedicalRecordNo(this.commonRequest.getTenant(), this.patientMapper.queryMaxMedicalNo(this.commonRequest.getTenant())));
        entity.setNamePinyin(StringPinYinUtil.toFirstChar((String)entity.getName()));
        this.patientMapper.insert(entity);
        return entity;
    }

    private String generateMedicalRecordNo(Integer tenantId, String no) {
        Integer endNo = Objects.isNull(no) ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(no));
        String currentDate = DateUtils.getCurrentDate((String)"yyMMdd");
        Integer suffix = tenantId + 1000000 + endNo;
        return currentDate + suffix;
    }

    public Page<PatientInfoVO> queryPatient(PatientInfoDTO patientInfoDTO) {
        Page page = new Page((long)patientInfoDTO.getCurrent().intValue(), (long)patientInfoDTO.getSize().intValue());
        this.patientMapper.selectPatientInfoList(page, patientInfoDTO);
        return page;
    }

    public PatientEntity queryPatientByMedicalRecordNo(String medicalRecordNo) {
        Assert.hasText((String)medicalRecordNo, (String)"\u75c5\u5386\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        return this.patientMapper.queryPatientByMedicalRecordNo(medicalRecordNo);
    }

    public ResponseData<Page<GetInpatPatientListResVo>> getInpatPatientList(GetInpatPatientListReqVo param) {
        Page page = new Page((long)param.getPageNum(), (long)param.getPageSize());
        this.patientMapper.getInpatPatientList(page, param);
        List records = page.getRecords();
        for (GetInpatPatientListResVo patient : records) {
            Integer realAge = this.getAge(patient.getCardNo(), patient.getBirthday(), patient.getAge());
            patient.setAge(realAge);
            String patientName = HyposensitizationUtil.hyposensitizationForName((String)patient.getName());
            String phone = HyposensitizationUtil.hyposensitizationForPhone((String)patient.getPhone());
            String cardNo = HyposensitizationUtil.hyposensitizationForCardNo((String)patient.getCardNo());
            patient.setName(patientName);
            patient.setPhone(phone);
            patient.setCardNo(cardNo);
        }
        return ResponseData.success((Object)page);
    }

    public HsPatientInfoVo queryPatientInfoByEcCode(HsPatientInfoDto hsPatientInfoDto) {
        log.info("\u652f\u4ed8\u65f6\u83b7\u53d6\u53c2\u4fdd\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)hsPatientInfoDto));
        InpatRegist inpatRegist = this.inpatRegistMapper.selectByInpatNo(hsPatientInfoDto.getInpatNo());
        PatientEntity patientEntity = this.patientMapper.queryPatientByCardNoAndTenantId(inpatRegist.getCardNo(), this.commonRequest.getTenant());
        if ("01".equals(hsPatientInfoDto.getMdtrtCertType())) {
            if (Objects.isNull(patientEntity.getCardNo()) || patientEntity.getCardNo().isEmpty()) {
                throw new BusinessException("\u8bf7\u5148\u5b8c\u5584\u60a3\u8005\u8eab\u4efd\u4fe1\u606f");
            }
            if (Objects.isNull(hsPatientInfoDto.getCardNo())) {
                hsPatientInfoDto.setCardNo(patientEntity.getCardNo());
                hsPatientInfoDto.setCardType(patientEntity.getCardType());
                hsPatientInfoDto.setName(patientEntity.getName());
                hsPatientInfoDto.setMdtrtCertType("02");
                hsPatientInfoDto.setMdtrtCertNo(patientEntity.getCardNo());
            }
            if (!patientEntity.getCardNo().equalsIgnoreCase(hsPatientInfoDto.getCardNo()) || !patientEntity.getName().equals(hsPatientInfoDto.getName())) {
                throw new BusinessException("\u8eab\u4efd\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u626b\u7801\uff01");
            }
        }
        PatientInfoRequest patientInfoRequest = new PatientInfoRequest();
        patientInfoRequest.setMdtrt_cert_type(hsPatientInfoDto.getMdtrtCertType());
        patientInfoRequest.setMdtrt_cert_no(hsPatientInfoDto.getMdtrtCertNo());
        patientInfoRequest.setPsn_name(hsPatientInfoDto.getName());
        patientInfoRequest.setCertno(hsPatientInfoDto.getCardNo());
        patientInfoRequest.setTenantId(this.commonRequest.getTenant());
        patientInfoRequest.setCard_sn(hsPatientInfoDto.getCardSn());
        patientInfoRequest.setPsn_cert_type(hsPatientInfoDto.getCardType());
        patientInfoRequest.setOpter_type("1");
        patientInfoRequest.setOpter(String.valueOf(this.commonRequest.getUserId()));
        patientInfoRequest.setOpter_name(this.commonRequest.getUserName());
        patientInfoRequest.setInsuplc_admdvs(hsPatientInfoDto.getInsuplcAdmdvs());
        ResponseData hsBaseResponseResponseData = this.hsServiceFeign.hsPatientInfo(patientInfoRequest);
        if (hsBaseResponseResponseData.isError()) {
            throw new BusinessException(((HsBaseResponse)hsBaseResponseResponseData.getData()).getErr_msg());
        }
        HsPatientInfoVo hsPatientInfoVo = new HsPatientInfoVo();
        BaseinfoEntity baseinfo = ((HsPatientInfoResponse)((HsBaseResponse)hsBaseResponseResponseData.getData()).getOutput()).getBaseinfo();
        if (!patientEntity.getCardNo().equalsIgnoreCase(baseinfo.getCertno()) || !patientEntity.getName().equals(baseinfo.getPsn_name())) {
            throw new BusinessException("\u8eab\u4efd\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u626b\u7801\uff01");
        }
        hsPatientInfoVo.setPsnNo(baseinfo.getPsn_no());
        hsPatientInfoVo.setPsnName(baseinfo.getPsn_name());
        hsPatientInfoVo.setAge(baseinfo.getAge());
        hsPatientInfoVo.setGend(baseinfo.getGend());
        hsPatientInfoVo.setBrdy(baseinfo.getBrdy());
        hsPatientInfoVo.setCertno(baseinfo.getCertno());
        hsPatientInfoVo.setInsuinfo(((HsPatientInfoResponse)((HsBaseResponse)hsBaseResponseResponseData.getData()).getOutput()).getInsuinfo());
        patientEntity.setInsuinfo(JSONObject.toJSONString((Object)((HsPatientInfoResponse)((HsBaseResponse)hsBaseResponseResponseData.getData()).getOutput()).getInsuinfo()));
        patientEntity.setPsnNo(baseinfo.getPsn_no());
        ChronicDiseaseRequest chronicDiseaseRequest = new ChronicDiseaseRequest();
        BeanUtils.copyProperties((Object)patientInfoRequest, (Object)chronicDiseaseRequest);
        chronicDiseaseRequest.setPsn_no(hsPatientInfoVo.getPsnNo());
        chronicDiseaseRequest.setInsuplc_admdvs(hsPatientInfoDto.getInsuplcAdmdvs());
        chronicDiseaseRequest.setCertno(hsPatientInfoVo.getCertno());
        chronicDiseaseRequest.setMdtrt_cert_no(hsPatientInfoVo.getCertno());
        chronicDiseaseRequest.setCert_type("02");
        ResponseData medicalChronicResponse = this.hsServiceFeign.chronicDisease(chronicDiseaseRequest);
        if (!Objects.isNull(medicalChronicResponse) && medicalChronicResponse.isSuccess() && !Objects.isNull(((HsBaseResponse)medicalChronicResponse.getData()).getOutput())) {
            if (!((List)((HsBaseResponse)medicalChronicResponse.getData()).getOutput()).isEmpty()) {
                JSONObject feedetail = new JSONObject();
                feedetail.put("feedetail", ((HsBaseResponse)medicalChronicResponse.getData()).getOutput());
                JSONArray jsonArray = new JSONArray();
                jsonArray.add((Object)feedetail);
                hsPatientInfoVo.setMedicalChronicList((List)jsonArray);
            }
            List jsonList = (List)JSON.parseObject((String)JSONObject.toJSONString((Object)((HsBaseResponse)medicalChronicResponse.getData()).getOutput()), List.class);
            String chronicDiseaseCode = "";
            String chronicDisease = "";
            for (Object objson : jsonList) {
                JSONObject jsonObject = JSON.parseObject((String)JSONObject.toJSONString(objson));
                chronicDiseaseCode = chronicDiseaseCode + "," + jsonObject.get((Object)"opsp_dise_code").toString();
                chronicDisease = chronicDisease + "," + jsonObject.get((Object)"opsp_dise_name").toString();
            }
            patientEntity.setChronicDiseaseCode(chronicDiseaseCode);
            patientEntity.setChronicDisease(chronicDisease);
        }
        return hsPatientInfoVo;
    }

    private Integer getAge(String cardNo, String birthDay, Integer age) {
        String birthDate = "";
        birthDate = StrUtil.isEmpty((CharSequence)birthDay) ? this.getBirthDay(cardNo) : birthDay;
        if (StrUtil.isNotEmpty((CharSequence)birthDate)) {
            Integer realAge;
            LocalDate birthDateLocal = LocalDate.parse(birthDate, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            LocalDate currentDate = LocalDate.now();
            if (currentDate.isBefore(birthDateLocal.plusYears((realAge = Integer.valueOf(currentDate.getYear() - birthDateLocal.getYear())).intValue()))) {
                Integer n = realAge;
                Integer n2 = realAge = Integer.valueOf(realAge - 1);
            }
            return realAge;
        }
        return age;
    }

    private String getBirthDay(String cardNo) {
        if (cardNo.length() != 18) {
            return null;
        }
        String birthDateString = cardNo.substring(6, 14);
        LocalDate birthDate = LocalDate.parse(birthDateString, DateTimeFormatter.BASIC_ISO_DATE);
        return birthDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }
}

