/*
 * Decompiled with CFR 0.152.
 */
package com.byh.api;

import com.byh.enums.AccountTypeEnum;
import com.byh.exception.BusinessException;
import com.byh.pojo.vo.req.AccountPageReqVO;
import com.byh.pojo.vo.req.SaveAccountReqVO;
import com.byh.pojo.vo.req.UpdateAccountReqVO;
import com.byh.pojo.vo.resp.AccountRespVO;
import com.byh.service.AccountService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d26\u6237\u76f8\u5173\u63a5\u53e3"})
@RequestMapping(value={"/manage/account"})
public class AccountController {
    private static final Logger log = LoggerFactory.getLogger(AccountController.class);
    @Autowired
    private AccountService accountService;

    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"/save"})
    public BaseResponse save(@RequestBody @Validated SaveAccountReqVO saveAccountReqVO) {
        Integer type = saveAccountReqVO.getType();
        if (!AccountTypeEnum.GENERAL_ACCOUNT.getValue().equals(type) && !AccountTypeEnum.ISV_ACCOUNT.getValue().equals(type)) {
            throw new BusinessException("\u7528\u6237\u7c7b\u578b\u9519\u8bef\uff01");
        }
        this.accountService.save(saveAccountReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"/deleteById"})
    public BaseResponse deleteById(@RequestParam Long id) {
        return BaseResponse.success();
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"/update"})
    public BaseResponse update(@RequestBody @Validated UpdateAccountReqVO updateAccountReqVO) {
        Integer type = updateAccountReqVO.getType();
        if (!AccountTypeEnum.GENERAL_ACCOUNT.getValue().equals(type) && !AccountTypeEnum.ISV_ACCOUNT.getValue().equals(type)) {
            throw new BusinessException("\u7528\u6237\u7c7b\u578b\u9519\u8bef\uff01");
        }
        this.accountService.update(updateAccountReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/getById"})
    public BaseResponse getById(@RequestParam Long id) {
        AccountRespVO accountRespVO = this.accountService.getById(id);
        return BaseResponse.success((Object)accountRespVO);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/getPage"})
    public BaseResponse<PageResult> getPage(@RequestBody @Validated AccountPageReqVO accountPageReqVO) {
        PageResult pageRet = this.accountService.getPage(accountPageReqVO);
        return BaseResponse.success((Object)pageRet);
    }
}

