/*
 * Decompiled with CFR 0.152.
 */
package com.byh.api;

import com.byh.pojo.vo.req.DicChannelPageReqVO;
import com.byh.pojo.vo.req.SaveDicChannelReqVO;
import com.byh.pojo.vo.req.UpdateDicChannelReqVO;
import com.byh.pojo.vo.req.UpdateMerchantOpenedChannelReqVO;
import com.byh.service.DicChannelService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6e20\u9053\u7ba1\u7406"})
@RequestMapping(value={"/manage/dic/channel"})
public class DicChannelController {
    private static final Logger log = LoggerFactory.getLogger(DicChannelController.class);
    @Autowired
    private DicChannelService dicChannelService;

    @ApiOperation(value="\u4fdd\u5b58\u6e20\u9053\u4fe1\u606f")
    @PostMapping(value={"/save"})
    public BaseResponse save(@RequestBody @Validated SaveDicChannelReqVO saveDicChannelReqVO) {
        this.dicChannelService.save(saveDicChannelReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u5220\u9664\u6e20\u9053\u4fe1\u606f")
    @PostMapping(value={"/deleteById"})
    public BaseResponse deleteById(@RequestParam Long id) {
        this.dicChannelService.deleteById((Serializable)id);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u4fee\u6539\u6e20\u9053\u4fe1\u606f")
    @PostMapping(value={"/update"})
    public BaseResponse update(@RequestBody @Validated UpdateDicChannelReqVO updateDicChannelReqVO) {
        this.dicChannelService.update(updateDicChannelReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/getPage"})
    public BaseResponse<PageResult> getPage(@RequestBody @Validated DicChannelPageReqVO dicChannelPageReqVO) {
        PageResult pageRet = this.dicChannelService.getPage(dicChannelPageReqVO);
        return BaseResponse.success((Object)pageRet);
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u6237\u5f00\u901a\u7684\u6e20\u9053")
    @GetMapping(value={"/findMerchantOpenedChannel"})
    public BaseResponse findMerchantOpenedChannel(@RequestParam Long merchantId) {
        List merchantOpenedChannelRespVOList = this.dicChannelService.findMerchantOpenedChannel(merchantId);
        return BaseResponse.success((Object)merchantOpenedChannelRespVOList);
    }

    @ApiOperation(value="\u66f4\u65b0\u5546\u6237\u5f00\u901a\u7684\u6e20\u9053")
    @PostMapping(value={"/updateMerchantOpenedChannel"})
    public BaseResponse updateMerchantOpenedChannel(@RequestBody @Validated UpdateMerchantOpenedChannelReqVO updateMerchantOpenedChannelReqVO) {
        this.dicChannelService.updateMerchantOpenedChannel(updateMerchantOpenedChannelReqVO);
        return BaseResponse.success();
    }
}

