/*
 * Decompiled with CFR 0.152.
 */
package com.byh.api;

import com.byh.exception.BusinessException;
import com.byh.pojo.vo.req.LoginReqVO;
import com.byh.pojo.vo.resp.VerificationRespVO;
import com.byh.service.AccountService;
import com.byh.util.RSAEncrypt;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ning.http.util.Base64;
import io.swagger.annotations.Api;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7528\u6237\u767b\u5f55\u76f8\u5173\u63a5\u53e3"})
@RequestMapping(value={"/account"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private AccountService accountService;

    @PostMapping(value={"/login"})
    public BaseResponse<Map<String, Object>> login(@RequestBody @Validated LoginReqVO loginReqVO) {
        String encrypt = loginReqVO.getEncrypt();
        String verificationCode = loginReqVO.getVerificationCode();
        String loginName = loginReqVO.getLoginName();
        String password = loginReqVO.getPassword();
        String decrypt = null;
        try {
            decrypt = RSAEncrypt.decrypt((String)encrypt);
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw new BusinessException("encrypt\u89e3\u5bc6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff01");
        }
        if (!decrypt.equals(verificationCode)) {
            throw new BusinessException("\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        Map ret = this.accountService.login(loginName, password);
        return BaseResponse.success((Object)ret);
    }

    @PostMapping(value={"/logout"})
    public BaseResponse logout(@RequestParam Long accountId) {
        this.accountService.logout(accountId);
        return BaseResponse.success();
    }

    @GetMapping(value={"/getImage"})
    public BaseResponse<VerificationRespVO> getImage() throws Exception {
        int width = 55;
        int height = 25;
        String verificationCode = RandomStringUtils.randomNumeric((int)4);
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics graphics = image.getGraphics();
        graphics.setColor(this.getRandColor(200, 250));
        graphics.fillRect(0, 0, width, height);
        graphics.setFont(new Font("\u5b8b\u4f53", 1, 18));
        Random random = new Random();
        graphics.setColor(new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110)));
        graphics.drawString(verificationCode, 5, 20);
        graphics.dispose();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", stream);
        String base64Image = Base64.encode((byte[])stream.toByteArray());
        String encrypt = RSAEncrypt.encrypt((String)verificationCode);
        VerificationRespVO verificationRespVO = new VerificationRespVO();
        verificationRespVO.setBase64Image(base64Image);
        verificationRespVO.setEncrypt(encrypt);
        return BaseResponse.success((Object)verificationRespVO);
    }

    private Color getRandColor(int fc, int bc) {
        Random random = new Random();
        fc = fc > 255 ? 255 : fc;
        bc = bc > 255 ? 255 : bc;
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }
}

