/*
 * Decompiled with CFR 0.152.
 */
package com.byh.api;

import com.byh.exception.AuthException;
import com.byh.msg.MtMsgInfo;
import com.byh.pojo.entity.Merchant;
import com.byh.pojo.entity.MtLocalOrder;
import com.byh.pojo.entity.MtLocalStore;
import com.byh.pojo.entity.OrderExceptionMsg;
import com.byh.pojo.entity.OrderStatusMsg;
import com.byh.pojo.entity.SenderAddressChannel;
import com.byh.service.MerchantService;
import com.byh.service.MtLocalOrderService;
import com.byh.service.MtLocalStoreService;
import com.byh.service.OrderExceptionMsgService;
import com.byh.service.OrderStatusMsgService;
import com.byh.service.SenderAddressChannelService;
import com.byh.util.UUIDUtil;
import com.byh.util.mt.Config;
import com.byh.util.mt.util.SignUtil;
import com.byh.util.mt.vo.req.CallbackReqVO;
import com.byh.util.mt.vo.req.OrderExceptionCallbackMsg;
import com.byh.util.mt.vo.req.OrderStatusCallbackMsg;
import com.byh.util.mt.vo.req.ShopStatusCallbackMsg;
import com.google.gson.Gson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5904\u7406\u7f8e\u56e2\u914d\u9001\u7684\u56de\u8c03\u63a5\u53e3"})
@RequestMapping(value={"/api"})
public class MTCallbackController {
    private static final Logger log = LoggerFactory.getLogger(MTCallbackController.class);
    @Value(value="${environment}")
    private String environment;
    @Autowired
    private MtLocalStoreService mtLocalStoreService;
    @Autowired
    private OrderStatusMsgService orderStatusMsgService;
    @Autowired
    private OrderExceptionMsgService orderExceptionMsgService;
    @Autowired
    private MtLocalOrderService mtLocalOrderService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private AmqpTemplate rabbitTemplate;
    @Autowired
    private SenderAddressChannelService senderAddressChannelService;

    @ApiOperation(value="\u7f8e\u56e2\u56de\u8c03\u65b9\u6cd5\uff08\u5305\u542b\u95e8\u5e97\u72b6\u6001\u53d8\u66f4\u56de\u8c03\uff0c\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u56de\u8c03\uff0c\u8ba2\u5355\u5f02\u5e38\u4fe1\u606f\u56de\u8c03\uff09")
    @PostMapping(value={"/callback/meituan"})
    public Map<String, Object> mtCallback(CallbackReqVO callbackReqVO) {
        log.info(callbackReqVO.toString());
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("timestamp", callbackReqVO.getTimestamp().toString());
        map.put("sign", callbackReqVO.getSign());
        map.put("developerId", callbackReqVO.getDeveloperId().toString());
        map.put("businessId", callbackReqVO.getBusinessId().toString());
        map.put("opBizCode", callbackReqVO.getOpBizCode());
        map.put("msgId", callbackReqVO.getMsgId());
        map.put("msgType", callbackReqVO.getMsgType().toString());
        map.put("message", callbackReqVO.getMessage());
        String sign = SignUtil.getSign((String)Config.SIGN_KEY, map);
        if (!sign.equals(callbackReqVO.getSign())) {
            throw new AuthException("\u7f8e\u56e2\u56de\u8c03\u7b7e\u540d\u6821\u9a8c\u4e0d\u901a\u8fc7\uff01");
        }
        Integer msgType = callbackReqVO.getMsgType();
        String message = callbackReqVO.getMessage();
        Long timestamp = callbackReqVO.getTimestamp();
        Gson gson = new Gson();
        if (msgType.equals(19103)) {
            ShopStatusCallbackMsg shopStatusCallbackMsg = (ShopStatusCallbackMsg)gson.fromJson(message, ShopStatusCallbackMsg.class);
            String shopId = shopStatusCallbackMsg.getShop_id();
            String rejectMessage = shopStatusCallbackMsg.getReject_message();
            Integer status = shopStatusCallbackMsg.getStatus();
            MtLocalStore mtLocalStore = this.mtLocalStoreService.getByShopId(shopId);
            mtLocalStore.setRejectMessage(rejectMessage);
            mtLocalStore.setShopStatus(status);
            this.mtLocalStoreService.updateByPrimaryKeySelective((Object)mtLocalStore);
            SenderAddressChannel mtSenderAddressChannel = new SenderAddressChannel();
            mtSenderAddressChannel.setViewId(UUIDUtil.getUUID());
            mtSenderAddressChannel.setStatus(Integer.valueOf(1));
            mtSenderAddressChannel.setChannelName("\u7f8e\u56e2\u914d\u9001");
            mtSenderAddressChannel.setSenderCommonId(mtLocalStore.getSenderCommonId());
            mtSenderAddressChannel.setEnabled(Integer.valueOf(1));
            this.senderAddressChannelService.insert((Object)mtSenderAddressChannel);
        } else if (msgType.equals(19101)) {
            OrderStatusCallbackMsg orderStatusCallbackMsg = (OrderStatusCallbackMsg)gson.fromJson(message, OrderStatusCallbackMsg.class);
            String orderId = orderStatusCallbackMsg.getOrder_id();
            MtLocalOrder mtLocalOrder = this.mtLocalOrderService.getByOrderId(orderId);
            Long merchantId = mtLocalOrder.getMerchantId();
            Merchant merchant = (Merchant)this.merchantService.selectByPrimaryKey((Serializable)merchantId);
            if (null != merchant) {
                MtMsgInfo mtMsgInfo = this.getMtMsgInfo(message, merchantId, merchant);
                mtMsgInfo.setMsgType(Integer.valueOf(10));
                this.rabbitTemplate.convertAndSend("mt_order_msg_exchange", "mt.order.msg.#", (Object)mtMsgInfo);
            }
            if (mtLocalOrder != null) {
                mtLocalOrder.setOrderStatus(orderStatusCallbackMsg.getStatus());
                this.mtLocalOrderService.updateByPrimaryKeySelective((Object)mtLocalOrder);
            }
            OrderStatusMsg orderStatusMsg = new OrderStatusMsg();
            orderStatusMsg.setViewId(UUIDUtil.getUUID());
            orderStatusMsg.setStatus(Integer.valueOf(1));
            orderStatusMsg.setDeliveryId(orderStatusCallbackMsg.getDelivery_id());
            orderStatusMsg.setMtPeisongId(orderStatusCallbackMsg.getMt_peisong_id());
            orderStatusMsg.setOrderId(orderId);
            orderStatusMsg.setOrderStatus(orderStatusCallbackMsg.getStatus());
            orderStatusMsg.setCourierName(orderStatusCallbackMsg.getCourier_name());
            orderStatusMsg.setCourierPhone(orderStatusCallbackMsg.getCourier_phone());
            orderStatusMsg.setCancelReasonId(orderStatusCallbackMsg.getCancel_reason_id());
            orderStatusMsg.setCancelReason(orderStatusCallbackMsg.getCancel_reason());
            orderStatusMsg.setTimestamp(timestamp);
            this.orderStatusMsgService.insert((Object)orderStatusMsg);
        } else if (msgType.equals(19102)) {
            OrderExceptionCallbackMsg orderExceptionCallbackMsg = (OrderExceptionCallbackMsg)gson.fromJson(message, OrderExceptionCallbackMsg.class);
            String orderId = orderExceptionCallbackMsg.getOrder_id();
            MtLocalOrder mtLocalOrder = this.mtLocalOrderService.getByOrderId(orderId);
            Long merchantId = mtLocalOrder.getMerchantId();
            Merchant merchant = (Merchant)this.merchantService.selectByPrimaryKey((Serializable)merchantId);
            if (null != merchant) {
                MtMsgInfo mtMsgInfo = this.getMtMsgInfo(message, merchantId, merchant);
                mtMsgInfo.setMsgType(Integer.valueOf(20));
                this.rabbitTemplate.convertAndSend("mt_order_msg_exchange", "mt.order.msg.#", (Object)mtMsgInfo);
            }
            OrderExceptionMsg orderExceptionMsg = new OrderExceptionMsg();
            orderExceptionMsg.setViewId(UUIDUtil.getUUID());
            orderExceptionMsg.setStatus(Integer.valueOf(1));
            orderExceptionMsg.setDeliveryId(orderExceptionCallbackMsg.getDelivery_id());
            orderExceptionMsg.setMtPeisongId(orderExceptionCallbackMsg.getMt_peisong_id());
            orderExceptionMsg.setOrderId(orderExceptionCallbackMsg.getOrder_id());
            orderExceptionMsg.setExceptionId(orderExceptionCallbackMsg.getException_id());
            orderExceptionMsg.setExceptionCode(orderExceptionCallbackMsg.getException_code());
            orderExceptionMsg.setExceptionDescr(orderExceptionCallbackMsg.getException_descr());
            orderExceptionMsg.setExceptionTime(orderExceptionCallbackMsg.getException_time());
            orderExceptionMsg.setCourierName(orderExceptionCallbackMsg.getCourier_name());
            orderExceptionMsg.setCourierPhone(orderExceptionCallbackMsg.getCourier_phone());
            orderExceptionMsg.setTimestamp(timestamp);
            this.orderExceptionMsgService.insert((Object)orderExceptionMsg);
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(16);
        ret.put("code", 0);
        ret.put("message", "");
        ret.put("data", "");
        return ret;
    }

    private MtMsgInfo getMtMsgInfo(String message, Long merchantId, Merchant merchant) {
        String appId = null;
        if ("test".equals(this.environment)) {
            appId = merchant.getTestAppId();
        } else if ("pro".equals(this.environment)) {
            appId = merchant.getTestAppId();
        }
        HashMap<String, String> reqMap = new HashMap<String, String>(16);
        long timestamp = System.currentTimeMillis() / 1000L;
        reqMap.put("timestamp", String.valueOf(timestamp));
        reqMap.put("appId", appId);
        MtMsgInfo mtMsgInfo = new MtMsgInfo();
        mtMsgInfo.setMerchantId(merchantId);
        mtMsgInfo.setAppId(appId);
        mtMsgInfo.setTimestamp(Long.valueOf(timestamp));
        mtMsgInfo.setMessage(message);
        return mtMsgInfo;
    }
}

