/*
 * Decompiled with CFR 0.152.
 */
package com.byh.api;

import com.byh.enums.AccountTypeEnum;
import com.byh.exception.BusinessException;
import com.byh.pojo.entity.Account;
import com.byh.pojo.vo.req.MerchantPageReqVO;
import com.byh.pojo.vo.req.SaveMerchantReqVO;
import com.byh.pojo.vo.req.UpdateMerchantReqVO;
import com.byh.pojo.vo.resp.MerchantRespVO;
import com.byh.service.AccountService;
import com.byh.service.MerchantService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5546\u6237\u76f8\u5173\u63a5\u53e3"})
@RequestMapping(value={"/manage/merchant"})
public class MerchantController {
    private static final Logger log = LoggerFactory.getLogger(MerchantController.class);
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private AccountService accountService;

    @ApiOperation(value="\u4fdd\u5b58\u5546\u6237\u4fe1\u606f")
    @PostMapping(value={"/save"})
    public BaseResponse save(@RequestBody @Validated SaveMerchantReqVO saveMerchantReqVO) {
        Long count;
        Long accountId = saveMerchantReqVO.getAccountId();
        Account account = (Account)this.accountService.selectByPrimaryKey((Serializable)accountId);
        if (account == null) {
            throw new BusinessException("accountId\uff1a" + accountId + " \u5bf9\u5e94\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        if (AccountTypeEnum.GENERAL_ACCOUNT.getValue().equals(account.getType()) && (count = this.merchantService.getCountBYAccountId(accountId)) > 0L) {
            throw new BusinessException("\u666e\u901a\u7528\u6237\u53ea\u80fd\u521b\u5efa\u4e00\u4e2a\u5546\u6237\uff01");
        }
        this.merchantService.save(saveMerchantReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u5220\u9664\u5546\u6237\u4fe1\u606f")
    @PostMapping(value={"/deleteById"})
    public BaseResponse deleteById(@RequestParam Long id) {
        return BaseResponse.success();
    }

    @ApiOperation(value="\u4fee\u6539\u5546\u6237\u4fe1\u606f")
    @PostMapping(value={"/update"})
    public BaseResponse update(@RequestBody @Validated UpdateMerchantReqVO updateMerchantReqVO) {
        Long accountId = updateMerchantReqVO.getAccountId();
        Account account = (Account)this.accountService.selectByPrimaryKey((Serializable)accountId);
        if (account == null) {
            throw new BusinessException("accountId\uff1a" + accountId + " \u5bf9\u5e94\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        this.merchantService.update(updateMerchantReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u6237\u4fe1\u606f")
    @GetMapping(value={"/getById"})
    public BaseResponse getById(@RequestParam Long id) {
        MerchantRespVO merchantRespVO = this.merchantService.getById(id);
        return BaseResponse.success((Object)merchantRespVO);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/getPage"})
    public BaseResponse<PageResult> getPage(@RequestBody @Validated MerchantPageReqVO merchantPageReqVO) {
        PageResult pageResult = this.merchantService.getPage(merchantPageReqVO);
        return BaseResponse.success((Object)pageResult);
    }

    @ApiOperation(value="\u751f\u6210\u6d4b\u8bd5\u73af\u5883\u5f00\u53d1\u914d\u7f6e\u4fe1\u606f")
    @PostMapping(value={"/generateTestDevelopmentConfig"})
    public BaseResponse generateTestDevelopmentConfig(@RequestParam Long id) {
        if (id == null) {
            throw new BusinessException("id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.merchantService.generateTestDevelopmentConfig(id);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u751f\u6210\u6b63\u5f0f\u73af\u5883\u5f00\u53d1\u914d\u7f6e\u4fe1\u606f")
    @PostMapping(value={"/generateFormalDevelopmentConfig"})
    public BaseResponse generateFormalDevelopmentConfig(@RequestParam Long id) {
        if (id == null) {
            throw new BusinessException("id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.merchantService.generateFormalDevelopmentConfig(id);
        return BaseResponse.success();
    }
}

