/*
 * Decompiled with CFR 0.152.
 */
package com.byh.api;

import com.byh.exception.BusinessException;
import com.byh.pojo.entity.Merchant;
import com.byh.pojo.entity.MtLocalStore;
import com.byh.pojo.entity.SenderCommon;
import com.byh.pojo.entity.SfLocalStore;
import com.byh.pojo.vo.req.FindAllMerchantAddressPageReqVO;
import com.byh.pojo.vo.req.GetMerchantAddressDetailReqVO;
import com.byh.pojo.vo.req.JdReviewPassedReqVO;
import com.byh.pojo.vo.req.JdReviewRejectedReqVO;
import com.byh.pojo.vo.req.SaveMtLocalStoreReqVO;
import com.byh.pojo.vo.req.SaveSenderAddressReqVO;
import com.byh.pojo.vo.req.SaveSenderCommonReqVO;
import com.byh.pojo.vo.req.SfLocalReviewPassedReqVO;
import com.byh.pojo.vo.req.SfLocalReviewRejectedReqVO;
import com.byh.pojo.vo.req.SfMedicalReviewPassedReqVO;
import com.byh.pojo.vo.req.SfMedicalReviewRejectedReqVO;
import com.byh.pojo.vo.req.UpdateMtLocalStoreReqVO;
import com.byh.pojo.vo.req.UpdateSenderAddressReqVO;
import com.byh.pojo.vo.req.UpdateSenderCommonReqVO;
import com.byh.pojo.vo.req.UpdateSfLocalStoreReqVO;
import com.byh.service.MerchantService;
import com.byh.service.MtLocalStoreService;
import com.byh.service.SenderCommonService;
import com.byh.service.SfLocalStoreService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u53d1\u4ef6\u4eba\u5730\u5740\u76f8\u5173\u63a5\u53e3"})
@RequestMapping(value={"/manage/sender/address"})
public class SenderAddressController {
    private static final Logger log = LoggerFactory.getLogger(SenderAddressController.class);
    @Autowired
    private SenderCommonService senderCommonService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private MtLocalStoreService mtLocalStoreService;
    @Autowired
    private SfLocalStoreService sfLocalStoreService;

    @ApiOperation(value="\u4fdd\u5b58\u5546\u6237\u5730\u5740\u4fe1\u606f")
    @PostMapping(value={"/save"})
    public BaseResponse save(@RequestBody @Validated SaveSenderAddressReqVO saveSenderAddressReqVO) {
        SaveMtLocalStoreReqVO mtLocalStoreReqVO;
        Long mtLocalStoreMerchantId;
        SaveSenderCommonReqVO senderCommonReqVO = saveSenderAddressReqVO.getSaveSenderCommonReqVO();
        Long cMerchantId = senderCommonReqVO.getMerchantId();
        if (!cMerchantId.equals(mtLocalStoreMerchantId = (mtLocalStoreReqVO = saveSenderAddressReqVO.getSaveMtLocalStoreReqVO()).getMerchantId())) {
            throw new BusinessException("MerchantId\u4e0d\u4e00\u81f4\uff0c\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7\uff01");
        }
        Merchant merchant = (Merchant)this.merchantService.selectByPrimaryKey((Serializable)cMerchantId);
        if (merchant == null) {
            throw new BusinessException("\u5546\u6237\u4e0d\u5b58\u5728\uff0c\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7\uff01");
        }
        this.senderCommonService.saveSenderAddress(saveSenderAddressReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u66f4\u65b0\u5546\u6237\u5730\u5740\u4fe1\u606f")
    @PostMapping(value={"/update"})
    public BaseResponse update(@RequestBody @Validated UpdateSenderAddressReqVO updateSenderAddressReqVO) {
        UpdateMtLocalStoreReqVO updateMtLocalStoreReqVO;
        Long mtLocalStoreMerchantId;
        UpdateSenderCommonReqVO updateSenderCommonReqVO = updateSenderAddressReqVO.getUpdateSenderCommonReqVO();
        Long cMerchantId = updateSenderCommonReqVO.getMerchantId();
        if (!cMerchantId.equals(mtLocalStoreMerchantId = (updateMtLocalStoreReqVO = updateSenderAddressReqVO.getUpdateMtLocalStoreReqVO()).getMerchantId())) {
            throw new BusinessException("MerchantId\u4e0d\u4e00\u81f4\uff0c\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7\uff01");
        }
        Merchant merchant = (Merchant)this.merchantService.selectByPrimaryKey((Serializable)cMerchantId);
        if (merchant == null) {
            throw new BusinessException("\u5546\u6237\u4e0d\u5b58\u5728\uff0c\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7\uff01");
        }
        this.senderCommonService.updateSenderAddress(updateSenderAddressReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u6237\u5730\u5740\u4fe1\u606f")
    @GetMapping(value={"/findMerchantAddressList"})
    public BaseResponse<List<Map<String, Object>>> findMerchantAddressList(@RequestParam Long merchantId) {
        List mapList = this.senderCommonService.findMerchantAddressList(merchantId);
        return BaseResponse.success((Object)mapList);
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u6237\u5730\u5740\u8be6\u60c5")
    @PostMapping(value={"/getMerchantAddressDetail"})
    public BaseResponse<Map<String, Object>> getMerchantAddressDetail(@RequestBody @Validated GetMerchantAddressDetailReqVO getMerchantAddressDetailReqVO) {
        Map merchantAddressDetailMap = this.senderCommonService.getMerchantAddressDetail(getMerchantAddressDetailReqVO);
        return BaseResponse.success((Object)merchantAddressDetailMap);
    }

    @ApiOperation(value="\u987a\u4e30\u533b\u7597\u914d\u9001-\u5ba1\u6838\u901a\u8fc7\u63a5\u53e3")
    @PostMapping(value={"/sfMedicalReviewPassed"})
    public BaseResponse sfMedicalReviewPassed(@RequestBody @Validated SfMedicalReviewPassedReqVO sfMedicalReviewPassedReqVO) {
        this.senderCommonService.sfMedicalReviewPassed(sfMedicalReviewPassedReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u987a\u4e30\u533b\u7597\u914d\u9001-\u62d2\u7edd\u5ba1\u6838\u63a5\u53e3")
    @PostMapping(value={"/sfMedicalReviewRejected"})
    public BaseResponse sfMedicalReviewRejected(@RequestBody @Validated SfMedicalReviewRejectedReqVO sfMedicalReviewRejectedReqVO) {
        this.senderCommonService.sfMedicalReviewRejected(sfMedicalReviewRejectedReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u4eac\u4e1c\u914d\u9001-\u5ba1\u6838\u901a\u8fc7\u63a5\u53e3")
    @PostMapping(value={"/jdReviewPassed"})
    public BaseResponse jdReviewPassed(@RequestBody @Validated JdReviewPassedReqVO jdReviewPassedReqVO) {
        this.senderCommonService.jdReviewPassed(jdReviewPassedReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u4eac\u4e1c\u914d\u9001-\u62d2\u7edd\u5ba1\u6838\u63a5\u53e3")
    @PostMapping(value={"/jdReviewRejected"})
    public BaseResponse jdReviewRejected(@RequestBody @Validated JdReviewRejectedReqVO jdReviewRejectedReqVO) {
        this.senderCommonService.jdReviewRejected(jdReviewRejectedReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5546\u6237\u5730\u5740\u4fe1\u606f")
    @PostMapping(value={"/findAllMerchantAddressList"})
    public BaseResponse<PageResult<Map<String, Object>>> findAllMerchantAddressPage(@RequestBody @Validated FindAllMerchantAddressPageReqVO findAllMerchantAddressPageReqVO) {
        PageResult page = this.senderCommonService.findAllMerchantAddressPage(findAllMerchantAddressPageReqVO);
        return BaseResponse.success((Object)page);
    }

    @ApiOperation(value="\u66f4\u65b0\u516c\u5171\u5730\u5740\u53c2\u6570\u4fe1\u606f")
    @PostMapping(value={"/updateSenderCommon"})
    public BaseResponse updateSenderCommon(@RequestBody @Validated UpdateSenderCommonReqVO updateSenderCommonReqVO) {
        Long senderCommonId = updateSenderCommonReqVO.getId();
        SenderCommon senderCommon = (SenderCommon)this.senderCommonService.selectByPrimaryKey((Serializable)senderCommonId);
        if (senderCommon == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u5220\u9664\uff0c\u66f4\u65b0\u5931\u8d25\uff01");
        }
        this.senderCommonService.updateSenderCommon(updateSenderCommonReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u66f4\u65b0\u7f8e\u56e2\u540c\u57ce\u5e97\u94fa\u4fe1\u606f")
    @PostMapping(value={"/updateMtLocalStore"})
    public BaseResponse updateMtLocalStore(@RequestBody @Validated UpdateMtLocalStoreReqVO updateMtLocalStoreReqVO) {
        Long mtLocalStoreId = updateMtLocalStoreReqVO.getId();
        MtLocalStore mtLocalStore = (MtLocalStore)this.mtLocalStoreService.selectByPrimaryKey((Serializable)mtLocalStoreId);
        if (mtLocalStore == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u5220\u9664\uff0c\u66f4\u65b0\u5931\u8d25\uff01");
        }
        this.mtLocalStoreService.updateMtLocalStore(updateMtLocalStoreReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u66f4\u65b0\u987a\u4e30\u540c\u57ce\u5e97\u94fa\u4fe1\u606f")
    @PostMapping(value={"/updateSfLocalStore"})
    public BaseResponse updateSfLocalStore(@RequestBody @Validated UpdateSfLocalStoreReqVO updateSfLocalStoreReqVO) {
        Long sfLocalStoreId = updateSfLocalStoreReqVO.getId();
        SfLocalStore sfLocalStore = (SfLocalStore)this.sfLocalStoreService.selectByPrimaryKey((Serializable)sfLocalStoreId);
        if (sfLocalStore == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u5220\u9664\uff0c\u66f4\u65b0\u5931\u8d25\uff01");
        }
        this.sfLocalStoreService.updateSfLocalStore(updateSfLocalStoreReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u987a\u4e30\u540c\u57ce\u914d\u9001-\u5ba1\u6838\u901a\u8fc7\u63a5\u53e3")
    @PostMapping(value={"/sfLocalReviewPassed"})
    public BaseResponse sfLocalReviewPassed(@RequestBody @Validated SfLocalReviewPassedReqVO sfLocalReviewPassedReqVO) {
        this.sfLocalStoreService.sfLocalReviewPassed(sfLocalReviewPassedReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u987a\u4e30\u540c\u57ce\u914d\u9001-\u62d2\u7edd\u5ba1\u6838\u63a5\u53e3")
    @PostMapping(value={"/sfLocalReviewRejected"})
    public BaseResponse sfLocalReviewRejected(@RequestBody @Validated SfLocalReviewRejectedReqVO sfLocalReviewRejectedReqVO) {
        this.sfLocalStoreService.sfLocalReviewRejected(sfLocalReviewRejectedReqVO);
        return BaseResponse.success();
    }
}

