/*
 * Decompiled with CFR 0.152.
 */
package com.byh.api;

import com.alibaba.fastjson.JSON;
import com.byh.exception.BusinessException;
import com.byh.msg.ResponseMsg;
import com.byh.msg.SfLocalMsgInfo;
import com.byh.pojo.entity.Merchant;
import com.byh.pojo.entity.SfLocalCallbackUrl;
import com.byh.pojo.entity.SfLocalOrder;
import com.byh.service.MerchantService;
import com.byh.service.SfLocalCallbackUrlService;
import com.byh.service.SfLocalOrderService;
import com.byh.util.HttpUtils;
import com.byh.util.NewSignUtil;
import com.byh.util.sflocal.vo.DeliveryExceptionCallbackReqVO;
import com.byh.util.sflocal.vo.DeliveryStatusChangeCallbackReqVO;
import com.byh.util.sflocal.vo.OrderCancelCallbackReq;
import com.byh.util.sflocal.vo.OrderFinishCallbackReqVO;
import com.google.gson.Gson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u987a\u4e30\u540c\u57ce\u7684\u56de\u8c03\u63a5\u53e3"})
@RequestMapping(value={"/sf/local"})
public class SfLocalCallbackController {
    private static final Logger log = LoggerFactory.getLogger(SfLocalCallbackController.class);
    @Value(value="${environment}")
    private String environment;
    @Autowired
    private SfLocalOrderService sfLocalOrderService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private SfLocalCallbackUrlService sfLocalCallbackUrlService;

    @ApiOperation(value="\u914d\u9001\u72b6\u6001\u66f4\u6539")
    @PostMapping(value={"/delivery/status/change/callback"})
    public Map<String, Object> deliveryStatusChangeCallback(@RequestBody DeliveryStatusChangeCallbackReqVO deliveryStatusChangeCallbackReqVO, @RequestParam String sign) {
        Long sfOrderId = deliveryStatusChangeCallbackReqVO.getSf_order_id();
        SfLocalOrder sfLocalOrder = this.sfLocalOrderService.getBySfOrderId(sfOrderId.toString());
        if (sfLocalOrder == null) {
            throw new BusinessException("\u672c\u5730\u6ca1\u6709\u5bf9\u5e94\u7684\u8ba2\u5355\uff0c\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01");
        }
        Long merchantId = sfLocalOrder.getMerchantId();
        Merchant merchant = (Merchant)this.merchantService.selectByPrimaryKey((Serializable)merchantId);
        if (merchant == null) {
            throw new BusinessException("\u672c\u5730\u6ca1\u6709\u5bf9\u5e94\u7684\u5546\u6237\uff0c\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01");
        }
        String appId = null;
        String secret = null;
        if ("test".equals(this.environment)) {
            appId = merchant.getTestAppId();
            secret = merchant.getTestAppSecret();
        } else {
            appId = merchant.getFormalAppId();
            secret = merchant.getFormalAppSecret();
        }
        SfLocalMsgInfo sfLocalMsgInfo = new SfLocalMsgInfo();
        sfLocalMsgInfo.setMerchantId(merchantId);
        sfLocalMsgInfo.setAppId(appId);
        Long timestamp = System.currentTimeMillis() / 1000L;
        sfLocalMsgInfo.setTimestamp(timestamp);
        sfLocalMsgInfo.setMsgType(Integer.valueOf(10));
        String jsonMsg = JSON.toJSONString((Object)deliveryStatusChangeCallbackReqVO);
        sfLocalMsgInfo.setMessage(jsonMsg);
        String postJsonStr = JSON.toJSONString((Object)sfLocalMsgInfo);
        String mSign = null;
        try {
            mSign = NewSignUtil.sign((String)postJsonStr, (String)appId, (String)secret);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage());
            throw new BusinessException("\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01" + e.getMessage());
        }
        SfLocalCallbackUrl sfLocalCallbackUrl = this.sfLocalCallbackUrlService.getByMerchantId(merchantId);
        String url = sfLocalCallbackUrl.getNotifyUrl();
        String postJsonResp = null;
        try {
            postJsonResp = HttpUtils.postJson((String)(url + "?sign=" + mSign), (String)postJsonStr);
            Gson gson = new Gson();
            ResponseMsg responseMsg = (ResponseMsg)gson.fromJson(postJsonResp, ResponseMsg.class);
            if (responseMsg.getCode() == 0 && "success".equals(responseMsg.getMsg())) {
                HashMap<String, Object> ret = new HashMap<String, Object>(16);
                ret.put("error_code", 0);
                ret.put("error_msg", "success");
                return ret;
            }
            throw new BusinessException("\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    @ApiOperation(value="\u8ba2\u5355\u5b8c\u6210")
    @PostMapping(value={"/order/finish/callback"})
    public Map<String, Object> orderFinishCallback(@RequestBody OrderFinishCallbackReqVO orderFinishCallbackReqVO, @RequestParam String sign) {
        String sfOrderId = orderFinishCallbackReqVO.getSf_order_id();
        SfLocalOrder sfLocalOrder = this.sfLocalOrderService.getBySfOrderId(sfOrderId);
        if (sfLocalOrder == null) {
            throw new BusinessException("\u672c\u5730\u6ca1\u6709\u5bf9\u5e94\u7684\u8ba2\u5355\uff0c\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01");
        }
        Long merchantId = sfLocalOrder.getMerchantId();
        Merchant merchant = (Merchant)this.merchantService.selectByPrimaryKey((Serializable)merchantId);
        if (merchant == null) {
            throw new BusinessException("\u672c\u5730\u6ca1\u6709\u5bf9\u5e94\u7684\u5546\u6237\uff0c\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01");
        }
        String appId = null;
        String secret = null;
        if ("test".equals(this.environment)) {
            appId = merchant.getTestAppId();
            secret = merchant.getTestAppSecret();
        } else {
            appId = merchant.getFormalAppId();
            secret = merchant.getFormalAppSecret();
        }
        SfLocalMsgInfo sfLocalMsgInfo = new SfLocalMsgInfo();
        sfLocalMsgInfo.setMerchantId(merchantId);
        sfLocalMsgInfo.setAppId(appId);
        Long timestamp = System.currentTimeMillis() / 1000L;
        sfLocalMsgInfo.setTimestamp(timestamp);
        sfLocalMsgInfo.setMsgType(Integer.valueOf(20));
        String jsonMsg = JSON.toJSONString((Object)orderFinishCallbackReqVO);
        sfLocalMsgInfo.setMessage(jsonMsg);
        String postJsonStr = JSON.toJSONString((Object)sfLocalMsgInfo);
        String mSign = null;
        try {
            mSign = NewSignUtil.sign((String)postJsonStr, (String)appId, (String)secret);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage());
            throw new BusinessException("\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01" + e.getMessage());
        }
        SfLocalCallbackUrl sfLocalCallbackUrl = this.sfLocalCallbackUrlService.getByMerchantId(merchantId);
        String url = sfLocalCallbackUrl.getNotifyUrl();
        String postJsonResp = null;
        try {
            postJsonResp = HttpUtils.postJson((String)(url + "?sign=" + mSign), (String)postJsonStr);
            Gson gson = new Gson();
            ResponseMsg responseMsg = (ResponseMsg)gson.fromJson(postJsonResp, ResponseMsg.class);
            if (responseMsg.getCode() == 0 && "success".equals(responseMsg.getMsg())) {
                HashMap<String, Object> ret = new HashMap<String, Object>(16);
                ret.put("error_code", 0);
                ret.put("error_msg", "success");
                return ret;
            }
            throw new BusinessException("\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    @ApiOperation(value="\u987a\u4e30\u539f\u56e0\u53d6\u6d88")
    @PostMapping(value={"/order/cancel/callback"})
    public Map<String, Object> orderCancelCallback(@RequestBody OrderCancelCallbackReq orderCancelCallbackReq, @RequestParam String sign) {
        String sfOrderId = orderCancelCallbackReq.getSf_order_id();
        SfLocalOrder sfLocalOrder = this.sfLocalOrderService.getBySfOrderId(sfOrderId);
        if (sfLocalOrder == null) {
            throw new BusinessException("\u672c\u5730\u6ca1\u6709\u5bf9\u5e94\u7684\u8ba2\u5355\uff0c\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01");
        }
        Long merchantId = sfLocalOrder.getMerchantId();
        Merchant merchant = (Merchant)this.merchantService.selectByPrimaryKey((Serializable)merchantId);
        if (merchant == null) {
            throw new BusinessException("\u672c\u5730\u6ca1\u6709\u5bf9\u5e94\u7684\u5546\u6237\uff0c\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01");
        }
        String appId = null;
        String secret = null;
        if ("test".equals(this.environment)) {
            appId = merchant.getTestAppId();
            secret = merchant.getTestAppSecret();
        } else {
            appId = merchant.getFormalAppId();
            secret = merchant.getFormalAppSecret();
        }
        SfLocalMsgInfo sfLocalMsgInfo = new SfLocalMsgInfo();
        sfLocalMsgInfo.setMerchantId(merchantId);
        sfLocalMsgInfo.setAppId(appId);
        Long timestamp = System.currentTimeMillis() / 1000L;
        sfLocalMsgInfo.setTimestamp(timestamp);
        sfLocalMsgInfo.setMsgType(Integer.valueOf(30));
        String jsonMsg = JSON.toJSONString((Object)orderCancelCallbackReq);
        sfLocalMsgInfo.setMessage(jsonMsg);
        String postJsonStr = JSON.toJSONString((Object)sfLocalMsgInfo);
        String mSign = null;
        try {
            mSign = NewSignUtil.sign((String)postJsonStr, (String)appId, (String)secret);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage());
            throw new BusinessException("\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01" + e.getMessage());
        }
        SfLocalCallbackUrl sfLocalCallbackUrl = this.sfLocalCallbackUrlService.getByMerchantId(merchantId);
        String url = sfLocalCallbackUrl.getNotifyUrl();
        String postJsonResp = null;
        try {
            postJsonResp = HttpUtils.postJson((String)(url + "?sign=" + mSign), (String)postJsonStr);
            Gson gson = new Gson();
            ResponseMsg responseMsg = (ResponseMsg)gson.fromJson(postJsonResp, ResponseMsg.class);
            if (responseMsg.getCode() == 0 && "success".equals(responseMsg.getMsg())) {
                HashMap<String, Object> ret = new HashMap<String, Object>(16);
                ret.put("error_code", 0);
                ret.put("error_msg", "success");
                return ret;
            }
            throw new BusinessException("\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    @ApiOperation(value="\u914d\u9001\u5f02\u5e38")
    @PostMapping(value={"/delivery/exception/callback"})
    public Map<String, Object> deliveryExceptionCallback(@RequestBody DeliveryExceptionCallbackReqVO deliveryExceptionCallbackReqVO, @RequestParam String sign) {
        Long sfOrderId = deliveryExceptionCallbackReqVO.getSf_order_id();
        SfLocalOrder sfLocalOrder = this.sfLocalOrderService.getBySfOrderId(sfOrderId.toString());
        if (sfLocalOrder == null) {
            throw new BusinessException("\u672c\u5730\u6ca1\u6709\u5bf9\u5e94\u7684\u8ba2\u5355\uff0c\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01");
        }
        Long merchantId = sfLocalOrder.getMerchantId();
        Merchant merchant = (Merchant)this.merchantService.selectByPrimaryKey((Serializable)merchantId);
        if (merchant == null) {
            throw new BusinessException("\u672c\u5730\u6ca1\u6709\u5bf9\u5e94\u7684\u5546\u6237\uff0c\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01");
        }
        String appId = null;
        String secret = null;
        if ("test".equals(this.environment)) {
            appId = merchant.getTestAppId();
            secret = merchant.getTestAppSecret();
        } else {
            appId = merchant.getFormalAppId();
            secret = merchant.getFormalAppSecret();
        }
        SfLocalMsgInfo sfLocalMsgInfo = new SfLocalMsgInfo();
        sfLocalMsgInfo.setMerchantId(merchantId);
        sfLocalMsgInfo.setAppId(appId);
        Long timestamp = System.currentTimeMillis() / 1000L;
        sfLocalMsgInfo.setTimestamp(timestamp);
        sfLocalMsgInfo.setMsgType(Integer.valueOf(40));
        String jsonMsg = JSON.toJSONString((Object)deliveryExceptionCallbackReqVO);
        sfLocalMsgInfo.setMessage(jsonMsg);
        String postJsonStr = JSON.toJSONString((Object)sfLocalMsgInfo);
        String mSign = null;
        try {
            mSign = NewSignUtil.sign((String)postJsonStr, (String)appId, (String)secret);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage());
            throw new BusinessException("\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01" + e.getMessage());
        }
        SfLocalCallbackUrl sfLocalCallbackUrl = this.sfLocalCallbackUrlService.getByMerchantId(merchantId);
        String url = sfLocalCallbackUrl.getNotifyUrl();
        String postJsonResp = null;
        try {
            postJsonResp = HttpUtils.postJson((String)(url + "?sign=" + mSign), (String)postJsonStr);
            Gson gson = new Gson();
            ResponseMsg responseMsg = (ResponseMsg)gson.fromJson(postJsonResp, ResponseMsg.class);
            if (responseMsg.getCode() == 0 && "success".equals(responseMsg.getMsg())) {
                HashMap<String, Object> ret = new HashMap<String, Object>(16);
                ret.put("error_code", 0);
                ret.put("error_msg", "success");
                return ret;
            }
            throw new BusinessException("\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01" + e.getMessage());
        }
    }
}

