/*
 * Decompiled with CFR 0.152.
 */
package com.byh.interceptor;

import com.byh.exception.AuthException;
import com.byh.pojo.entity.Account;
import com.byh.util.JwtUtil;
import com.google.gson.Gson;
import io.jsonwebtoken.Claims;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class JWTInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JWTInterceptor.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String jwt = request.getHeader("token");
        if (jwt == null) {
            throw new AuthException("\u7528\u6237\u672a\u767b\u5f55\uff0c\u9a8c\u8bc1\u5931\u8d25\uff01");
        }
        Claims claims = null;
        try {
            claims = JwtUtil.parseJWT((String)jwt);
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw new AuthException("\u4e0d\u5408\u6cd5\u7684\u8eab\u4efd\u4ee4\u724c\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        }
        String subject = claims.getSubject();
        Gson gson = new Gson();
        Account account = (Account)gson.fromJson(subject, Account.class);
        String viewId = account.getViewId();
        String token = (String)this.redisTemplate.opsForValue().get((Object)viewId);
        if (token == null) {
            throw new AuthException("token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        }
        if (!token.equals(jwt)) {
            throw new AuthException("\u60a8\u5df2\u7ecf\u5728\u5176\u4ed6\u8bbe\u5907\u767b\u5f55\uff01");
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

