/*
 * Decompiled with CFR 0.152.
 */
package com.byh.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.byh.config.RequestWrapper;
import com.byh.exception.AuthException;
import com.byh.pojo.entity.Merchant;
import com.byh.service.MerchantService;
import com.byh.util.NewSignUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class NewAuthInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(NewAuthInterceptor.class);
    private static final String TEST_ENVIRONMENT = "test";
    private static final String PRO_ENVIRONMENT = "pro";
    @Value(value="${environment}")
    private String environment;
    @Autowired
    private MerchantService merchantService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        long reqTime;
        RequestWrapper requestWrapper = new RequestWrapper(request);
        String body = requestWrapper.getBody();
        String sign = request.getParameter("sign");
        if (sign == null || "".equals(sign)) {
            throw new AuthException("\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        Set entries = jsonObject.entrySet();
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            String val = entry.getValue().toString();
            map.put(key, val);
        }
        String timestamp = (String)map.get("timestamp");
        if (timestamp == null || "".equals(timestamp)) {
            throw new AuthException("\u9274\u6743\u65f6\u95f4\u6233\u7f3a\u5931");
        }
        long currentTimeMillis = System.currentTimeMillis() / 1000L;
        if (currentTimeMillis + 1000L < (reqTime = Long.parseLong(timestamp))) {
            log.info("currentTimeMillis = " + currentTimeMillis);
            log.info("reqTime = " + reqTime);
            throw new AuthException("\u65f6\u95f4\u6233\u9700\u8981\u7cbe\u786e\u5230\u79d2\uff01");
        }
        if (Math.abs(currentTimeMillis - reqTime) > 300000L) {
            log.info("currentTimeMillis\uff1a" + currentTimeMillis);
            log.info("reqTime\uff1a" + reqTime);
            throw new AuthException("\u7b7e\u540d\u5df2\u7ecf\u8fc7\u671f");
        }
        String appId = (String)map.get("app_id");
        if (appId == null || "".equals(appId.trim())) {
            throw new AuthException("appId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String merchantId = (String)map.get("merchant_id");
        if (merchantId == null || "".equals(merchantId.trim())) {
            throw new AuthException("merchantId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Merchant merchant = (Merchant)this.merchantService.selectByPrimaryKey((Serializable)Long.valueOf(merchantId));
        if (merchant == null) {
            throw new AuthException("\u5e94\u7528\u4e0d\u5b58\u5728\uff01");
        }
        if (TEST_ENVIRONMENT.equals(this.environment)) {
            String testAppId = merchant.getTestAppId();
            if (!appId.equals(testAppId)) throw new AuthException("\u5e94\u7528\u4e0d\u5b58\u5728\uff01");
            String testAppSecret = merchant.getTestAppSecret();
            String mSign = NewSignUtil.sign((String)body, (String)appId, (String)testAppSecret);
            if (mSign.equals(sign)) return true;
            throw new AuthException("\u7b7e\u540d\u9519\u8bef");
        }
        if (!PRO_ENVIRONMENT.equals(this.environment)) throw new AuthException("\u73af\u5883\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff01");
        String formalAppId = merchant.getFormalAppId();
        if (!appId.equals(formalAppId)) throw new AuthException("\u5e94\u7528\u4e0d\u5b58\u5728\uff01");
        String formalAppSecret = merchant.getFormalAppSecret();
        String mSign = NewSignUtil.sign((String)body, (String)appId, (String)formalAppSecret);
        if (mSign.equals(sign)) return true;
        throw new AuthException("\u7b7e\u540d\u9519\u8bef");
    }
}

