/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl;

import com.byh.dao.AccountMapper;
import com.byh.exception.BusinessException;
import com.byh.pojo.entity.Account;
import com.byh.pojo.vo.req.AccountPageReqVO;
import com.byh.pojo.vo.req.SaveAccountReqVO;
import com.byh.pojo.vo.req.UpdateAccountReqVO;
import com.byh.pojo.vo.resp.AccountRespVO;
import com.byh.service.AccountService;
import com.byh.util.JwtUtil;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AccountServiceImpl
implements AccountService {
    private static final Logger log = LoggerFactory.getLogger(AccountServiceImpl.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private AccountMapper accountMapper;

    public int insert(Account entity) {
        return this.accountMapper.insert(entity);
    }

    public void deleteById(Long id) {
        this.accountMapper.deleteByPrimaryKey(id);
    }

    public void updateByPrimaryKeySelective(Account entity) {
        this.accountMapper.updateByPrimaryKeySelective(entity);
    }

    public Account selectByPrimaryKey(Long id) {
        return this.accountMapper.selectByPrimaryKey(id);
    }

    public void save(SaveAccountReqVO saveAccountReqVO) {
        Account account = new Account();
        BeanUtils.copyProperties((Object)saveAccountReqVO, (Object)account);
        account.setStatus(Integer.valueOf(1));
        account.setViewId(UUIDUtils.getUUID());
        account.setLoginPwd("123456");
        this.insert(account);
    }

    public void update(UpdateAccountReqVO updateAccountReqVO) {
        Account account = this.selectByPrimaryKey(updateAccountReqVO.getId());
        if (account == null) {
            throw new BusinessException("\u7528\u6237\u5df2\u5220\u9664\uff01");
        }
        BeanUtils.copyProperties((Object)updateAccountReqVO, (Object)account);
        this.updateByPrimaryKeySelective(account);
    }

    public AccountRespVO getById(Long id) {
        Account account = this.selectByPrimaryKey(id);
        if (account == null) {
            return null;
        }
        AccountRespVO accountRespVO = new AccountRespVO();
        BeanUtils.copyProperties((Object)account, (Object)accountRespVO);
        return accountRespVO;
    }

    public PageResult<AccountRespVO> getPage(AccountPageReqVO accountPageReqVO) {
        Integer pageNum = accountPageReqVO.getPageNum();
        Integer pageSize = accountPageReqVO.getPageSize();
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List accountRespVOList = this.accountMapper.findByPageReqVO(accountPageReqVO);
        PageInfo pageInfo = new PageInfo(accountRespVOList);
        PageResult pageResult = new PageResult();
        pageResult.setPageNum(pageInfo.getPageNum());
        pageResult.setPageSize(pageInfo.getPageSize());
        Long total = pageInfo.getTotal();
        pageResult.setTotal(total.intValue());
        pageResult.setTotalPages(pageInfo.getPages());
        pageResult.setContent(accountRespVOList);
        return pageResult;
    }

    public Account getByLoginNameAndPassword(String loginName, String password) {
        return this.accountMapper.getByLoginNameAndPassword(loginName, password);
    }

    public Map<String, Object> login(String loginName, String password) {
        Account account = this.getByLoginNameAndPassword(loginName, password);
        if (account == null) {
            throw new BusinessException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff01");
        }
        account.setTmpKey(UUIDUtils.getUUID());
        Gson gson = new Gson();
        String subject = gson.toJson((Object)account);
        try {
            String token = JwtUtil.createJWT((String)account.getViewId(), (String)subject);
            this.redisTemplate.opsForValue().set((Object)account.getViewId(), (Object)token, 60L, TimeUnit.MINUTES);
            HashMap<String, Object> ret = new HashMap<String, Object>(16);
            ret.put("token", token);
            account.setLoginPwd(null);
            account.setIdNumber(null);
            ret.put("account", account);
            return ret;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("token\u751f\u6210\u9519\u8bef\uff01");
        }
    }

    public void logout(Long accountId) {
        Account account = this.selectByPrimaryKey(accountId);
        if (account == null) {
            throw new BusinessException("\u9000\u51fa\u5931\u8d25\uff0c\u6ca1\u6709\u67e5\u5230\u7528\u6237\u4fe1\u606f\uff01");
        }
        String viewId = account.getViewId();
        this.redisTemplate.delete((Object)viewId);
    }
}

