/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl;

import com.byh.dao.JdOrderRecordMapper;
import com.byh.pojo.entity.JdOrderRecord;
import com.byh.pojo.vo.jdlogistics.EclpB2cPromiseInfoApiQueryWaybillFreightsVo;
import com.byh.pojo.vo.jdlogistics.LdopDeliveryProviderCancelWayBillVo;
import com.byh.pojo.vo.jdlogistics.LdopReceiveOrderInterceptVo;
import com.byh.pojo.vo.jdlogistics.LdopReceiveTraceGetVo;
import com.byh.pojo.vo.jdlogistics.LdopWaybillReceiveVo;
import com.byh.service.JdLogisticsService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.domain.ECLP.PromiseInfoApi.response.queryWaybillFreights.ResponseDTO;
import com.jd.open.api.sdk.domain.etms.OrderInfoOperateSaf.response.intercept.OrderInfoOperateResponse;
import com.jd.open.api.sdk.domain.etms.TraceQueryJsf.response.get.TraceQueryResultDTO;
import com.jd.open.api.sdk.domain.etms.WaybillJosService.response.receive.WaybillResultInfoDTO;
import com.jd.open.api.sdk.request.ECLP.EclpB2cPromiseInfoApiQueryWaybillFreightsRequest;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.request.delivery.LdopDeliveryProviderCancelWayBillRequest;
import com.jd.open.api.sdk.request.etms.LdopReceiveOrderInterceptRequest;
import com.jd.open.api.sdk.request.etms.LdopReceiveTraceGetRequest;
import com.jd.open.api.sdk.request.etms.LdopWaybillReceiveRequest;
import com.jd.open.api.sdk.response.ECLP.EclpB2cPromiseInfoApiQueryWaybillFreightsResponse;
import com.jd.open.api.sdk.response.delivery.LdopDeliveryProviderCancelWayBillResponse;
import com.jd.open.api.sdk.response.etms.LdopReceiveOrderInterceptResponse;
import com.jd.open.api.sdk.response.etms.LdopReceiveTraceGetResponse;
import com.jd.open.api.sdk.response.etms.LdopWaybillReceiveResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class JdLogisticsServiceImpl
implements JdLogisticsService {
    private static final Logger log = LoggerFactory.getLogger(JdLogisticsServiceImpl.class);
    @Value(value="${jdappkey}")
    private String appKey;
    @Value(value="${jdappsecret}")
    private String appSecret;
    @Value(value="${jdaccesstoken}")
    private String accessToken;
    String serverUrl = "https://api.jd.com/routerjson";
    Integer successStatus = 100;
    @Autowired
    private JdOrderRecordMapper jdOrderRecordMapper;

    public BaseResponse receive(LdopWaybillReceiveVo ldopWaybillReceiveVo) throws Exception {
        DefaultJdClient client = new DefaultJdClient(this.serverUrl, this.accessToken, this.appKey, this.appSecret);
        LdopWaybillReceiveRequest request = new LdopWaybillReceiveRequest();
        BeanUtils.copyProperties((Object)ldopWaybillReceiveVo, (Object)request);
        String s = JsonUtil.convertObject((Object)request);
        log.info("\u8c03\u7528\u4eac\u4e1c\u63a5\u5355\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)s);
        LdopWaybillReceiveResponse response = (LdopWaybillReceiveResponse)client.execute((JdRequest)request);
        WaybillResultInfoDTO receiveorderinfoResult = response.getReceiveorderinfoResult();
        String s1 = JsonUtil.convertObject((Object)receiveorderinfoResult);
        log.info("\u8c03\u7528\u4eac\u4e1c\u63a5\u5355\u63a5\u53e3\u8fd4\u53c2\uff1a{}", (Object)s1);
        try {
            JdOrderRecord jdOrderRecord = new JdOrderRecord();
            jdOrderRecord.setMerchantId(ldopWaybillReceiveVo.getMerchant_id() + "");
            jdOrderRecord.setOrderId(ldopWaybillReceiveVo.getOrderId());
            jdOrderRecord.setCustomerCode(ldopWaybillReceiveVo.getCustomerCode());
            jdOrderRecord.setJdRequest(s);
            jdOrderRecord.setJdResponse(s1);
            if (this.successStatus.equals(receiveorderinfoResult.getResultCode())) {
                jdOrderRecord.setStatus(Integer.valueOf(1));
            } else {
                jdOrderRecord.setStatus(Integer.valueOf(0));
            }
            this.jdOrderRecordMapper.insertSelective(jdOrderRecord);
        }
        catch (Exception e) {
            log.info("\u4eac\u4e1c\u8ba2\u5355\u53f7\uff1a{} \u5b58\u50a8\u5931\u8d25: {}", (Object)ldopWaybillReceiveVo.getOrderId(), (Object)e.getStackTrace());
        }
        if (null != receiveorderinfoResult && this.successStatus.equals(receiveorderinfoResult.getResultCode())) {
            return BaseResponse.success((Object)receiveorderinfoResult);
        }
        return BaseResponse.error((String)(receiveorderinfoResult.getResultCode() + ":" + receiveorderinfoResult.getResultMessage()));
    }

    public BaseResponse cancelWayBill(LdopDeliveryProviderCancelWayBillVo ldopDeliveryProviderCancelWayBillVo) throws Exception {
        DefaultJdClient client = new DefaultJdClient(this.serverUrl, this.accessToken, this.appKey, this.appSecret);
        LdopDeliveryProviderCancelWayBillRequest request = new LdopDeliveryProviderCancelWayBillRequest();
        BeanUtils.copyProperties((Object)ldopDeliveryProviderCancelWayBillVo, (Object)request);
        log.info("\u8c03\u7528\u4eac\u4e1c\u8ba2\u5355\u53d6\u6d88\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)request));
        LdopDeliveryProviderCancelWayBillResponse response = (LdopDeliveryProviderCancelWayBillResponse)client.execute((JdRequest)request);
        com.jd.open.api.sdk.domain.delivery.OrderCancelApi.response.cancelWayBill.ResponseDTO responseDTO = response.getResponseDTO();
        log.info("\u8c03\u7528\u4eac\u4e1c\u8ba2\u5355\u53d6\u6d88\u8fd4\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)responseDTO));
        if (null != responseDTO && "0".equals(responseDTO.getStatusCode())) {
            return BaseResponse.success((Object)responseDTO);
        }
        return BaseResponse.error((String)(responseDTO.getStatusCode() + ":" + responseDTO.getStatusMessage()));
    }

    public BaseResponse intercept(LdopReceiveOrderInterceptVo ldopReceiveOrderInterceptVo) throws Exception {
        DefaultJdClient client = new DefaultJdClient(this.serverUrl, this.accessToken, this.appKey, this.appSecret);
        LdopReceiveOrderInterceptRequest request = new LdopReceiveOrderInterceptRequest();
        BeanUtils.copyProperties((Object)ldopReceiveOrderInterceptVo, (Object)request);
        log.info("\u8c03\u7528\u4eac\u4e1c\u8fd0\u5355\u62e6\u622a\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)request));
        LdopReceiveOrderInterceptResponse response = (LdopReceiveOrderInterceptResponse)client.execute((JdRequest)request);
        OrderInfoOperateResponse resultInfo = response.getResultInfo();
        log.info("\u8c03\u7528\u4eac\u4e1c\u8fd0\u5355\u62e6\u622a\u8fd4\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)resultInfo));
        if (null != resultInfo && this.successStatus.equals(resultInfo.getStateCode())) {
            return BaseResponse.success((Object)resultInfo);
        }
        return BaseResponse.error((String)(resultInfo.getStateCode() + ":" + resultInfo.getStateMessage()));
    }

    public BaseResponse traceGet(LdopReceiveTraceGetVo ldopReceiveTraceGetVo) throws Exception {
        DefaultJdClient client = new DefaultJdClient(this.serverUrl, this.accessToken, this.appKey, this.appSecret);
        LdopReceiveTraceGetRequest request = new LdopReceiveTraceGetRequest();
        BeanUtils.copyProperties((Object)ldopReceiveTraceGetVo, (Object)request);
        log.info("\u8c03\u7528\u4eac\u4e1c\u67e5\u8be2\u7269\u6d41\u8ddf\u8e2a\u6d88\u606f\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)request));
        LdopReceiveTraceGetResponse response = (LdopReceiveTraceGetResponse)client.execute((JdRequest)request);
        TraceQueryResultDTO querytraceResult = response.getQuerytraceResult();
        log.info("\u8c03\u7528\u4eac\u4e1c\u67e5\u8be2\u7269\u6d41\u8ddf\u8e2a\u6d88\u606f\u8fd4\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)querytraceResult));
        return BaseResponse.success((Object)querytraceResult);
    }

    public BaseResponse queryWaybillFreights(EclpB2cPromiseInfoApiQueryWaybillFreightsVo eclpB2cPromiseInfoApiQueryWaybillFreightsVo) throws Exception {
        Integer wayBillSuccess = 0;
        DefaultJdClient client = new DefaultJdClient(this.serverUrl, this.accessToken, this.appKey, this.appSecret);
        EclpB2cPromiseInfoApiQueryWaybillFreightsRequest request = new EclpB2cPromiseInfoApiQueryWaybillFreightsRequest();
        BeanUtils.copyProperties((Object)eclpB2cPromiseInfoApiQueryWaybillFreightsVo, (Object)request);
        log.info("\u8c03\u7528\u4eac\u4e1c\u9884\u4f30\u8fd0\u8d39\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)request));
        EclpB2cPromiseInfoApiQueryWaybillFreightsResponse response = (EclpB2cPromiseInfoApiQueryWaybillFreightsResponse)client.execute((JdRequest)request);
        ResponseDTO responseDTO = response.getResponseDTO();
        log.info("\u8c03\u7528\u4eac\u4e1c\u9884\u4f30\u8fd0\u8d39\u67e5\u8be2\u8fd4\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)responseDTO));
        if (null != responseDTO && wayBillSuccess.equals(responseDTO.getStatusCode())) {
            return BaseResponse.success((Object)responseDTO);
        }
        return BaseResponse.error((String)(responseDTO.getStatusCode() + ":" + responseDTO.getStatusMessage()));
    }
}

