/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl;

import com.byh.dao.MerchantMapper;
import com.byh.exception.BusinessException;
import com.byh.pojo.entity.Merchant;
import com.byh.pojo.vo.req.MerchantPageReqVO;
import com.byh.pojo.vo.req.SaveMerchantReqVO;
import com.byh.pojo.vo.req.UpdateMerchantReqVO;
import com.byh.pojo.vo.resp.MerchantRespVO;
import com.byh.service.MerchantService;
import com.byh.util.UUIDUtil;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MerchantServiceImpl
implements MerchantService {
    @Autowired
    private MerchantMapper merchantMapper;

    public int insert(Merchant entity) {
        return this.merchantMapper.insert(entity);
    }

    public void deleteById(Long id) {
        this.merchantMapper.deleteByPrimaryKey(id);
    }

    public void updateByPrimaryKeySelective(Merchant entity) {
        this.merchantMapper.updateByPrimaryKeySelective(entity);
    }

    public Merchant selectByPrimaryKey(Long id) {
        return this.merchantMapper.selectByPrimaryKey(id);
    }

    public void save(SaveMerchantReqVO saveMerchantReqVO) {
        Merchant merchant = new Merchant();
        BeanUtils.copyProperties((Object)saveMerchantReqVO, (Object)merchant);
        merchant.setStatus(Integer.valueOf(1));
        merchant.setViewId(UUIDUtils.getUUID());
        this.insert(merchant);
    }

    public void update(UpdateMerchantReqVO updateMerchantReqVO) {
        Merchant merchant = this.selectByPrimaryKey(updateMerchantReqVO.getId());
        if (merchant == null) {
            throw new BusinessException("\u5546\u6237\u6237\u5df2\u5220\u9664\uff01");
        }
        BeanUtils.copyProperties((Object)updateMerchantReqVO, (Object)merchant);
        this.updateByPrimaryKeySelective(merchant);
    }

    public PageResult<MerchantRespVO> getPage(MerchantPageReqVO merchantPageReqVO) {
        Integer pageNum = merchantPageReqVO.getPageNum();
        Integer pageSize = merchantPageReqVO.getPageSize();
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List accountRespVOList = this.merchantMapper.findByPageReqVO(merchantPageReqVO);
        PageInfo pageInfo = new PageInfo(accountRespVOList);
        PageResult pageResult = new PageResult();
        pageResult.setPageNum(pageInfo.getPageNum());
        pageResult.setPageSize(pageInfo.getPageSize());
        Long total = pageInfo.getTotal();
        pageResult.setTotal(total.intValue());
        pageResult.setTotalPages(pageInfo.getPages());
        pageResult.setContent(accountRespVOList);
        return pageResult;
    }

    public MerchantRespVO getById(Long id) {
        Merchant merchant = this.selectByPrimaryKey(id);
        MerchantRespVO merchantRespVO = new MerchantRespVO();
        BeanUtils.copyProperties((Object)merchant, (Object)merchantRespVO);
        return merchantRespVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void generateTestDevelopmentConfig(Long id) {
        Merchant merchant = this.selectByPrimaryKey(id);
        if (merchant == null) {
            throw new BusinessException("\u8be5\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        String testAppId = merchant.getTestAppId();
        String testAppSecret = merchant.getTestAppSecret();
        if (testAppId != null && testAppSecret != null) {
            throw new BusinessException("\u6d4b\u8bd5\u73af\u5883\u5f00\u53d1\u914d\u7f6e\u4fe1\u606f\u5df2\u7ecf\u751f\u6210\uff0c\u4e0d\u53ef\u91cd\u590d\u751f\u6210\uff01");
        }
        merchant.setTestAppId("APPID" + UUIDUtil.getUUID());
        merchant.setTestAppSecret("APPSECRET" + UUIDUtil.getUUID());
        this.updateByPrimaryKeySelective(merchant);
    }

    @Transactional(rollbackFor={Exception.class})
    public void generateFormalDevelopmentConfig(Long id) {
        Merchant merchant = this.selectByPrimaryKey(id);
        if (merchant == null) {
            throw new BusinessException("\u8be5\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        String formalAppId = merchant.getFormalAppId();
        String formalAppSecret = merchant.getFormalAppSecret();
        if (formalAppId != null && formalAppSecret != null) {
            throw new BusinessException("\u6b63\u5f0f\u73af\u5883\u5f00\u53d1\u914d\u7f6e\u4fe1\u606f\u5df2\u7ecf\u751f\u6210\uff0c\u4e0d\u53ef\u91cd\u590d\u751f\u6210\uff01");
        }
        merchant.setFormalAppId("APPID" + UUIDUtil.getUUID());
        merchant.setFormalAppSecret("APPSECRET" + UUIDUtil.getUUID());
        this.updateByPrimaryKeySelective(merchant);
    }

    public Long getCountBYAccountId(Long accountId) {
        return this.merchantMapper.getCountBYAccountId(accountId);
    }
}

