/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl;

import com.byh.dao.OrderStatusMsgMapper;
import com.byh.pojo.entity.OrderExceptionMsg;
import com.byh.pojo.entity.OrderStatusMsg;
import com.byh.service.OrderExceptionMsgService;
import com.byh.service.OrderStatusMsgService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderStatusMsgServiceImpl
implements OrderStatusMsgService {
    @Autowired
    private OrderStatusMsgMapper orderStatusMsgMapper;
    @Autowired
    private OrderExceptionMsgService orderExceptionMsgService;

    public int insert(OrderStatusMsg entity) {
        return this.orderStatusMsgMapper.insert(entity);
    }

    public void deleteById(Long id) {
        this.orderStatusMsgMapper.deleteByPrimaryKey(id);
    }

    public void updateByPrimaryKeySelective(OrderStatusMsg entity) {
        this.orderStatusMsgMapper.updateByPrimaryKeySelective(entity);
    }

    public OrderStatusMsg selectByPrimaryKey(Long id) {
        return this.orderStatusMsgMapper.selectByPrimaryKey(id);
    }

    public OrderStatusMsg getLatestOrderStatusMsg(String mtPeisongId) {
        return this.orderStatusMsgMapper.getLatestOrderStatusMsg(mtPeisongId);
    }

    public Map<String, Object> getLatestOrderStatusMsgAndExceptionMsg(String mtPeisongId) {
        OrderStatusMsg latestOrderStatusMsg = this.getLatestOrderStatusMsg(mtPeisongId);
        OrderExceptionMsg orderExceptionMsg = this.orderExceptionMsgService.getByMtPeisongId(mtPeisongId);
        HashMap<String, Object> ret = new HashMap<String, Object>(16);
        ret.put("latestOrderStatusMsg", latestOrderStatusMsg);
        ret.put("orderExceptionMsg", orderExceptionMsg);
        return ret;
    }

    public Map<String, Object> findOrderStatusMsgListAndExceptionMsg(String mtPeisongId) {
        List orderStatusMsgList = this.findOrderStatusMsgList(mtPeisongId);
        OrderExceptionMsg orderExceptionMsg = this.orderExceptionMsgService.getByMtPeisongId(mtPeisongId);
        HashMap<String, Object> ret = new HashMap<String, Object>(16);
        ret.put("orderStatusMsgList", orderStatusMsgList);
        ret.put("orderExceptionMsg", orderExceptionMsg);
        return ret;
    }

    public List<OrderStatusMsg> findOrderStatusMsgList(String mtPeisongId) {
        return this.orderStatusMsgMapper.findOrderStatusMsgList(mtPeisongId);
    }
}

