/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl;

import com.alibaba.fastjson.JSON;
import com.byh.dao.SfLocalOrderMapper;
import com.byh.pojo.entity.SfLocalOrder;
import com.byh.pojo.vo.req.SflCancelOrderReqVO;
import com.byh.pojo.vo.req.SflCreateOrderReqVO;
import com.byh.pojo.vo.req.SflGetCallbackInfoReqVO;
import com.byh.pojo.vo.req.SflListOrderFeedReqVO;
import com.byh.pojo.vo.req.SflPrCreateOrderReqVO;
import com.byh.service.SfLocalOrderService;
import com.byh.util.UUIDUtil;
import com.byh.util.sflocal.SFRequestHelper;
import com.byh.util.sflocal.vo.req.CancelOrderReqVO;
import com.byh.util.sflocal.vo.req.CreateOrderReqVO;
import com.byh.util.sflocal.vo.req.GetCallbackInfoReqVO;
import com.byh.util.sflocal.vo.req.ListOrderFeedReqVO;
import com.byh.util.sflocal.vo.req.PreCreateOrderReqVO;
import com.byh.util.sflocal.vo.resp.CancelOrderRespVO;
import com.byh.util.sflocal.vo.resp.CreateOrderRespVO;
import com.byh.util.sflocal.vo.resp.GetCallbackInfoRespVO;
import com.byh.util.sflocal.vo.resp.ListOrderFeedRespVO;
import com.byh.util.sflocal.vo.resp.PreCreateOrderRespVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SfLocalOrderServiceImpl
implements SfLocalOrderService {
    private static final Logger log = LoggerFactory.getLogger(SfLocalOrderServiceImpl.class);
    @Value(value="${sf-local.app-id}")
    private String sfAppId;
    @Value(value="${sf-local.app-secret}")
    private String sfAppSecret;
    @Autowired
    private SfLocalOrderMapper sfLocalOrderMapper;

    public int insert(SfLocalOrder entity) {
        return this.sfLocalOrderMapper.insert(entity);
    }

    public void deleteById(Long id) {
        this.sfLocalOrderMapper.deleteByPrimaryKey(id);
    }

    public void updateByPrimaryKeySelective(SfLocalOrder entity) {
        this.sfLocalOrderMapper.updateByPrimaryKeySelective(entity);
    }

    public SfLocalOrder selectByPrimaryKey(Long id) {
        return this.sfLocalOrderMapper.selectByPrimaryKey(id);
    }

    public PreCreateOrderRespVO prCreateOrder(SflPrCreateOrderReqVO sflPrCreateOrderReqVO) {
        PreCreateOrderReqVO preCreateOrderReqVO = new PreCreateOrderReqVO();
        BeanUtils.copyProperties((Object)sflPrCreateOrderReqVO, (Object)preCreateOrderReqVO);
        PreCreateOrderRespVO preCreateOrderRespVO = SFRequestHelper.preCreateOrder((PreCreateOrderReqVO)preCreateOrderReqVO, (String)this.sfAppId, (String)this.sfAppSecret);
        return preCreateOrderRespVO;
    }

    public CancelOrderRespVO cancelOrder(SflCancelOrderReqVO sflCancelOrderReqVO) {
        CancelOrderReqVO cancelOrderReqVO = new CancelOrderReqVO();
        BeanUtils.copyProperties((Object)sflCancelOrderReqVO, (Object)cancelOrderReqVO);
        CancelOrderRespVO cancelOrderRespVO = SFRequestHelper.cancelOrder((CancelOrderReqVO)cancelOrderReqVO, (String)this.sfAppId, (String)this.sfAppSecret);
        return cancelOrderRespVO;
    }

    public ListOrderFeedRespVO listOrderFeed(SflListOrderFeedReqVO sflListOrderFeedReqVO) {
        ListOrderFeedReqVO listOrderFeedReqVO = new ListOrderFeedReqVO();
        BeanUtils.copyProperties((Object)sflListOrderFeedReqVO, (Object)listOrderFeedReqVO);
        ListOrderFeedRespVO listOrderFeedRespVO = SFRequestHelper.listOrderFeed((ListOrderFeedReqVO)listOrderFeedReqVO, (String)this.sfAppId, (String)this.sfAppSecret);
        return listOrderFeedRespVO;
    }

    public GetCallbackInfoRespVO getCallbackInfo(SflGetCallbackInfoReqVO sflGetCallbackInfoReqVO) {
        GetCallbackInfoReqVO getCallbackInfoReqVO = new GetCallbackInfoReqVO();
        BeanUtils.copyProperties((Object)sflGetCallbackInfoReqVO, (Object)getCallbackInfoReqVO);
        GetCallbackInfoRespVO getCallbackInfoRespVO = SFRequestHelper.getCallbackInfo((GetCallbackInfoReqVO)getCallbackInfoReqVO, (String)this.sfAppId, (String)this.sfAppSecret);
        return getCallbackInfoRespVO;
    }

    public CreateOrderRespVO createOrder(SflCreateOrderReqVO sflCreateOrderReqVO) {
        Long merchantId = sflCreateOrderReqVO.getMerchant_id();
        CreateOrderReqVO createOrderReqVO = new CreateOrderReqVO();
        BeanUtils.copyProperties((Object)sflCreateOrderReqVO, (Object)createOrderReqVO);
        CreateOrderRespVO createOrderRespVO = SFRequestHelper.createOrder((CreateOrderReqVO)createOrderReqVO, (String)this.sfAppId, (String)this.sfAppSecret);
        if (createOrderRespVO == null) {
            return null;
        }
        try {
            SfLocalOrder sfLocalOrder = new SfLocalOrder();
            sfLocalOrder.setViewId(UUIDUtil.getUUID());
            sfLocalOrder.setStatus(Integer.valueOf(1));
            sfLocalOrder.setMerchantId(merchantId);
            sfLocalOrder.setSfOrderId(createOrderRespVO.getResult().getSf_order_id());
            String reqJsonStr = JSON.toJSONString((Object)sflCreateOrderReqVO);
            sfLocalOrder.setRequest(reqJsonStr);
            String respJsonStr = JSON.toJSONString((Object)createOrderRespVO);
            sfLocalOrder.setResponse(respJsonStr);
            this.insert(sfLocalOrder);
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        return createOrderRespVO;
    }

    public SfLocalOrder getBySfOrderId(String sfOrderId) {
        return this.sfLocalOrderMapper.getBySfOrderId(sfOrderId);
    }
}

