/*
 * Decompiled with CFR 0.152.
 */
package com.byh.util;

import com.alibaba.fastjson.JSON;
import com.byh.exception.AuthException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class BYSignUtil {
    private static final Logger log = LoggerFactory.getLogger(BYSignUtil.class);
    private static final String AND = "&";
    private static final String EQUAL = "=";

    public static String getSignature(Map<String, String> reqMap, String key) throws Exception {
        String data = BYSignUtil.getSortedParamStr(reqMap);
        String signature = BYSignUtil.getHMAC((byte[])data.getBytes(), (byte[])key.getBytes(), (String)"HmacSHA256");
        return signature;
    }

    public static void checkSign(Map<String, String> reqMap, String key) throws Exception {
        long reqTime;
        String jsonString = JSON.toJSONString(reqMap);
        log.info("jsonString = " + jsonString);
        String timestamp = reqMap.get("timestamp");
        if (timestamp == null || "".equals(timestamp)) {
            throw new AuthException("\u9274\u6743\u65f6\u95f4\u6233\u7f3a\u5931");
        }
        long currentTimeMillis = System.currentTimeMillis() / 1000L;
        if (currentTimeMillis + 1000L < (reqTime = Long.parseLong(timestamp))) {
            log.info("currentTimeMillis = " + currentTimeMillis);
            log.info("reqTime = " + reqTime);
            throw new AuthException("\u65f6\u95f4\u6233\u9700\u8981\u7cbe\u786e\u5230\u79d2\uff01");
        }
        if (Math.abs(currentTimeMillis - reqTime) > 300000L) {
            log.info("currentTimeMillis\uff1a" + currentTimeMillis);
            log.info("reqTime\uff1a" + reqTime);
            throw new AuthException("\u7b7e\u540d\u5df2\u7ecf\u8fc7\u671f");
        }
        String sign = reqMap.get("sign");
        if (sign == null || "".equals(sign)) {
            throw new AuthException("\u7b7e\u540d\u4e3a\u7a7a");
        }
        String cSign = BYSignUtil.getSignature(reqMap, (String)key);
        if (!cSign.equals(sign)) {
            throw new AuthException("\u7b7e\u540d\u9519\u8bef");
        }
    }

    private static String getSortedParamStr(Map<String, String> props) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(props.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = props.get(key);
            if (value == null || "sign".equals(key)) continue;
            if (i == props.size() - 1) {
                sb.append(key).append("=").append((Object)value);
                continue;
            }
            sb.append(key).append("=").append((Object)value).append("&");
        }
        return sb.toString();
    }

    private static String getHMAC(byte[] data, byte[] key, String HmacAlgo) throws Exception {
        SecretKeySpec signingKey = new SecretKeySpec(key, HmacAlgo);
        Mac mac = Mac.getInstance(HmacAlgo);
        mac.init(signingKey);
        return new String(Base64.getEncoder().encode(mac.doFinal(data)));
    }
}

