/*
 * Decompiled with CFR 0.152.
 */
package com.byh.util.sfmedical;

import com.byh.util.sfmedical.HttpClientUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class HttpClientUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtils.class);
    private static int PROXY_PORT = 443;
    private static final int MAX_TOTAL_CONNECTIONS = 4000;
    private static final int DEFAULT_MAX_PER_ROUTE = 200;
    private static final int REQUEST_CONNECTION_TIMEOUT = 8000;
    private static final int REQUEST_SOCKET_TIMEOUT = 8000;
    private static final int REQUEST_CONNECTION_REQUEST_TIMEOUT = 5000;
    private static final int VALIDATE_AFTER_IN_ACTIVITY = 2000;
    private static final int SOCKET_CONFIG_SO_TIMEOUT = 5000;
    private static final int RETRY_COUNT = 5;
    private static volatile CloseableHttpClient httpClient = null;

    public void setProxyPort(int port) {
        PROXY_PORT = port;
    }

    HttpClientUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String uri) {
        String responseBody;
        HttpGet httpGet = new HttpGet(uri);
        try {
            httpGet.setConfig(HttpClientUtils.getRequestConfig());
            responseBody = HttpClientUtils.executeRequest((HttpUriRequest)httpGet);
        }
        catch (IOException e) {
            log.error("httpclient doGet\u65b9\u6cd5\u5f02\u5e38{}", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            httpGet.releaseConnection();
        }
        return responseBody;
    }

    public static String doGet(String uri, Map<String, String> params) {
        return HttpClientUtils.doGet((String)HttpClientUtils.getGetUrlFromParams((String)uri, params));
    }

    private static String getGetUrlFromParams(String uri, Map<String, String> params) {
        List resultList = params.entrySet().stream().map(innerEntry -> new BasicNameValuePair((String)innerEntry.getKey(), (String)innerEntry.getValue())).collect(Collectors.toList());
        String paramSectionOfUrl = URLEncodedUtils.format(resultList, (Charset)Consts.UTF_8);
        StringBuilder resultUrl = new StringBuilder(uri);
        if (StringUtils.isEmpty((CharSequence)uri)) {
            return uri;
        }
        if (!StringUtils.isEmpty((CharSequence)paramSectionOfUrl)) {
            if (uri.endsWith("?")) {
                resultUrl.append(paramSectionOfUrl);
            } else {
                resultUrl.append("?").append(paramSectionOfUrl);
            }
        }
        return resultUrl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String uri, Map<String, String> params) {
        String responseBody;
        HttpPost httpPost = new HttpPost(uri);
        try {
            ArrayList nvps = Lists.newArrayList();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                nvps.add(new BasicNameValuePair(key, value));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity((Iterable)nvps, Consts.UTF_8));
            httpPost.setConfig(HttpClientUtils.getRequestConfig());
            responseBody = HttpClientUtils.executeRequest((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            log.error("httpclient doPost\u65b9\u6cd5\u5f02\u5e38{}", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            httpPost.releaseConnection();
        }
        return responseBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostWithProxy(String uri, String param, ContentType contentType, String proxyUrl) {
        String responseBody;
        log.info("\u4ee3\u7406\uff1aproxyUrl:{} proxyPort:{}", (Object)proxyUrl, (Object)PROXY_PORT);
        RequestConfig requestConfig = HttpClientUtils.getRequestConfig();
        HttpHost proxy = new HttpHost(proxyUrl, PROXY_PORT, "http");
        requestConfig = RequestConfig.copy((RequestConfig)requestConfig).setProxy(proxy).build();
        HttpPost httpPost = new HttpPost(uri);
        try {
            StringEntity reqEntity = new StringEntity(param, contentType);
            httpPost.setEntity((HttpEntity)reqEntity);
            httpPost.setConfig(requestConfig);
            responseBody = HttpClientUtils.executeRequest((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            log.error("httpclient doPost\u65b9\u6cd5\u5f02\u5e38{}", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            httpPost.releaseConnection();
        }
        return responseBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String uri, String param, ContentType contentType) {
        String responseBody;
        HttpPost httpPost = new HttpPost(uri);
        try {
            StringEntity reqEntity = new StringEntity(param, contentType);
            httpPost.setEntity((HttpEntity)reqEntity);
            httpPost.setConfig(HttpClientUtils.getRequestConfig());
            responseBody = HttpClientUtils.executeRequest((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            log.error("httpclient doPost\u65b9\u6cd5\u5f02\u5e38{}", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            httpPost.releaseConnection();
        }
        return responseBody;
    }

    private static RequestConfig getRequestConfig() {
        RequestConfig defaultRequestConfig = RequestConfig.custom().setExpectContinueEnabled(true).build();
        return RequestConfig.copy((RequestConfig)defaultRequestConfig).setSocketTimeout(8000).setConnectTimeout(8000).setConnectionRequestTimeout(5000).build();
    }

    private static String executeRequest(HttpUriRequest method) throws IOException {
        1 responseHandler = new /* Unavailable Anonymous Inner Class!! */;
        return (String)HttpClientUtils.getHttpClientInstance().execute(method, (ResponseHandler)responseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CloseableHttpClient getHttpClientInstance() {
        if (httpClient != null) return httpClient;
        Class<CloseableHttpClient> clazz = CloseableHttpClient.class;
        synchronized (CloseableHttpClient.class) {
            if (httpClient != null) return httpClient;
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)HttpClientUtils.initConfig()).setRetryHandler(HttpClientUtils.getRetryHandler()).build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpClient;
        }
    }

    private static HttpRequestRetryHandler getRetryHandler() {
        return (exception, executionCount, context) -> {
            if (executionCount >= 5) {
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                return true;
            }
            if (exception instanceof SSLHandshakeException) {
                return false;
            }
            if (exception instanceof InterruptedIOException) {
                return false;
            }
            if (exception instanceof UnknownHostException) {
                return false;
            }
            if (exception instanceof SSLException) {
                return false;
            }
            HttpRequest request = HttpClientContext.adapt((HttpContext)context).getRequest();
            return !(request instanceof HttpEntityEnclosingRequest);
        };
    }

    private static PoolingHttpClientConnectionManager initConfig() {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            2 tm = new /* Unavailable Anonymous Inner Class!! */;
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)ssf).build();
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoReuseAddress(true).setSoTimeout(5000).build();
            connManager.setDefaultSocketConfig(socketConfig);
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).build();
            connManager.setDefaultConnectionConfig(connectionConfig);
            connManager.setDefaultMaxPerRoute(200);
            connManager.setMaxTotal(4000);
            return connManager;
        }
        catch (Exception e) {
            log.error("\u8bc1\u4e66\u9519\u8bef", (Throwable)e);
            return null;
        }
    }
}

