/*
 * Decompiled with CFR 0.152.
 */
package com.byh.util.sfmedical;

import com.alibaba.fastjson.JSONObject;
import com.byh.exception.BusinessException;
import com.byh.pojo.dto.OpenApiAddressVO;
import com.byh.pojo.dto.OrderThirdRequestVO;
import com.byh.util.sfmedical.HttpClientUtils;
import com.byh.util.sfmedical.SFConfig;
import com.byh.util.sfmedical.SHAUtils;
import com.byh.util.sfmedical.vo.req.BatchAddOrderReqVO;
import com.byh.util.sfmedical.vo.req.CancelThirdOrderReqVO;
import com.byh.util.sfmedical.vo.req.FreightQueryReqVO;
import com.byh.util.sfmedical.vo.req.ListOrderRouteReqVO;
import com.byh.util.sfmedical.vo.req.SieveOrderReqVO;
import com.byh.util.sfmedical.vo.resp.BatchAddOrderRespVO;
import com.byh.util.sfmedical.vo.resp.CancelThirdOrderRespVO;
import com.byh.util.sfmedical.vo.resp.FreightQueryRespVO;
import com.byh.util.sfmedical.vo.resp.ListOrderRouteRespVO;
import com.byh.util.sfmedical.vo.resp.SieveOrderRespVO;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFMedicalRequestHelper {
    private static final Logger log = LoggerFactory.getLogger(SFMedicalRequestHelper.class);

    public static SieveOrderRespVO sieveOrder(SieveOrderReqVO sieveOrderReqVO) {
        String srcAddress = sieveOrderReqVO.getSrcAddress();
        String destAddress = sieveOrderReqVO.getDestAddress();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String sign = SHAUtils.SHA512((String)(srcAddress + destAddress + sieveOrderReqVO.getSecretKey()));
        if (sign == null || "".equals(sign)) {
            throw new BusinessException("\u987a\u901a\u76f4\u8fde\u8ba2\u5355\u7b5b\u9009\u7b7e\u540d\u9519\u8bef\uff01");
        }
        map.put("sign", sign);
        map.put("hospitalCode", sieveOrderReqVO.getHospitalCode());
        map.put("srcAddress", srcAddress);
        map.put("destAddress", destAddress);
        map.put("timestamp", "4070916000000");
        map.put("version", SFConfig.VERSION);
        String respResult = null;
        try {
            log.info("url={}, param={}", (Object)SFConfig.SIEVE_ORDER, (Object)((Object)map).toString());
            respResult = HttpClientUtils.doGet((String)SFConfig.SIEVE_ORDER, map);
            log.info("respResult={}", (Object)respResult);
            if (respResult == null || "".equals(respResult)) {
                return null;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("sieveOrder\u63a5\u53e3\u8c03\u7528\u5931\u8d25 \u7f51\u7edc\u9519\u8bef");
        }
        Gson gson = new Gson();
        SieveOrderRespVO sieveOrderRespVO = (SieveOrderRespVO)gson.fromJson(respResult, SieveOrderRespVO.class);
        return sieveOrderRespVO;
    }

    public static FreightQueryRespVO freightQuery(FreightQueryReqVO freightQueryReqVO) {
        String hospitalCode = freightQueryReqVO.getHospitalCode();
        String secretKey = freightQueryReqVO.getSecretKey();
        OpenApiAddressVO openApiAddressVO = freightQueryReqVO.getOpenApiAddressVO();
        String jsonStr = JSONObject.toJSONString((Object)openApiAddressVO);
        String sign = SHAUtils.SHA512((String)(jsonStr + secretKey));
        if (sign == null || "".equals(sign)) {
            throw new BusinessException("\u987a\u4e30\u65f6\u6548\u8fd0\u8d39\u67e5\u8be2 \u7b7e\u540d\u9519\u8bef\uff01");
        }
        StringBuffer urlBuff = new StringBuffer(SFConfig.FREIGHT_QUERY);
        String timestamp = String.valueOf(4070916000000L);
        urlBuff.append("?sign=" + sign).append("&timestamp=4070916000000").append("&hospitalCode=" + hospitalCode).append("&version=" + SFConfig.VERSION);
        String respResult = null;
        try {
            log.info("url->{}, param->{}", (Object)urlBuff.toString(), (Object)jsonStr);
            respResult = HttpClientUtils.doPost((String)urlBuff.toString(), (String)jsonStr, (ContentType)ContentType.APPLICATION_JSON);
            log.info("respResult={}", (Object)respResult);
            if (respResult == null || "".equals(respResult)) {
                return null;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("\u987a\u4e30\u65f6\u6548\u8fd0\u8d39\u67e5\u8be2 \u63a5\u53e3\u8c03\u7528\u5931\u8d25 \u7f51\u7edc\u9519\u8bef");
        }
        Gson gson = new Gson();
        FreightQueryRespVO freightQueryRespVO = (FreightQueryRespVO)gson.fromJson(respResult, FreightQueryRespVO.class);
        return freightQueryRespVO;
    }

    public static BatchAddOrderRespVO batchAddOrder(BatchAddOrderReqVO batchAddOrderReqVO) {
        String hospitalCode = batchAddOrderReqVO.getHospitalCode();
        String secretKey = batchAddOrderReqVO.getSecretKey();
        OrderThirdRequestVO orderThirdRequestVO = batchAddOrderReqVO.getOrderThirdRequestVO();
        String jsonStr = JSONObject.toJSONString((Object)orderThirdRequestVO);
        String sign = SHAUtils.SHA512((String)(jsonStr + secretKey));
        if (sign == null || "".equals(sign)) {
            throw new BusinessException("\u987a\u4e30\u76f4\u8fde\u6279\u91cf\u4e0b\u5355 \u7b7e\u540d\u9519\u8bef\uff01");
        }
        StringBuffer urlBuff = new StringBuffer(SFConfig.ADD_ORDER);
        String timestamp = String.valueOf(System.currentTimeMillis());
        urlBuff.append("?sign=" + sign).append("&timestamp=4070916000000").append("&hospitalCode=" + hospitalCode).append("&version=" + SFConfig.VERSION);
        String respResult = null;
        try {
            log.info("url->{}, param->{}", (Object)urlBuff.toString(), (Object)jsonStr);
            respResult = HttpClientUtils.doPost((String)urlBuff.toString(), (String)jsonStr, (ContentType)ContentType.APPLICATION_JSON);
            log.info("respResult={}", (Object)respResult);
            if (respResult == null || "".equals(respResult)) {
                return null;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("\u987a\u4e30\u76f4\u8fde\u6279\u91cf\u4e0b\u5355 \u63a5\u53e3\u8c03\u7528\u5931\u8d25 \u7f51\u7edc\u9519\u8bef");
        }
        Gson gson = new Gson();
        BatchAddOrderRespVO batchAddOrderRespVO = (BatchAddOrderRespVO)gson.fromJson(respResult, BatchAddOrderRespVO.class);
        return batchAddOrderRespVO;
    }

    public static CancelThirdOrderRespVO cancelThirdOrder(CancelThirdOrderReqVO cancelThirdOrderReqVO) {
        String hospitalCode = cancelThirdOrderReqVO.getHospitalCode();
        String secretKey = cancelThirdOrderReqVO.getSecretKey();
        String orderNo = cancelThirdOrderReqVO.getOrderNo();
        String sign = SHAUtils.SHA512((String)(orderNo + secretKey));
        if (sign == null || "".equals(sign)) {
            throw new BusinessException("\u987a\u4e30\u76f4\u8fde\u53d6\u6d88\u4e0b\u5355 \u7b7e\u540d\u9519\u8bef\uff01");
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("hospitalCode", hospitalCode);
        map.put("sign", sign);
        map.put("orderNo", orderNo);
        String timestamp = String.valueOf(System.currentTimeMillis());
        map.put("timestamp", "4070916000000");
        map.put("version", SFConfig.VERSION);
        String respResult = null;
        try {
            log.info("url->{}, param->{}", (Object)SFConfig.CANCEL_THIRD_ORDER, (Object)((Object)map).toString());
            respResult = HttpClientUtils.doGet((String)SFConfig.CANCEL_THIRD_ORDER, map);
            log.info("result->{}", (Object)respResult);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("\u987a\u4e30\u76f4\u8fde\u53d6\u6d88\u4e0b\u5355 \u63a5\u53e3\u8c03\u7528\u5931\u8d25 \u7f51\u7edc\u9519\u8bef");
        }
        Gson gson = new Gson();
        CancelThirdOrderRespVO cancelThirdOrderRespVO = (CancelThirdOrderRespVO)gson.fromJson(respResult, CancelThirdOrderRespVO.class);
        return cancelThirdOrderRespVO;
    }

    public static ListOrderRouteRespVO listOrderRoute(ListOrderRouteReqVO listOrderRouteReqVO) {
        String hospitalCode = listOrderRouteReqVO.getHospitalCode();
        String secretKey = listOrderRouteReqVO.getSecretKey();
        String orderNo = listOrderRouteReqVO.getOrderNo();
        String sign = SHAUtils.SHA512((String)(orderNo + secretKey));
        if (sign == null || "".equals(sign)) {
            throw new BusinessException("\u987a\u4e30\u76f4\u8fde\u8def\u7531\u67e5\u8be2 \u7b7e\u540d\u9519\u8bef\uff01");
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("hospitalCode", hospitalCode);
        map.put("sign", sign);
        map.put("orderNo", orderNo);
        map.put("timestamp", "4070916000000");
        map.put("version", SFConfig.VERSION);
        String respResult = null;
        try {
            log.info("url->{}, param->{}", (Object)SFConfig.LIST_ORDER_ROUTE, (Object)((Object)map).toString());
            respResult = HttpClientUtils.doGet((String)SFConfig.LIST_ORDER_ROUTE, map);
            log.info("result->{}", (Object)respResult);
            if (respResult == null || "".equals(respResult)) {
                return null;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("\u987a\u4e30\u76f4\u8fde\u8def\u7531\u67e5\u8be2 \u63a5\u53e3\u8c03\u7528\u5931\u8d25 \u7f51\u7edc\u9519\u8bef");
        }
        Gson gson = new Gson();
        ListOrderRouteRespVO listOrderRouteRespVO = (ListOrderRouteRespVO)gson.fromJson(respResult, ListOrderRouteRespVO.class);
        return listOrderRouteRespVO;
    }
}

