/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.QueryOutpatientTypeDto;
import com.byh.outpatient.api.model.outpatienType.OutpatientTypeEntity;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.aspect.UserOptLogger;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutpatientTypeService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outpatientType"})
public class OutpatientTypeController {
    @Autowired
    private OutpatientTypeService outpatientTypeService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/selectListByDeptId"})
    @ApiOperation(value="\u6839\u636e\u79d1\u5ba4\u7f16\u53f7\u67e5\u8be2\u5bf9\u5e94\u7684\u95e8\u8bca\u7c7b\u578b\u5217\u8868\u4fe1\u606f")
    public ResponseData selectListByDeptId(@RequestBody QueryOutpatientTypeDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.outpatientTypeService.selectListByDeptId(dto));
    }

    @UserOptLogger(operation="\u65b0\u589e\u95e8\u8bca\u7c7b\u578b")
    @PostMapping(value={"/insert"})
    @ApiOperation(value="\u65b0\u589e\u95e8\u8bca\u7c7b\u578b", httpMethod="POST", notes="\u65b0\u589e\u95e8\u8bca\u7c7b\u578b")
    public ResponseData insert(@RequestBody OutpatientTypeEntity outpatientType) {
        Integer tenantId = this.commonRequest.getTenant();
        outpatientType.setTenantId(tenantId);
        return this.outpatientTypeService.insert(outpatientType);
    }

    @UserOptLogger(operation="\u4fee\u6539\u95e8\u8bca\u7c7b\u578b\u72b6\u6001")
    @GetMapping(value={"/updateStatus"})
    @ApiOperation(value="\u4fee\u6539\u95e8\u8bca\u7c7b\u578b\u72b6\u6001 0:\u5220\u9664\uff0c1\uff1a\u6b63\u5e38\uff0c2:\u505c\u7528", httpMethod="GET", notes="\u4fee\u6539\u95e8\u8bca\u7c7b\u578b\u72b6\u6001")
    public ResponseData updateStatus(@RequestParam(value="id", required=true) Integer id, @RequestParam(value="status", required=true) String status) {
        return this.outpatientTypeService.updateStatus(id, status);
    }

    @UserOptLogger(operation="\u4fee\u6539\u95e8\u8bca\u7c7b\u578b")
    @PostMapping(value={"/updateById"})
    @ApiOperation(value="\u4fee\u6539\u95e8\u8bca\u7c7b\u578b", httpMethod="POST", notes="\u4fee\u6539\u95e8\u8bca\u7c7b\u578b")
    public ResponseData updateById(@RequestBody OutpatientTypeEntity outpatientType) {
        Integer tenantId = this.commonRequest.getTenant();
        outpatientType.setTenantId(tenantId);
        return this.outpatientTypeService.updateById(outpatientType);
    }

    @GetMapping(value={"/queryById"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952e id \u67e5\u8be2\u95e8\u8bca\u7c7b\u578b", httpMethod="GET", notes="\u6839\u636e\u4e3b\u952e id \u67e5\u8be2\u95e8\u8bca\u7c7b\u578b")
    public ResponseData<OutpatientTypeEntity> queryById(@RequestParam(value="id", required=true) Integer id) {
        return this.outpatientTypeService.queryById(id);
    }

    @PostMapping(value={"/queryOutpatientType"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u95e8\u8bca\u7c7b\u578b", httpMethod="POST", notes="\u5206\u9875\u67e5\u8be2\u95e8\u8bca\u7c7b\u578b")
    public ResponseData<PageResult<OutpatientTypeEntity>> queryOutpatientType(@RequestBody @Valid QueryOutpatientTypeDto queryOutpatientTypeDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Integer tenantId = this.commonRequest.getTenant();
        queryOutpatientTypeDto.setTenantId(tenantId);
        return this.outpatientTypeService.queryOutpatientType(queryOutpatientTypeDto);
    }

    @PostMapping(value={"/queryOutpatientTypeByName"})
    @ApiOperation(value="\u67e5\u8be2 \u6839\u636e\u95e8\u8bca\u540d\u79f0\u67e5\u8be2", httpMethod="POST", notes="\u67e5\u8be2 \u6839\u636e\u95e8\u8bca\u540d\u79f0\u67e5\u8be2")
    public ResponseData<List<OutpatientTypeEntity>> queryOutpatientTypeByName(@RequestBody @Valid QueryOutpatientTypeDto queryOutpatientTypeDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Integer tenantId = this.commonRequest.getTenant();
        queryOutpatientTypeDto.setTenantId(tenantId);
        return this.outpatientTypeService.queryOutpatientTypeByName(queryOutpatientTypeDto);
    }
}

