/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.outpatient.api.hsModel.request.GetSettlementInfoRequest;
import com.byh.outpatient.api.hsModel.respones.HsBaseResponse;
import com.byh.outpatient.api.model.hsSettlement.HsSettlementInfoEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.data.repository.OutHsSettlementInfoMapper;
import com.byh.outpatient.web.feign.HsServiceFeign;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hsDise"})
public class HsDiseAddController {
    private static final Logger log = LoggerFactory.getLogger(HsDiseAddController.class);
    @Autowired
    NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    @Autowired
    HsServiceFeign hsServiceFeign;
    @Autowired
    OutHsSettlementInfoMapper outHsSettlementInfoMapper;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u6162\u75c5\u75c5\u79cd")
    public ResponseData add() {
        String sql = "SELECT\n   t1.*\nFROM\n    out_hs_settlement_info t1\nWHERE\n    t1.setl_time BETWEEN '2025-01-01 00:00:00' AND '2025-01-31 23:59:59'\n    and dise_codg is null\n    and med_type = '14'";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        List inpatFees = this.namedParameterJdbcTemplate.queryForList(sql, (SqlParameterSource)parameters);
        log.info("\u67e5\u8be2\u5230\u7ed3\u7b97\u660e\u7ec6\u5982\u4e0b: " + JSON.toJSONString((Object)inpatFees));
        ArrayList success = new ArrayList();
        ArrayList error = new ArrayList();
        HashMap map = new HashMap();
        int threadPoolSize = 10;
        ExecutorService executor = Executors.newFixedThreadPool(threadPoolSize);
        ArrayList<Future<Map>> futures = new ArrayList<Future<Map>>();
        int chunkSize = (inpatFees.size() + threadPoolSize - 1) / threadPoolSize;
        for (int i = 0; i < inpatFees.size(); i += chunkSize) {
            int n = Math.min(i + chunkSize, inpatFees.size());
            List chunk = inpatFees.subList(i, n);
            futures.add(executor.submit(() -> this.processChunk(chunk)));
        }
        for (Future future : futures) {
            try {
                Map result = (Map)future.get();
                success.addAll((Collection)result.get("success"));
                error.addAll((Collection)result.get("error"));
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("\u5904\u7406\u5931\u8d25", (Throwable)e);
            }
        }
        executor.shutdown();
        map.put("success", success);
        map.put("error", error);
        String info = "";
        for (String s : error) {
            info = info + "'" + s + "',";
        }
        System.out.println("\u6ca1\u6709\u7684\u53c2\u6570:" + info);
        return ResponseData.success(map);
    }

    private Map<String, List<String>> processChunk(List<Map<String, Object>> chunk) {
        ArrayList<String> success = new ArrayList<String>();
        ArrayList<String> error = new ArrayList<String>();
        for (Map<String, Object> item : chunk) {
            JSONObject jsonObj = JSON.parseObject((String)JSON.toJSONString(item));
            Integer id = jsonObj.getInteger("id");
            String psnNo = jsonObj.getString("psn_no");
            String mdtrtId = jsonObj.getString("mdtrt_id");
            String setlId = jsonObj.getString("setl_id");
            String insuplcAdmdvs = jsonObj.getString("insuplc_admdvs");
            Integer tenantId = jsonObj.getInteger("tenant_id");
            GetSettlementInfoRequest getSettlementInfoRequest = new GetSettlementInfoRequest();
            getSettlementInfoRequest.setPsn_no(psnNo);
            getSettlementInfoRequest.setMdtrt_id(mdtrtId);
            getSettlementInfoRequest.setSetl_id(setlId);
            getSettlementInfoRequest.setSign_no("99999");
            getSettlementInfoRequest.setOpter("1");
            getSettlementInfoRequest.setOpter_name("\u8d85\u7ba1");
            getSettlementInfoRequest.setOpter_type("1");
            getSettlementInfoRequest.setInsuplc_admdvs(insuplcAdmdvs);
            getSettlementInfoRequest.setTenantId(tenantId);
            log.info("\u8c03\u7528\u533b\u4fdd\u67e5\u8be2\u7ed3\u7b97\u4fe1\u606f\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)getSettlementInfoRequest));
            ResponseData hsBaseResponseResponseData = this.hsServiceFeign.settlementInfo(getSettlementInfoRequest);
            if (hsBaseResponseResponseData != null && hsBaseResponseResponseData.isSuccess() && hsBaseResponseResponseData.getData() != null) {
                JSONObject jsonObject = (JSONObject)((HsBaseResponse)hsBaseResponseResponseData.getData()).getOutput();
                if (jsonObject.getJSONObject("setlinfo") == null || jsonObject.getJSONObject("setlinfo").isEmpty()) {
                    log.error("\u672a\u627e\u5230\u7ed3\u7b97\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)getSettlementInfoRequest));
                    error.add(setlId);
                    continue;
                }
                Object object = jsonObject.get((Object)"setlinfo");
                LinkedHashMap linkedHashMap = (LinkedHashMap)object;
                String dise_code = linkedHashMap.get("dise_code") == null ? "0" : linkedHashMap.get("dise_code").toString();
                String dise_name = linkedHashMap.get("dise_name") == null ? "0" : linkedHashMap.get("dise_name").toString();
                log.info("\u60a3\u8005\u59d3\u540d\uff1a{},\u7ed3\u7b97id\uff1a{}\uff0c\u7ed3\u7b97\u91d1\u989d\uff1a{}\uff0c\u75c5\u79cd\u7f16\u7801:{}\uff0c\u75c5\u79cd\u540d\u79f0:{}", new Object[]{linkedHashMap.get("psn_name"), setlId, jsonObj.getBigDecimal("medfee_sumamt"), dise_code, dise_name});
                HsSettlementInfoEntity hsSettlementInfoEntity = new HsSettlementInfoEntity();
                hsSettlementInfoEntity.setId(id);
                hsSettlementInfoEntity.setDise_codg(dise_code);
                hsSettlementInfoEntity.setDise_name(dise_name);
                this.outHsSettlementInfoMapper.updateById((Object)hsSettlementInfoEntity);
                success.add(setlId);
                continue;
            }
            log.error("\u672a\u627e\u5230\u7ed3\u7b97\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)getSettlementInfoRequest));
            error.add(setlId);
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        result.put("success", success);
        result.put("error", error);
        return result;
    }
}

