/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.model.OutVisitVideoEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutVisitVideoService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/visitVideo"})
public class OutVisitVideoController {
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private OutVisitVideoService outVisitVideoService;

    @PostMapping(value={"/pageListByPatientId"})
    private ResponseData<PageInfo<OutVisitVideoEntity>> pageListByPatientId(@RequestBody OutVisitVideoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        Integer patientId = entity.getPatientId();
        if (patientId == null) {
            return ResponseData.error((String)"\u60a3\u8005id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.outVisitVideoService.pageListByPatientId(entity);
    }

    @PostMapping(value={"/pageListByPatientIdAndVisitTime"})
    private ResponseData<PageInfo<OutVisitVideoEntity>> pageListByPatientIdAndVisitTime(@RequestBody OutVisitVideoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        return this.outVisitVideoService.pageListByPatientIdAndVisitTime(entity);
    }

    @PostMapping(value={"/add"})
    private ResponseData add(@RequestBody OutVisitVideoEntity entity) {
        Integer userId = this.commonRequest.getUserId();
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        entity.setCreateId(userId);
        Integer patientId = entity.getPatientId();
        String visitTime = entity.getVisitTime();
        ArrayList<String> videoUrlList = entity.getVideoUrlList();
        if (patientId == null || StringUtil.isBlank((String)visitTime)) {
            return ResponseData.error((String)"\u5fc5\u8981\u53c2\u6570\u7f3a\u5931");
        }
        if (videoUrlList == null || videoUrlList.size() == 0) {
            videoUrlList = new ArrayList<String>();
            videoUrlList.add(" ");
        }
        return this.outVisitVideoService.add(entity);
    }

    @PostMapping(value={"del"})
    private ResponseData del(@RequestBody OutVisitVideoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        Integer id = entity.getId();
        if (id == null) {
            return ResponseData.error((String)"id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return this.outVisitVideoService.del(entity);
    }
}

