/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.medicalRecord.OutpatientInfomationDto;
import com.byh.outpatient.api.dto.prescription.OutPrescriptionDto;
import com.byh.outpatient.api.dto.prescription.QueryOutMedicationListDto;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.vo.prescription.QueryMedicationVo;
import com.byh.outpatient.api.vo.prescription.QueryOutMedicationListVo;
import com.byh.outpatient.api.vo.prescription.QueryOutpatientDispensedVo;
import com.byh.outpatient.api.vo.prescription.QueryVisitInformationVo;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutMedicalRecordService;
import com.byh.outpatient.web.service.OutPrescriptionService;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outpatientDrug"})
public class OutpatientDrugController {
    @Resource
    private OutMedicalRecordService outMedicalRecordService;
    @Resource
    private OutPrescriptionService outPrescriptionService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/v1/queryOutMedicationList"})
    @Operation(description="\u67e5\u8be2\u95e8\u8bca\u53d1\u836f\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u95e8\u8bca\u53d1\u836f\u5217\u8868", httpMethod="POST", notes="\u67e5\u8be2\u95e8\u8bca\u53d1\u836f\u5217\u8868")
    public ResponseData<PageResult<QueryOutMedicationListVo>> queryOutMedicationList(@RequestBody @Valid QueryOutMedicationListDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        if (StringUtil.isBlank((String)parameter.getWarehouse())) {
            parameter.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPrescriptionService.queryOutMedicationList(parameter);
    }

    @PostMapping(value={"/v1/queryOutpatientDispensed"})
    @Operation(description="\u67e5\u8be2\u95e8\u8bca\u53d1\u836f\u6570\u91cf")
    @ApiOperation(value="\u67e5\u8be2\u95e8\u8bca\u53d1\u836f\u6570\u91cf", httpMethod="POST", notes="\u67e5\u8be2\u95e8\u8bca\u53d1\u836f\u6570\u91cf")
    public ResponseData<QueryOutpatientDispensedVo> queryOutpatientDispensed(@RequestBody @Valid QueryOutMedicationListDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        if (StringUtil.isBlank((String)parameter.getWarehouse())) {
            parameter.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPrescriptionService.queryOutpatientDispensed(parameter);
    }

    @PostMapping(value={"/v1/queryVisitInformation"})
    @Operation(description="\u67e5\u8be2\u5c31\u8bca\u4fe1\u606f")
    @ApiOperation(value="\u67e5\u8be2\u5c31\u8bca\u4fe1\u606f", httpMethod="POST", notes="\u67e5\u8be2\u5c31\u8bca\u4fe1\u606f")
    public ResponseData<QueryVisitInformationVo> queryVisitInformation(@RequestBody @Valid OutpatientInfomationDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outMedicalRecordService.queryVisitInformation(parameter);
    }

    @PostMapping(value={"/v1/queryMedicationDetails"})
    @Operation(description="\u6839\u636e\u95e8\u8bca\u53f7\u67e5\u8be2\u53d1\u836f\u8be6\u60c5")
    @ApiOperation(value="\u6839\u636e\u95e8\u8bca\u53f7\u67e5\u8be2\u53d1\u836f\u8be6\u60c5", httpMethod="POST", notes="\u6839\u636e\u95e8\u8bca\u53f7\u67e5\u8be2\u53d1\u836f\u8be6\u60c5")
    public ResponseData<List<QueryMedicationVo>> queryMedicationDetails(@RequestBody @Valid OutpatientInfomationDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        if (StringUtil.isBlank((String)parameter.getWarehouse())) {
            parameter.setWarehouse(this.commonRequest.getDrugRoomId());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPrescriptionService.queryMedicationDetails(parameter);
    }

    @PostMapping(value={"/v1/dispenseMedicine"})
    @Operation(description="\u53d1\u836f")
    @ApiOperation(value="\u53d1\u836f", httpMethod="POST", notes="\u53d1\u836f")
    public ResponseData<String> dispenseMedicine(@RequestBody @Valid OutPrescriptionDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPrescriptionService.dispenseMedicine(parameter);
    }

    @PostMapping(value={"/v1/withdrawalOfMedication"})
    @Operation(description="\u9000\u836f")
    @ApiOperation(value="\u9000\u836f", httpMethod="POST", notes="\u9000\u836f")
    public ResponseData<String> withdrawalOfMedication(@RequestBody @Valid OutPrescriptionDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPrescriptionService.withdrawalOfMedication(parameter);
    }
}

