/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.ReceivingInformationDto;
import com.byh.outpatient.api.model.ReceivingInformationEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.ReceivingInformationService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/receivingInformation"})
public class ReceivingInformationController {
    @Autowired
    private ReceivingInformationService receivingInformationService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/v1/saveReceivingInformation"})
    @Operation(description="\u4fdd\u5b58\u6536\u8d27\u4fe1\u606f")
    @ApiOperation(value="\u4fdd\u5b58\u6536\u8d27\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6536\u8d27\u4fe1\u606f")
    public ResponseData saveReceivingInformation(@RequestBody @Valid ReceivingInformationEntity parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        Integer patientId = parameter.getPatientId();
        if (patientId == null) {
            return ResponseData.error((String)"\u60a3\u8005id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.receivingInformationService.saveReceivingInformation(parameter);
    }

    @PostMapping(value={"/v1/delReceivingInformation"})
    @Operation(description="\u5220\u9664\u6536\u8d27\u4fe1\u606f")
    @ApiOperation(value="\u5220\u9664\u6536\u8d27\u4fe1\u606f", httpMethod="POST", notes="\u5220\u9664\u6536\u8d27\u4fe1\u606f")
    public ResponseData delReceivingInformation(@RequestBody @Valid ReceivingInformationEntity parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.receivingInformationService.delReceivingInformation(parameter);
    }

    @PostMapping(value={"/v1/editReceivingInformation"})
    @Operation(description="\u7f16\u8f91\u6536\u8d27\u4fe1\u606f")
    @ApiOperation(value="\u7f16\u8f91\u6536\u8d27\u4fe1\u606f", httpMethod="POST", notes="\u7f16\u8f91\u6536\u8d27\u4fe1\u606f")
    public ResponseData editReceivingInformation(@RequestBody @Valid ReceivingInformationEntity parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.receivingInformationService.editReceivingInformation(parameter);
    }

    @PostMapping(value={"/v1/receivingInformationList"})
    @Operation(description="\u67e5\u8be2\u6536\u8d27\u4fe1\u606f\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u6536\u8d27\u4fe1\u606f\u5217\u8868", httpMethod="POST", notes="\u67e5\u8be2\u6536\u8d27\u4fe1\u606f\u5217\u8868")
    public ResponseData<PageInfo<ReceivingInformationEntity>> receivingInformationList(@RequestBody @Valid ReceivingInformationDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.receivingInformationService.receivingInformationList(parameter);
    }

    @PostMapping(value={"/v1/searchReceivingInformationById"})
    @Operation(description="\u6839\u636eid\u67e5\u8be2\u6536\u8d27\u4fe1\u606f")
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u6536\u8d27\u4fe1\u606f", httpMethod="POST", notes="\u6839\u636eid\u67e5\u8be2\u6536\u8d27\u4fe1\u606f")
    public ResponseData<ReceivingInformationEntity> searchReceivingInformationById(@RequestBody @Valid ReceivingInformationEntity parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.receivingInformationService.searchReceivingInformationById(parameter);
    }

    @PostMapping(value={"/v1/searchReceivingInformationByPatientId"})
    @Operation(description="\u6839\u636e\u60a3\u8005id\u67e5\u8be2\u6536\u8d27\u4fe1\u606f")
    @ApiOperation(value="\u6839\u636e\u60a3\u8005id\u67e5\u8be2\u6536\u8d27\u4fe1\u606f", httpMethod="POST", notes="\u6839\u636e\u60a3\u8005id\u67e5\u8be2\u6536\u8d27\u4fe1\u606f")
    public ResponseData<List<ReceivingInformationEntity>> searchReceivingInformationByPatientId(@RequestBody @Valid ReceivingInformationEntity parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.receivingInformationService.searchReceivingInformationByPatientId(parameter);
    }
}

