/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.dto.infusionOfFluids.SaveInfusionOfFluidsDetailDto;
import com.byh.outpatient.api.dto.infusionOfFluids.SaveInfusionOfFluidsDto;
import com.byh.outpatient.api.enums.AdmissionStatusEnum;
import com.byh.outpatient.api.enums.GenderEnum;
import com.byh.outpatient.api.enums.PrescriptionTypeEnum;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.model.infusionOfFluids.OutInfusionOfFluidsEntity;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.vo.hsSettlement.DictValueVo;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.OutHsSettlementInfoMapper;
import com.byh.outpatient.data.repository.OutInfusionOfFluidsMapper;
import com.byh.outpatient.data.repository.OutInfusionOfFluidsRecordMapper;
import com.byh.outpatient.web.service.OutInfusionOfFluidsService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OutInfusionOfFluidsServiceImpl
implements OutInfusionOfFluidsService {
    private static final Logger log = LoggerFactory.getLogger(OutInfusionOfFluidsServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(OutInfusionOfFluidsServiceImpl.class);
    @Resource
    private OutInfusionOfFluidsMapper outInfusionOfFluidsMapper;
    @Resource
    private OutInfusionOfFluidsRecordMapper outInfusionOfFluidsRecordMapper;
    @Resource
    private AdmissionMapper admissionMapper;
    @Resource
    private OutHsSettlementInfoMapper outHsSettlementInfoMapper;

    @Transactional(rollbackFor={BusinessException.class})
    public void insertInfusionOfFluids(SaveInfusionOfFluidsDto dto) {
        Integer tenantId = dto.getTenantId();
        String prescNo = dto.getPrescriptionNo();
        Integer operatorId = dto.getOperatorId();
        String operatorName = dto.getOperatorName();
        Integer prescriptionTypeCode = dto.getPrescriptionType();
        if (!PrescriptionTypeEnum.WESTERN_MEDICINE.getValue().equals(prescriptionTypeCode)) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u95e8\u8bca\u5904\u65b9\u7c7b\u578b\u7f16\u7801\u9519\u8bef\uff01\u5e94\u4e3a\uff1a1\u3001\u897f\u836f\uff0c\u5b9e\u9645\u4e3a\uff1a" + prescriptionTypeCode));
        }
        ArrayList<String> dictTypes = new ArrayList<String>(Arrays.asList("we_medicine_usage", "usage_unit"));
        List dictValueVos = this.outHsSettlementInfoMapper.selectDictListByTypes(dictTypes, tenantId);
        Map<String, Map<String, String>> dictDataMap = dictValueVos.stream().collect(Collectors.groupingBy(DictValueVo::getType, Collectors.toMap(DictValueVo::getValue, DictValueVo::getLabel, (existing, replacement) -> existing)));
        List detailDtoList = dto.getDetailList();
        for (SaveInfusionOfFluidsDetailDto detail : detailDtoList) {
            String drugId = detail.getDrugsId();
            String drugName = detail.getDrugsName();
            String usageCode = detail.getUsageCode();
            Map drugUsageMap = this.getDictMap(dictDataMap, "we_medicine_usage");
            String usageName = drugUsageMap.getOrDefault(usageCode, "");
            if (StrUtil.isEmpty((CharSequence)usageName)) {
                String errorInfo = String.format("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u836f\u54c1\u7528\u6cd5\u7f16\u7801\u9519\u8bef\uff01\u836f\u54c1\u540d\u79f0\uff1a\uff08%s\u3001%s\uff09\uff0c\u5b57\u5178\u7f16\u7801\uff1awe_medicine_usage\uff01\u7f16\u7801\u503c\uff1a%s\uff01", drugId, drugName, usageCode);
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo);
            }
            detail.setDrugUsage(usageName);
            String doseUnitCode = detail.getDoseUnitCode();
            Map doseUnitMap = this.getDictMap(dictDataMap, "usage_unit");
            String doseUnitName = doseUnitMap.getOrDefault(doseUnitCode, "");
            if (StrUtil.isEmpty((CharSequence)doseUnitName)) {
                String errorInfo = String.format("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u836f\u54c1\u5355\u6b21\u5242\u91cf\u5355\u4f4d\u7f16\u7801\u9519\u8bef\uff01\u836f\u54c1\u540d\u79f0\uff1a\uff08%s\u3001%s\uff09\uff0c\u5b57\u5178\u7f16\u7801\uff1ausage_unit\uff01\u7f16\u7801\u503c\uff1a%s\uff01", drugId, drugName, doseUnitCode);
                ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo);
            }
            detail.setDoseUnit(doseUnitName);
        }
        AdmissionEntity admission = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AdmissionEntity::getTenantId, (Object)tenantId)).eq(AdmissionEntity::getOutpatientNo, (Object)dto.getOutpatientNo()));
        if (admission == null) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u6839\u636e\u95e8\u8bca\u53f7\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6302\u53f7\u8bb0\u5f55\uff01");
        }
        Integer admissionStatus = admission.getStatus();
        String outpatientNo = admission.getOutpatientNo();
        if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admissionStatus) || AdmissionStatusEnum.DOCTOR_CANCEL.getValue().equals(admissionStatus) || AdmissionStatusEnum.PATIENT_CANCEL.getValue().equals(admissionStatus) || AdmissionStatusEnum.RETIRMENT.getValue().equals(admissionStatus)) {
            String admissionStatusLabel = Optional.ofNullable(AdmissionStatusEnum.getDesc((Integer)admissionStatus)).orElse("\u6302\u53f7\u72b6\u6001\u5f02\u5e38\uff01");
            String errorInfo = String.format("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u5bf9\u5e94\u7684\u6302\u53f7\u8bb0\u5f55\u72b6\u6001\u5f02\u5e38\uff01\u5b9e\u9645\u4e3a\uff1a\uff08%s\u3001%s\uff09\uff0c\u95e8\u8bca\u53f7\uff1a%s", admissionStatus, admissionStatusLabel, outpatientNo);
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)errorInfo);
        }
        Integer patientId = admission.getPatientId();
        String patientName = admission.getPatientName();
        Integer patientAge = admission.getPatientAge();
        String genderCode = admission.getPatientSex();
        String genderName = Optional.ofNullable(GenderEnum.getEnum((Integer)Integer.valueOf(genderCode))).map(GenderEnum::getDesc).orElse("");
        if (StrUtil.isEmpty((CharSequence)genderName)) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u751f\u6210\u8f93\u6db2\u5355\u65f6\uff0c\u60a3\u8005\u6027\u522b\u7f16\u7801\u5f02\u5e38\uff01\u5e94\u4e3a\uff1a1\u3001\u7537\uff0c2\u3001\u5973\uff0c\u5b9e\u9645\u4e3a\uff1a" + genderCode));
        }
        Integer visitDeptId = admission.getDeptId();
        String visitDeptName = admission.getDeptName();
        Integer visitDoctorId = admission.getDoctorId();
        String visitDoctorName = admission.getDoctorName();
        ArrayList<OutInfusionOfFluidsEntity> infusionOfFluidsList = new ArrayList<OutInfusionOfFluidsEntity>();
        for (SaveInfusionOfFluidsDetailDto detail : detailDtoList) {
            OutInfusionOfFluidsEntity infusionOfFluids = new OutInfusionOfFluidsEntity();
            infusionOfFluids.setTenantId(tenantId);
            infusionOfFluids.setCreateId(operatorId);
            infusionOfFluids.setCreateName(operatorName);
            infusionOfFluids.setOutpatientNo(outpatientNo);
            infusionOfFluids.setPrescriptionNo(prescNo);
            infusionOfFluids.setGroupNo(detail.getGroupNo());
            infusionOfFluids.setDrugId(detail.getDrugsId());
            infusionOfFluids.setDrugName(detail.getDrugsName());
            infusionOfFluids.setDrugSpec(detail.getSpecifications());
            infusionOfFluids.setSingleDose(detail.getSingleDose());
            infusionOfFluids.setDoseUnitCode(detail.getDoseUnitCode());
            infusionOfFluids.setDoseUnitName(detail.getDoseUnit());
            infusionOfFluids.setUsageCode(detail.getUsageCode());
            infusionOfFluids.setUsageName(detail.getDrugUsage());
            infusionOfFluids.setDrippingVelocity(detail.getDrippingVelocity());
            infusionOfFluids.setPatientId(patientId);
            infusionOfFluids.setPatientName(patientName);
            infusionOfFluids.setPatientAge(patientAge);
            infusionOfFluids.setGenderCode(genderCode);
            infusionOfFluids.setGenderName(genderName);
            infusionOfFluids.setVisitDeptId(visitDeptId);
            infusionOfFluids.setVisitDeptName(visitDeptName);
            infusionOfFluids.setVisitDoctorId(visitDoctorId);
            infusionOfFluids.setVisitDoctorName(visitDoctorName);
            infusionOfFluidsList.add(infusionOfFluids);
        }
        System.out.println();
    }

    private Map<String, String> getDictMap(Map<String, Map<String, String>> dictDataMap, String type) {
        Map<String, String> dictMap;
        if (StrUtil.isEmpty((CharSequence)type)) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u67e5\u8be2\u5b57\u5178\u5217\u8868\u65f6\uff0c\u4f20\u9012\u7684\u5b57\u5178\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if ((dictMap = dictDataMap.get(type)) == null) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)("\u67e5\u8be2\u5b57\u5178\u5217\u8868\u4fe1\u606f\u65f6\uff0c\u6839\u636e\u5b57\u5178\u7c7b\u578b\u6ca1\u6709\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u5b57\u5178\u660e\u7ec6\u5217\u8868\uff0c\u8bf7\u5148\u8fdb\u884c\u7ef4\u62a4\uff01\u5b57\u5178\u7c7b\u578b\uff1a" + type));
        }
        return dictMap;
    }
}

