/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.dto.admission.DirectReceptionDto;
import com.byh.outpatient.api.dto.admission.OutVisitAllRecordDto;
import com.byh.outpatient.api.dto.admission.OutVisitRecordDto;
import com.byh.outpatient.api.dto.admission.OutpatientWorkloadDto;
import com.byh.outpatient.api.dto.admission.QueryAdmissionDto;
import com.byh.outpatient.api.dto.admission.QueryAdmissionPatientDto;
import com.byh.outpatient.api.dto.admission.QueryReadyVisitDto;
import com.byh.outpatient.api.dto.admission.QueryRevenueDto;
import com.byh.outpatient.api.dto.admission.QuickTreatementDto;
import com.byh.outpatient.api.dto.medicalRecord.OutpatientInfomationDto;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.admission.AdmissionDetailVo;
import com.byh.outpatient.api.vo.admission.AdmissionPatientVo;
import com.byh.outpatient.api.vo.admission.QueryReadyVisitVo;
import com.byh.outpatient.api.vo.admission.RegFormDataVo;
import com.byh.outpatient.web.aspect.AntiRefresh;
import com.byh.outpatient.web.aspect.UserOptLogger;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.AdmissionService;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admission"})
public class AdmissionController {
    @Autowired
    private AdmissionService admissionService;
    @Autowired
    private CommonRequest commonRequest;

    @ApiModelProperty(value="\u6839\u636e\u6761\u4ef6\u5bfc\u51fa\u6307\u5b9a\u7684\u60a3\u8005\u5386\u53f2\u8bca\u65ad\u5217\u8868\u4fe1\u606f")
    @PostMapping(value={"/exportPatientHistoryDiag"})
    public void exportPatientHistoryDiag(HttpServletResponse response, @RequestBody OutVisitAllRecordDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.admissionService.exportPatientHistoryDiag(response, dto);
    }

    @ApiOperation(value="\u5bfc\u51fa\u533b\u751f/\u79d1\u5ba4\u7684\u6536\u5165\u4fe1\u606f")
    @PostMapping(value={"/exportRevenue"})
    public void exportRevenue(HttpServletResponse response, @RequestBody @Valid QueryRevenueDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.admissionService.exportRevenue(response, dto);
    }

    @ApiOperation(value="\u83b7\u53d6\u672c\u5e74\u5ea6\u7684\u603b\u8ba1\u6536\u5165")
    @PostMapping(value={"/getYearTotalRevenue"})
    public ResponseData getYearTotalRevenue() {
        return ResponseData.success((Object)this.admissionService.getYearTotalRevenue(this.commonRequest.getTenant()));
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u751f/\u79d1\u5ba4\u7684\u6536\u5165\u4fe1\u606f")
    @PostMapping(value={"/selectRevenueList"})
    public ResponseData selectRevenueList(@RequestBody QueryRevenueDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.admissionService.selectRevenueList(dto));
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u751f\u7684\u5f85\u63a5\u8bca\u4fe1\u606f")
    @PostMapping(value={"/selectReadyVisitList"})
    public List<QueryReadyVisitVo> selectReadyVisitList(@RequestBody QueryReadyVisitDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return this.admissionService.selectReadyVisitList(dto);
    }

    @ApiOperation(value="\u5bfc\u51fa\u95e8\u8bca\u533b\u751f\u5de5\u4f5c\u91cf")
    @PostMapping(value={"/exportOutpatientWorkload"})
    public void exportOutpatientWorkload(HttpServletResponse response, @RequestBody OutpatientWorkloadDto dto) {
        dto.setDoctorId(this.commonRequest.getUserId());
        dto.setTenantId(this.commonRequest.getTenant());
        this.admissionService.exportOutpatientWorkload(response, dto);
    }

    @ApiOperation(value="\u67e5\u8be2\u95e8\u8bca\u533b\u751f\u7ad9\u5de5\u4f5c\u91cf")
    @PostMapping(value={"/selectOutpatientWorkload"})
    @AntiRefresh
    public ResponseData selectOutpatientWorkload(@RequestBody OutpatientWorkloadDto dto) {
        dto.setDoctorId(this.commonRequest.getUserId());
        dto.setTenantId(this.commonRequest.getTenant());
        List list = this.admissionService.selectOutpatientWorkload(dto);
        return ResponseData.success((Object)list);
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u6240\u6709\u7684\u95e8\u8bca\u75c5\u5386\u5217\u8868\u6570\u636e\uff08\u5305\u542b\u4e1c\u8f6f\u7cfb\u7edf\u3001HIS\u7cfb\u7edf\uff09")
    @PostMapping(value={"/selectAllList"})
    @AntiRefresh
    public ResponseData selectAllList(@RequestBody OutVisitAllRecordDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.admissionService.selectAllList(dto));
    }

    @ApiOperation(value="\u95e8\u8bca\u533b\u751f\u63a5\u8bca\u6b21\u6570\u7edf\u8ba1\u5bfc\u51fa")
    @PostMapping(value={"/exportOutVisitCount"})
    @AntiRefresh
    public void exportOutVisitCount(HttpServletResponse response, @RequestBody OutVisitRecordDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.admissionService.exportOutVisitCount(response, dto);
    }

    @ApiOperation(value="\u65b0\u60a3\u8005\u4fe1\u606f\u5bfc\u51fa")
    @PostMapping(value={"/exportNewPatientInfo"})
    @AntiRefresh
    public void exportNewPatientInfo(HttpServletResponse response, @RequestBody OutVisitRecordDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.admissionService.exportNewPatientInfo(response, dto);
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u533b\u7597\u673a\u6784\u95e8\u8bca\u65e5\u5fd7\u5217\u8868\u4fe1\u606f")
    @PostMapping(value={"/selectOutVisitRecordList"})
    @AntiRefresh
    public ResponseData selectOutVisitRecordList(@RequestBody OutVisitRecordDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        Page page = this.admissionService.selectOutVisitRecordList(dto);
        return ResponseData.success((Object)page);
    }

    @PostMapping(value={"/registration"})
    @UserOptLogger(operation="\u6302\u53f7\u767b\u8bb0")
    @ApiOperation(value="\u6302\u53f7\u767b\u8bb0", httpMethod="POST", notes="\u6302\u53f7\u767b\u8bb0")
    public ResponseData registration(@RequestBody QuickTreatementDto quickTreatementDto) {
        Integer tenantId = quickTreatementDto.getTenantId() == null ? this.commonRequest.getTenant() : quickTreatementDto.getTenantId();
        quickTreatementDto.setTenantId(tenantId);
        return this.admissionService.registration(quickTreatementDto);
    }

    @PostMapping(value={"/createPatient"})
    @UserOptLogger(operation="\u81ea\u52a9\u673a\u5efa\u6863")
    @ApiOperation(value="\u81ea\u52a9\u673a\u5efa\u6863", httpMethod="POST", notes="\u81ea\u52a9\u673a\u5efa\u6863")
    public ResponseData createPatient(@RequestBody QuickTreatementDto quickTreatementDto) {
        try {
            Integer tenantId = quickTreatementDto.getTenantId() == null ? this.commonRequest.getTenant() : quickTreatementDto.getTenantId();
            quickTreatementDto.setTenantId(tenantId);
            return ResponseData.success((Object)this.admissionService.createPatient(quickTreatementDto));
        }
        catch (Exception e) {
            return ResponseData.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/queryRegFee"})
    @ApiOperation(value="\u67e5\u8be2\u6302\u53f7\u8d39", httpMethod="GET", notes="\u67e5\u8be2\u6302\u53f7\u8d39")
    public ResponseData queryRegFee(@RequestParam(value="outpatientType", required=true) String outpatientType) {
        Integer tenantId = this.commonRequest.getTenant();
        return this.admissionService.queryRegFee(outpatientType, tenantId);
    }

    @UserOptLogger(operation="\u5feb\u901f\u63a5\u8bca")
    @PostMapping(value={"/quickTreatement"})
    @ApiOperation(value="\u5feb\u901f\u63a5\u8bca", httpMethod="POST", notes="\u5feb\u901f\u63a5\u8bca")
    public ResponseData<AdmissionPatientVo> quickTreatement(@RequestBody QuickTreatementDto quickTreatementDto) {
        Integer tenantId = this.commonRequest.getTenant();
        quickTreatementDto.setTenantId(tenantId);
        quickTreatementDto.setOperatorId(this.commonRequest.getUserId());
        quickTreatementDto.setOperatorName(this.commonRequest.getUserName());
        return this.admissionService.quickTreatement(quickTreatementDto);
    }

    @UserOptLogger(operation="\u5220\u9664\u6302\u53f7\u767b\u8bb0\u8bb0\u5f55")
    @GetMapping(value={"/deleteById"})
    @ApiOperation(value="\u5220\u9664\u6302\u53f7\u767b\u8bb0\u8bb0\u5f55", httpMethod="GET", notes="\u5220\u9664\u6302\u53f7\u767b\u8bb0\u8bb0\u5f55")
    public ResponseData deleteById(@RequestParam(value="id", required=true) Integer id) {
        return this.admissionService.deleteById(id.intValue());
    }

    @PostMapping(value={"/updateById"})
    @ApiOperation(value="\u66f4\u65b0\u6302\u53f7\u767b\u8bb0", httpMethod="POST", notes="\u66f4\u65b0\u6302\u53f7\u767b\u8bb0")
    public ResponseData updateById(@RequestBody AdmissionEntity admission) {
        admission.setUpdateId(this.commonRequest.getUserId());
        admission.setUpdateName(this.commonRequest.getUserName());
        return this.admissionService.updateById(admission);
    }

    @GetMapping(value={"/queryById"})
    @ApiOperation(value="\u67e5\u8be2\u6302\u53f7\u767b\u8bb0\u8bb0\u5f55", httpMethod="GET", notes="\u67e5\u8be2\u6302\u53f7\u767b\u8bb0\u8bb0\u5f55")
    public ResponseData<AdmissionDetailVo> queryById(@RequestParam(value="id", required=true) Integer id) {
        return this.admissionService.queryById(id.intValue());
    }

    @GetMapping(value={"/queryByOutpatientNo"})
    @ApiOperation(value="\u6839\u636e\u5c31\u8bca\u53f7\u67e5\u8be2\u6302\u53f7\u767b\u8bb0\u8bb0\u5f55", httpMethod="GET", notes="\u67e5\u8be2\u6302\u53f7\u767b\u8bb0\u8bb0\u5f55")
    public ResponseData<AdmissionDetailVo> queryByOutpatientNo(@RequestParam(value="outpatientNo", required=true) String outpatientNo) {
        Integer tenantId = this.commonRequest.getTenant();
        return this.admissionService.queryByOutpatientNo(outpatientNo, tenantId);
    }

    @PostMapping(value={"/queryAdmission"})
    @ApiOperation(value="\u67e5\u8be2\u6302\u53f7\u767b\u8bb0\u8bb0\u5f55\u5217\u8868", httpMethod="POST", notes="\u67e5\u8be2\u6302\u53f7\u767b\u8bb0\u8bb0\u5f55\u5217\u8868")
    public ResponseData<PageResult<AdmissionPatientVo>> queryAdmission(@RequestBody QueryAdmissionDto queryAdmissionDto) {
        Integer tenantId = this.commonRequest.getTenant();
        queryAdmissionDto.setTenantId(tenantId);
        return this.admissionService.queryAdmission(queryAdmissionDto);
    }

    @PostMapping(value={"/queryAdmissionPatient"})
    @ApiOperation(value="\u4eca\u65e5\u60a3\u8005", httpMethod="POST", notes="\u4eca\u65e5\u60a3\u8005")
    public ResponseData<AdmissionPatientVo> queryAdmissionPatient(@RequestBody QueryAdmissionPatientDto queryTodayPatientDto) {
        queryTodayPatientDto.setTenantId(this.commonRequest.getTenant());
        return this.admissionService.queryTodayAdmissionPatient(queryTodayPatientDto);
    }

    @PostMapping(value={"/queryHistoryAdmissionPatient"})
    @ApiOperation(value="\u5386\u53f2\u60a3\u8005\u5c31\u8bca\u6570\u636e", httpMethod="POST", notes="\u5386\u53f2\u60a3\u8005\u5c31\u8bca\u6570\u636e")
    public ResponseData<PageResult<AdmissionPatientVo>> queryHistoryAdmissionPatient(@RequestBody QueryAdmissionDto queryAdmissionDto) {
        return this.admissionService.queryHistoryAdmissionPatient(queryAdmissionDto);
    }

    @UserOptLogger(operation="\u63a5\u8bca")
    @PostMapping(value={"/v1/directReception"})
    @ApiOperation(value="\u76f4\u63a5\u63a5\u8bca", httpMethod="POST", notes="\u63a5\u8bca")
    public ResponseData<String> directReception(@RequestBody @Valid DirectReceptionDto directReceptionDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        directReceptionDto.setTenantId(this.commonRequest.getTenant());
        directReceptionDto.setOperatorId(this.commonRequest.getUserId());
        directReceptionDto.setOperatorName(this.commonRequest.getUserName());
        return this.admissionService.directReception(directReceptionDto);
    }

    @PostMapping(value={"/v1/archiving"})
    @Operation(description="\u5f52\u6863")
    @ApiOperation(value="\u5f52\u6863", httpMethod="POST", notes="\u5f52\u6863")
    public ResponseData<String> archiving(@RequestBody @Valid OutpatientInfomationDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.admissionService.archiving(parameter);
    }

    @GetMapping(value={"/v1/regFormData"})
    @Operation(description="\u6302\u53f7\u5355\u6253\u5370\u6570\u636e")
    @ApiOperation(value="\u6302\u53f7\u5355\u6253\u5370\u6570\u636e", httpMethod="GET", notes="\u6302\u53f7\u5355\u6253\u5370\u6570\u636e")
    public ResponseData<RegFormDataVo> regFormData(@RequestParam(value="admIdOrOutpatientNo", required=true) String admIdOrOutpatientNo) {
        return this.admissionService.regFormData(admIdOrOutpatientNo, this.commonRequest.getTenant());
    }
}

